/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

public enum FileOffsetError {
    SPECIFIED_DATA_NOT_FOUND(-1L),
    EOF(-2L),
    IO_EXCEPTION(-3L),
    INVALID_ARGUMENTS(-4L),
    UNKNOWN(Long.MIN_VALUE);

    private final long _errorCode;

    private FileOffsetError(long errorCode) {
        this._errorCode = errorCode;
    }

    public long getErrorCode() {
        return this._errorCode;
    }

    public static FileOffsetError identify(long errorCode) {
        if (errorCode >= 0L) {
            return null;
        }
        for (FileOffsetError error : FileOffsetError.values()) {
            if (error.getErrorCode() != errorCode) continue;
            return error;
        }
        return UNKNOWN;
    }
}

