/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.FileOffsetError;
import java.io.Serializable;

public class FileOffsets
implements Serializable {
    private static final long serialVersionUID = -6720485747836103310L;
    private final long _startOffset;
    private final long _endOffset;
    private final FileOffsetError _startError;
    private final FileOffsetError _endError;

    public FileOffsets(long startOffset, long endOffset) {
        this._startOffset = startOffset;
        this._endOffset = endOffset;
        this._startError = FileOffsetError.identify(startOffset);
        this._endError = FileOffsetError.identify(endOffset);
    }

    public FileOffsets(long startOffset, FileOffsetError endError) {
        this(startOffset, endError.getErrorCode());
    }

    public FileOffsets(FileOffsetError startError, int endOffset) {
        this(startError.getErrorCode(), (long)endOffset);
    }

    public FileOffsets(FileOffsetError startError, FileOffsetError endError) {
        this(startError.getErrorCode(), endError.getErrorCode());
    }

    public long getStartOffset() {
        return this._startOffset;
    }

    public long getEndOffset() {
        return this._endOffset;
    }

    public FileOffsetError getStartError() {
        return this._startError;
    }

    public FileOffsetError getEndError() {
        return this._endError;
    }
}

