/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import java.io.Serializable;
import java.util.StringTokenizer;

public class FilePath
implements Serializable {
    private String _path = "temp.tmp";
    private String _localPath = "temp.tmp";
    private String _pathToFile = "";
    private String _netDelimiter = "//";
    private String _extension = "tmp";
    private String _fileName = "temp";
    private String _serverName = null;
    private String _serverPort;
    private String _serverResource = null;
    private String _remotePathWhenCached = null;
    private boolean _local = true;

    public FilePath(String path) {
        this();
        this._path = path;
        this._remotePathWhenCached = null;
        this.parse();
    }

    public FilePath(String path, String remoteCached) {
        this();
        this._path = path;
        this._remotePathWhenCached = remoteCached;
        this.parse();
    }

    public FilePath() {
    }

    private void parse() {
        if (this._path != null && this._path.length() > 2 && this._path.substring(0, 2).equals(this._netDelimiter)) {
            this._local = false;
            StringTokenizer st = new StringTokenizer(this._path.substring(2), "/");
            this._serverName = "//";
            this._serverName = this._serverName + st.nextToken();
            int portIndex = this._serverName.lastIndexOf(":");
            if (portIndex > -1) {
                this._serverPort = this._serverName.substring(portIndex);
            }
            this._serverResource = "/";
            this._serverResource = this._serverResource + st.nextToken();
            Object pathFileExtension = "";
            while (st.hasMoreTokens()) {
                pathFileExtension = (String)pathFileExtension + "/";
                pathFileExtension = (String)pathFileExtension + st.nextToken();
            }
            this.setFileAndExt((String)pathFileExtension, 1);
            this._localPath = "temp.tmp";
        } else {
            this._local = true;
            this.setFileAndExt(this._path, 0);
            this._localPath = this._path;
        }
    }

    public String getPath() {
        return this._localPath;
    }

    public boolean getLocal() {
        return this._local;
    }

    public String getRMIUrl() {
        return this._serverName + this._serverResource;
    }

    public String getRemoteNonCachedPath() {
        return this._remotePathWhenCached;
    }

    public String getPathAndFileAndExtension() {
        return this._pathToFile + this._fileName + this._extension;
    }

    private void setFileAndExt(String pathFileExtension, int startPos) {
        int startOfFileName = pathFileExtension.lastIndexOf("/") + 1;
        this._pathToFile = pathFileExtension.substring(startPos, startOfFileName);
        String fileNameAndExt = pathFileExtension.substring(startOfFileName);
        int extensionStarts = fileNameAndExt.lastIndexOf(".");
        if (extensionStarts != -1) {
            this._fileName = fileNameAndExt.substring(0, extensionStarts);
            this._extension = fileNameAndExt.substring(extensionStarts);
        } else {
            this._fileName = fileNameAndExt;
            this._extension = "";
        }
    }
}

