/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.Identifier;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDialog;

public class FilePropertiesJDialog
extends RmaJDialog {
    public static final String[][] FILE_TYPES = new String[][]{{".dss", "HEC DSS File"}, {".wksp", "Watershed Configuration File"}, {".conf", "Child workspace Configuration File"}, {".tsl", "Time Series Location Set File"}};
    JLabel fileTypeIcon;
    JLabel fileName;
    JLabel size;
    JLabel modified;
    JLabel type;
    JLabel location;
    RmaJCheckBox readOnly;
    RmaJCheckBox hidden;

    public FilePropertiesJDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.buildComponents();
    }

    public FilePropertiesJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildComponents();
    }

    private void buildComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(350, 250);
        this.setLocation();
        this.registerEscapeKey(true);
        this.setCancelButtonSearchString("Close");
        Insets insets = new Insets(5, 5, 0, 0);
        JTabbedPane generalTab = new JTabbedPane();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)generalTab, gbc);
        JPanel generalPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        generalTab.addTab("General", generalPanel);
        this.fileTypeIcon = new JLabel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        generalPanel.add((Component)this.fileTypeIcon, gbc);
        this.fileName = new JLabel("");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        generalPanel.add((Component)this.fileName, gbc);
        JSeparator sep = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        generalPanel.add((Component)sep, gbc);
        JLabel label = new JLabel("Type:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = insets;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        generalPanel.add((Component)label, gbc);
        this.type = new JLabel("");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = insets;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        generalPanel.add((Component)this.type, gbc);
        label = new JLabel("Location:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = insets;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        generalPanel.add((Component)label, gbc);
        this.location = new JLabel("");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = insets;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        generalPanel.add((Component)this.location, gbc);
        label = new JLabel("Size:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.insets = insets;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        generalPanel.add((Component)label, gbc);
        this.size = new JLabel("");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.insets = insets;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        generalPanel.add((Component)this.size, gbc);
        label = new JLabel("Last Modified:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.insets = insets;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        generalPanel.add((Component)label, gbc);
        this.modified = new JLabel("");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.insets = insets;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        generalPanel.add((Component)this.modified, gbc);
        sep = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.insets = insets;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        generalPanel.add((Component)sep, gbc);
        label = new JLabel("Attributes:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.insets = insets;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        generalPanel.add((Component)label, gbc);
        JPanel attributesPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.insets = insets;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        generalPanel.add((Component)attributesPanel, gbc);
        this.readOnly = new RmaJCheckBox("Read Only");
        this.readOnly.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.fill = 0;
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        attributesPanel.add((Component)this.readOnly, gbc);
        this.hidden = new RmaJCheckBox("Hidden");
        this.hidden.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 15, 0, 0);
        gbc.fill = 0;
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        attributesPanel.add((Component)this.hidden, gbc);
        JButton closeButton = new JButton("Close");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = insets;
        gbc.fill = 0;
        gbc.anchor = 14;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)closeButton, gbc);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilePropertiesJDialog.this.setVisible(false);
                FilePropertiesJDialog.this.dispose();
            }
        });
    }

    @Override
    public void clearForm() {
        super.clearForm();
        this.fileTypeIcon.setIcon(null);
        this.fileName.setText("");
        this.size.setText("");
        this.modified.setText("");
        this.type.setText("");
        this.location.setText("");
    }

    public void fillForm(Identifier id) {
        this.clearForm();
        if (id == null) {
            return;
        }
        this.setTitle(id.getName() + " Properties");
        this.fileName.setText(id.getName());
        this.size.setText("" + id.length());
        this.modified.setText(new Date(id.lastModified()).toString());
        this.readOnly.setSelected(id.isReadOnly());
        this.hidden.setSelected(id.isHidden());
        Icon icon = null;
        if (id._directory) {
            try {
                icon = UIManager.getIcon("FileView.directoryIcon");
            }
            catch (Exception e) {
                icon = null;
            }
            this.type.setText("File Folder");
        } else {
            try {
                icon = UIManager.getIcon("FileView.fileIcon");
            }
            catch (Exception e) {
                icon = null;
            }
            for (int i = 0; i < FILE_TYPES.length; ++i) {
                if (!id.getName().endsWith(FILE_TYPES[i][0])) continue;
                this.type.setText(FILE_TYPES[i][1]);
                break;
            }
            if (this.type.getText().equals("")) {
                this.type.setText("File");
            }
        }
        this.fileTypeIcon.setIcon(icon);
        this.location.setText(id.getPath());
        this.pack();
    }

    public static void main(String[] args) {
        Identifier id = new Identifier("/apps/jar");
        File file = new File(id.getPath());
        id.initToFile(file);
        id._name = "jar";
        FilePropertiesJDialog dialog = new FilePropertiesJDialog(new Frame(), false);
        dialog.fillForm(id);
        dialog.setVisible(true);
    }
}

