/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;

public class FileTypesFilter
implements FileFilter {
    String[] types;

    public FileTypesFilter(String[] types) {
        this.types = types;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        for (String type : this.types) {
            if (!f.getName().endsWith(type)) continue;
            return true;
        }
        return false;
    }

    public static void populateFiles(File file, ArrayList<File> files, FileFilter filter) {
        File[] all;
        for (File f : all = file.listFiles(filter)) {
            if (f.isDirectory()) {
                FileTypesFilter.populateFiles(f, files, filter);
                continue;
            }
            files.add(f);
        }
    }
}

