/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.GridCellFileEntry;
import hec.io.Identifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import rma.util.RMAIO;

public class GridCellFile {
    public static final String SUBBASIN = "SUBBASIN";
    public static final String GRIDCELL = "GRIDCELL";
    public static final String END = "END";
    public static final String PARAMETER_ORDER = "PARAMETER ORDER";
    public static final String XCOORD = "xcoord";
    public static final String YCOORD = "ycoord";
    public static final String TRAVEL_LENGTH = "travellength";
    public static final String AREA = "area";
    public static final String SCSCN = "scscn";
    public static final String SMAUNIT = "smaunit";
    public static final int DEFAULT_TOKENS = 4;
    private Vector<GridCellFileEntry> _entries = new Vector();
    private String _fileName;
    private boolean _defaultOrder = true;
    private Vector<String> _paramList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readFile(Identifier id) {
        if (id == null) {
            System.out.println("readFile: null Identifier received");
            return false;
        }
        if (id.getFile() == null) {
            System.out.println("readFile: null File in Identifier");
            return false;
        }
        BufferedReader reader = null;
        try {
            boolean rv;
            reader = id.getFile().getBufferedReader();
            System.out.println("reading " + id.getFile().getPath());
            boolean bl = rv = this.readFile(reader);
            return bl;
        }
        catch (IOException ioe) {
            System.out.println("readFile: IOError reading " + id.getFile().getPath() + " Error " + ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean readFile(BufferedReader reader) throws IOException {
        String line;
        if (reader == null) {
            System.out.println("readFile: null reader received");
            return false;
        }
        GridCellFileEntry entry = null;
        int lineCnt = 0;
        while ((line = reader.readLine()) != null) {
            ++lineCnt;
            if ((line = line.toUpperCase().trim()).startsWith(PARAMETER_ORDER)) {
                this.setParameterOrder(line);
                continue;
            }
            if (line.startsWith(SUBBASIN)) {
                String subbasinName;
                if (entry != null && !this.isEntryInList(entry)) {
                    this._entries.add(entry);
                }
                if ((entry = this.getSubbasinEntry(subbasinName = RMAIO.getParam(line, " "))) != null) continue;
                entry = new GridCellFileEntry(subbasinName);
                continue;
            }
            if (line.startsWith(END)) {
                if (entry != null && !this.isEntryInList(entry)) {
                    this._entries.add(entry);
                }
                entry = null;
                continue;
            }
            if (!line.startsWith(GRIDCELL) || entry == null) continue;
            String param = RMAIO.getParam(line, " ");
            StringTokenizer token = new StringTokenizer(param, " ");
            if (this._defaultOrder) {
                if (token.countTokens() != 4) {
                    System.out.println("readFile: invalid number of parameters on line " + lineCnt + " parameter Count = " + token.countTokens() + " Expected 4");
                    continue;
                }
                int x = RMAIO.parseInt(token.nextToken(), -1);
                int y = RMAIO.parseInt(token.nextToken(), -1);
                double travel = RMAIO.parseDouble(token.nextToken(), -1.0);
                double area = RMAIO.parseDouble(token.nextToken(), -1.0);
                entry.add(x, y, travel, area);
                continue;
            }
            GridCellFileEntry.GridCell cell = entry.newGridCell();
            if (token.countTokens() != this._paramList.size()) {
                System.out.println("readFile: invalid number of parameters on line " + lineCnt + " parameter Count = " + token.countTokens() + " Expected " + this._paramList.size());
                continue;
            }
            int cnt = 0;
            while (token.hasMoreTokens()) {
                param = token.nextToken();
                String paramType = this._paramList.get(cnt);
                if (paramType.equalsIgnoreCase(XCOORD)) {
                    cell.x = RMAIO.parseInt(param, -1);
                } else if (paramType.equalsIgnoreCase(YCOORD)) {
                    cell.y = RMAIO.parseInt(param, -1);
                } else if (paramType.equalsIgnoreCase(TRAVEL_LENGTH)) {
                    cell.travel = RMAIO.parseDouble(param, -1.0);
                } else if (paramType.equalsIgnoreCase(AREA)) {
                    cell.area = RMAIO.parseDouble(param, -1.0);
                } else if (paramType.equalsIgnoreCase(SCSCN) || paramType.equalsIgnoreCase(SMAUNIT)) {
                    // empty if block
                }
                ++cnt;
            }
            entry.add(cell);
        }
        if (entry != null && !this.isEntryInList(entry)) {
            this._entries.add(entry);
        }
        System.out.println("readFile: read " + this._entries.size() + " basins");
        return true;
    }

    private GridCellFileEntry getSubbasinEntry(String subbasinName) {
        for (GridCellFileEntry entry : this._entries) {
            if (!subbasinName.equalsIgnoreCase(entry.getBasinName())) continue;
            return entry;
        }
        return null;
    }

    private boolean isEntryInList(GridCellFileEntry entry) {
        for (GridCellFileEntry anEntry : this._entries) {
            if (!anEntry.getBasinName().equalsIgnoreCase(entry.getBasinName())) continue;
            return true;
        }
        return false;
    }

    private void setParameterOrder(String line) {
        this._defaultOrder = false;
        String params = RMAIO.getParam(line, ":");
        StringTokenizer tokenizer = new StringTokenizer(params, " ");
        this._paramList = new Vector(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equalsIgnoreCase(XCOORD)) {
                this._paramList.add(XCOORD);
                continue;
            }
            if (token.equalsIgnoreCase(YCOORD)) {
                this._paramList.add(YCOORD);
                continue;
            }
            if (token.equalsIgnoreCase(TRAVEL_LENGTH)) {
                this._paramList.add(TRAVEL_LENGTH);
                continue;
            }
            if (token.equalsIgnoreCase(AREA)) {
                this._paramList.add(AREA);
                continue;
            }
            if (token.equalsIgnoreCase(SCSCN)) {
                this._paramList.add(SCSCN);
                continue;
            }
            if (!token.equalsIgnoreCase(SMAUNIT)) continue;
            this._paramList.add(SMAUNIT);
        }
    }

    public GridCellFileEntry getEntry(String basinName) {
        if (basinName == null) {
            return null;
        }
        for (int i = 0; i < this._entries.size(); ++i) {
            GridCellFileEntry entry = this._entries.get(i);
            if (entry == null || !basinName.equals(entry.getBasinName())) continue;
            return entry;
        }
        return null;
    }

    public int size() {
        return this._entries.size();
    }

    public Vector<GridCellFileEntry> getEntries() {
        return (Vector)this._entries.clone();
    }

    public static void main(String[] args) {
        GridCellFile gridCellFile1 = new GridCellFile();
        if (args.length == 0 || args[0] == null) {
            System.out.println("USAGE: " + gridCellFile1.getClass().getName() + " gridcell file");
            return;
        }
        File f = new File(args[0]);
        if (!f.exists()) {
            System.out.println("ERROR grid cell file " + args[0] + " doesn't exist");
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(f));
            System.out.println("reading " + f.getPath());
            gridCellFile1.readFile(reader);
            reader.close();
            Vector<GridCellFileEntry> v = gridCellFile1.getEntries();
            for (int i = 0; i < v.size(); ++i) {
                GridCellFileEntry entry = v.get(i);
                System.out.println(entry.toString());
            }
        }
        catch (IOException ioe) {
            System.out.println("Error Reader " + args[0] + " Error " + ioe);
        }
    }
}

