/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.model.UserInterface;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RMISecurityException;

public class HecOutputStream
extends OutputStream {
    FileOutputStream _file = null;
    FileOutputStream _sysOut = null;
    UserInterface _ui = null;
    private boolean _timeStamp;

    private HecOutputStream() throws IOException {
        try {
            this._sysOut = new FileOutputStream(FileDescriptor.out);
        }
        catch (RMISecurityException se) {
            System.out.println("Caught RMISecurityException se " + se);
        }
        this._timeStamp = Boolean.getBoolean("LogFile.UseTimeStamp");
    }

    public HecOutputStream(String name) throws IOException {
        this();
        this._file = new FileOutputStream(name);
        this._timeStamp = Boolean.getBoolean("LogFile.UseTimeStamp");
    }

    public HecOutputStream(String name, boolean append) throws IOException {
        this();
        this._file = new FileOutputStream(name, append);
        this._timeStamp = Boolean.getBoolean("LogFile.UseTimeStamp");
    }

    public HecOutputStream(File file) throws IOException {
        this();
        this._file = new FileOutputStream(file);
        this._timeStamp = Boolean.getBoolean("LogFile.UseTimeStamp");
    }

    public HecOutputStream(File file, boolean append) throws IOException {
        this();
        this._file = new FileOutputStream(file, append);
        this._timeStamp = Boolean.getBoolean("LogFile.UseTimeStamp");
    }

    @Override
    public void close() throws IOException {
        this._file.close();
        this._sysOut.close();
    }

    public void setFileName(String logFileName) {
        if (this._file != null) {
            try {
                this._file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this._file = new FileOutputStream(logFileName);
        }
        catch (IOException ioe) {
            System.out.println("HecOutputStream.setFileName: IOException creating new FileOutputStream(" + logFileName + ")");
            this._file = null;
        }
    }

    public void setUserInterface(UserInterface ui) {
        this._ui = ui;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this._timeStamp) {
            this._file.write(HecOutputStream.makeTimestamp().getBytes());
        }
        this._file.write(b);
        this._file.flush();
        if (this._ui != null) {
            this._ui.printMessage(new String(b));
        }
        try {
            this._sysOut.write(b);
            this._sysOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] ts = null;
        if (this._timeStamp) {
            ts = HecOutputStream.makeTimestamp().getBytes();
        }
        if (ts != null && (len != 2 || b[off] != 13 || b[off + 1] != 10)) {
            this._file.write(ts);
        }
        this._file.write(b, off, len);
        this._file.flush();
        if (this._ui != null) {
            this._ui.printMessage(new String(b, off, len));
        }
        try {
            if (ts != null && (len != 2 || b[off] != 13 || b[off + 1] != 10)) {
                this._sysOut.write(ts);
            }
            this._sysOut.write(b, off, len);
            this._sysOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void write(int b) throws IOException {
        this._file.write(b);
        this._file.flush();
        if (this._ui != null) {
            this._ui.printMessage(String.valueOf(b));
        }
        try {
            this._sysOut.write(b);
            this._sysOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String makeTimestamp() {
        long millis = System.currentTimeMillis();
        return String.format("%-3.3f:", (double)millis / 1000.0);
    }
}

