/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RMISecurityException;
import rma.util.RMAIO;

public class HecSwappingOutputStream
extends OutputStream {
    FileOutputStream _fOut = null;
    FileOutputStream _sysOut = null;
    File _file = null;
    protected String[] _logFileNames;
    protected String _logFileName2;
    protected long _logFileSize = 51200L;
    static HecSwappingOutputStream _log = null;
    boolean _toConsole;
    protected int _currentLogFileName;

    public static HecSwappingOutputStream getOutputStream(String name, int numLogs, int logSize, boolean toConsole) throws IOException {
        if (_log == null) {
            System.out.println("logfile name=" + name + " number=" + numLogs + " size=" + logSize + " toConsole=" + toConsole);
            _log = new HecSwappingOutputStream(name, numLogs, logSize, toConsole);
        }
        return _log;
    }

    public static HecSwappingOutputStream getOutputStream() throws IOException {
        if (_log == null) {
            String name = System.getProperty("logfile.name", "/tmp/jre.out");
            String nlogs = System.getProperty("logfile.count", "2");
            String lsize = System.getProperty("logfile.size", "51200");
            int numLogs = RMAIO.parseInt(nlogs, 2);
            int logSize = RMAIO.parseInt(lsize, 51200);
            boolean toConsole = Boolean.getBoolean("logfile.print");
            return HecSwappingOutputStream.getOutputStream(name, numLogs, logSize, toConsole);
        }
        return _log;
    }

    private HecSwappingOutputStream() throws IOException {
    }

    private HecSwappingOutputStream(String name, int numLogs, int logSize, boolean toConsole) throws IOException {
        try {
            this._file = new File(name);
            this.init(numLogs, logSize, toConsole);
            this._fOut = new FileOutputStream(this._file);
        }
        catch (Exception e) {
            System.err.println("HecSwappingOutputStream: error opening file " + name + " error " + e);
        }
    }

    private void init(int numLogs, int logSize, boolean toConsole) {
        try {
            this._sysOut = new FileOutputStream(FileDescriptor.out);
        }
        catch (RMISecurityException se) {
            System.err.println("init:Caught RMISecurityException se " + se);
        }
        catch (Exception e) {
            System.err.println("init:Error Creating file for System.out" + e);
        }
        PrintStream pstream = new PrintStream(this);
        System.setOut(pstream);
        if (!this._file.canWrite()) {
            System.err.println("init(): Can't write to " + this._file.getAbsolutePath());
        }
        if (this._file.exists()) {
            this._file.delete();
        }
        this.setLogFileSize(logSize);
        this.setLogFileNames(this._file.getName(), this._logFileSize == 0L ? 1 : numLogs);
        this._toConsole = toConsole;
    }

    public String getLogFileName() {
        return this._logFileNames[this._currentLogFileName];
    }

    @Override
    public void close() throws IOException {
        this._fOut.close();
        this._sysOut.close();
        _log = null;
    }

    private boolean needsSwapping() {
        if (this._logFileSize != 0L && this._file.length() > this._logFileSize) {
            System.err.println("logFileSize is " + this._file.length() + " Max is " + this._logFileSize);
            return true;
        }
        return false;
    }

    private void swap() {
        try {
            this._fOut.close();
            this.swapFileNames();
            String s = this.getLogFileName();
            this._file = new File(s);
            if (this._file.exists()) {
                this._file.delete();
            }
            this._fOut = new FileOutputStream(this._file);
        }
        catch (Exception e) {
            System.err.println("swap():Error swapping to other logfile " + e);
        }
    }

    private void swapFileNames() {
        this._currentLogFileName = (this._currentLogFileName + 1) % this._logFileNames.length;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.needsSwapping()) {
            this.swap();
        }
        this._fOut.write(b);
        if (this._toConsole) {
            this._sysOut.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.needsSwapping()) {
            this.swap();
        }
        this._fOut.write(b, off, len);
        this._fOut.flush();
        if (this._toConsole) {
            this._sysOut.write(b, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.needsSwapping()) {
            this.swap();
        }
        this._fOut.write(b);
        if (this._toConsole) {
            this._sysOut.write(b);
        }
    }

    private void setLogFileNames(String logFileName, int numLogs) {
        if (numLogs < 1) {
            numLogs = 1;
        }
        this._logFileNames = new String[numLogs];
        this._logFileNames[0] = logFileName;
        for (int i = 1; i < numLogs; ++i) {
            this._logFileNames[i] = logFileName + i;
        }
        this._currentLogFileName = 0;
    }

    private void setLogFileSize(int size) {
        if (size > -1) {
            this._logFileSize = size;
        }
    }
}

