/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.HecFile;
import hec.lang.NamedType;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import rma.util.RMAIO;

public class Identifier
extends NamedType
implements Serializable,
Comparable {
    private static final long serialVersionUID = -7190855186692778112L;
    protected static final Hashtable RMI_FILE_MAP = new Hashtable();
    protected static final String DEFAULT_RMI_FILE = "mil.army.usace.hec.rmi.server.RmiFileImpl";
    public String _path = null;
    @Deprecated
    public Class _type;
    public String _stringClass;
    public HecFile _file = null;
    public boolean _directory = false;
    protected long _length = -1L;
    protected long _lastModified = -1L;
    protected boolean _readOnly = false;
    protected boolean _hidden = false;

    public static Object instantiateRmiFile(Identifier id, String extension, Object[] constructorArgs) {
        Object obj = RMI_FILE_MAP.get(id.getClass().getName());
        if (obj == null) {
            obj = RMI_FILE_MAP.get(extension);
        }
        if (obj == null) {
            obj = DEFAULT_RMI_FILE;
        }
        Class<?> fileClass = null;
        if (obj instanceof Class) {
            fileClass = (Class<?>)obj;
        } else {
            try {
                fileClass = Class.forName(obj.toString());
            }
            catch (ClassNotFoundException e) {
                System.out.println("Unable to determine Remote File Type for: " + obj.toString());
                return null;
            }
        }
        Object instance = null;
        try {
            if (constructorArgs != null && constructorArgs.length > 0) {
                Class[] paramTypes = new Class[constructorArgs.length];
                for (int ii = 0; ii < constructorArgs.length; ++ii) {
                    paramTypes[ii] = constructorArgs[ii].getClass();
                }
                Constructor<?> constructor = null;
                constructor = fileClass.getConstructor(paramTypes);
                instance = constructor.newInstance(constructorArgs);
            } else {
                instance = fileClass.newInstance();
            }
        }
        catch (NoSuchMethodException e) {
            System.out.println("Unable to determine Rmi File Constructor to use with: " + constructorArgs);
            return null;
        }
        catch (InstantiationException e) {
            System.out.println("Unable to instantiate Rmi File. " + e);
            return null;
        }
        catch (InvocationTargetException e) {
            System.out.println("Exception when instantiating Rmi File. " + e);
            return null;
        }
        catch (IllegalAccessException e) {
            System.out.println("Unable to instantiate Rmi File. " + e);
            return null;
        }
        return instance;
    }

    public Identifier() {
    }

    public Identifier(String path) {
        this();
        this._path = path;
    }

    public Identifier(String path, HecFile file) {
        this();
        this.setFile(file);
        this.setPath(path);
    }

    public Identifier(Identifier argId) {
        this();
        if (argId != null) {
            if (argId.getName() != null) {
                this.setName(argId.getName());
            }
            if (argId.getDescription() != null) {
                this.setDescription(argId.getDescription());
            }
            if (argId.getPath() != null) {
                this.setPath(argId.getPath());
            }
            if (argId.getFile() != null) {
                this.setFile(argId.getFile());
            }
            if (argId.getType() != null) {
                this.setType(argId.getType());
            }
            this._directory = argId._directory;
        }
    }

    public void copy(Identifier argId) {
        if (argId != null) {
            this.setName(argId.getName());
            this.setDescription(argId.getDescription());
            this.setPath(argId.getPath());
            this.setFile(argId.getFile());
            this.setType(argId.getType());
            this._directory = argId._directory;
        }
    }

    public void setFile(HecFile file) {
        this._file = file;
        if (this.getName() == null || this.getName().isEmpty() || this.getName().equals("Untitled") && this._file != null) {
            this.setName(this._file.getName());
        }
    }

    public void setPath(String path) {
        this._path = path;
    }

    public String getPath() {
        return this._path;
    }

    public HecFile getFile() {
        return this._file;
    }

    @Override
    public String toString() {
        if ("Untitled".equals(this.getName()) && this._path != null) {
            return RMAIO.getFileFromPath(this._path);
        }
        return this.getName();
    }

    public String paramString() {
        return "Identifier:Path=" + this._path + (String)(this._stringClass != null ? "\n Class=" + this._stringClass : "") + (String)(this._file != null ? "\n File=" + this._file : "") + "\n isDirectory=" + this._directory + " Length=" + this._length + "\n Read Only=" + this._readOnly + " Hidden=" + this._hidden + " Last Modified=" + this._lastModified;
    }

    @Deprecated
    public void setType(Class type) {
        this._type = type;
    }

    @Deprecated
    public Class getType() {
        return this._type;
    }

    public void setClassName(String type) {
        this._stringClass = type;
    }

    public String getClassName() {
        return this._stringClass;
    }

    public long length() {
        if (this._file != null) {
            return this._file.length();
        }
        return this._length;
    }

    public long lastModified() {
        if (this._file != null) {
            return this._file.lastModified();
        }
        return this._lastModified;
    }

    public void setLength(long length) {
        this._length = length;
    }

    public void setLastModified(long lastModified) {
        this._lastModified = lastModified;
    }

    public void setReadOnly(boolean b) {
        this._readOnly = b;
    }

    public boolean isReadOnly() {
        if (this._file != null) {
            return !this._file.canWrite();
        }
        return this._readOnly;
    }

    public void setHidden(boolean b) {
        this._hidden = b;
    }

    public boolean isHidden() {
        return this._hidden;
    }

    public void setIsDirectory(boolean isDirectory) {
        this._directory = isDirectory;
    }

    public boolean isDirectory() {
        return this._directory;
    }

    public int hashCode() {
        if (this._path == null) {
            return super.hashCode();
        }
        return this._path.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Identifier)) {
            return false;
        }
        Identifier that = (Identifier)obj;
        if (that._path == null || this._path == null) {
            return false;
        }
        return RMAIO.pathsEqual(that._path, this._path);
    }

    @Override
    public int compareTo(Object obj) {
        Identifier id = (Identifier)obj;
        return this._name.toLowerCase().compareTo(id._name.toLowerCase());
    }

    public void initToFile(File file) {
        this.setIsDirectory(file.isDirectory());
        this.setLength(file.length());
        this.setLastModified(file.lastModified());
        this.setReadOnly(!file.canWrite());
        this.setHidden(file.isHidden());
    }

    static {
        if (!Boolean.getBoolean("Disable.DbfFileHandling")) {
            RMI_FILE_MAP.put(".dbf", "mil.army.usace.hec.rmi.server.RmiDbfFileImpl");
            RMI_FILE_MAP.put("mil.army.usace.hec.rmi.io.dbf.DbfIdentifier", "mil.army.usace.hec.rmi.server.RmiDbfFileImpl");
        }
    }
}

