/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaDocParser {
    private static final String JAVA_DOC_HOME = "javaDocHome";
    static Map<Class, JavaDocParser> _mappings = new WeakHashMap<Class, JavaDocParser>();
    private Class _cls;
    private List<String> _fileContents = new ArrayList<String>(100);
    private String _jdocFile;
    private File _theFile;
    private URL _url;
    public static final Logger logger = Logger.getLogger(JavaDocParser.class.getName());

    private JavaDocParser(Class cls) {
        this._cls = cls;
        this.readJDocFile();
    }

    public static JavaDocParser createParser(Class cls) {
        JavaDocParser parser = _mappings.get(cls);
        if (parser == null) {
            parser = new JavaDocParser(cls);
            _mappings.put(cls, parser);
        }
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readJDocFile() {
        if (this._cls == null) {
            return;
        }
        String clsName = this._cls.getName();
        if ((clsName = clsName.replace('.', '/')).startsWith("java") || clsName.startsWith("javax")) {
            return;
        }
        String jDocHome = JavaDocParser.getJavaDocHome();
        this._jdocFile = jDocHome + clsName + ".html";
        File f = new File(this._jdocFile);
        if (!f.exists()) {
            this._url = ClassLoader.getSystemClassLoader().getResource(this._jdocFile);
            f = null;
        } else {
            try {
                this._url = f.toURL();
            }
            catch (MalformedURLException ure) {
                logger.log(Level.SEVERE, "readJDocFile: " + ure, ure);
            }
            this._theFile = f;
        }
        if (this._url == null) {
            logger.log(Level.FINE, "readJDocFile: {0} not loaded", this._jdocFile);
            return;
        }
        this._jdocFile = this._url.toString();
        if (f == null) {
            this._theFile = this._jdocFile.startsWith("file:/") ? new File(this._jdocFile.substring(6)) : new File(this._jdocFile);
        }
        if (!this._theFile.exists() && !this._jdocFile.startsWith("jar:")) {
            logger.log(Level.FINE, "readJDocFile: file {0} doesn''t exist", this._jdocFile);
            this._theFile = null;
            return;
        }
        BufferedReader reader = null;
        try {
            String line;
            if (this._jdocFile.startsWith("jar:")) {
                InputStream is = this.getClass().getResourceAsStream(jDocHome + clsName + ".html");
                if (is == null) {
                    is = ClassLoader.getSystemClassLoader().getResourceAsStream(jDocHome + clsName + ".html");
                }
                if (is == null) {
                    logger.log(Level.FINE, "readJDocFile: failed to find java doc file {0}{1}.html", new Object[]{jDocHome, clsName});
                    return;
                }
                reader = new BufferedReader(new InputStreamReader(is));
            } else {
                reader = new BufferedReader(new FileReader(this._theFile));
            }
            while ((line = reader.readLine()) != null) {
                this._fileContents.add(line);
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "readJDocFile:IOError reading " + this._jdocFile + " Error:" + ioe, ioe);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, "readJDocFile: IOError close file " + this._jdocFile + " Error" + ioe, ioe);
            }
        }
    }

    public String getJavaDoc() {
        StringBuilder buf = new StringBuilder(this._fileContents.size() * 80);
        for (int i = 0; i < this._fileContents.size(); ++i) {
            buf.append(this._fileContents.get(i));
            buf.append("\n");
        }
        return buf.toString();
    }

    public File getJavaDocFile() {
        return this._theFile;
    }

    public URL getJavaDocURL() {
        return this._url;
    }

    public static String getJavaDocHome() {
        if (System.getProperty(JAVA_DOC_HOME) == null || System.getProperty(JAVA_DOC_HOME).isEmpty()) {
            return System.getProperty(JAVA_DOC_HOME, "javaDocs/");
        }
        return System.getProperty(JAVA_DOC_HOME);
    }

    public String getContructorSyntax(Constructor ctor) {
        String jdoc = this.getJavaDoc(ctor);
        if (jdoc == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(jdoc, "\n");
        StringBuilder buf = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!token.equalsIgnoreCase("<PRE>")) continue;
            buf.append(tokenizer.nextToken());
            return buf.toString();
        }
        return jdoc;
    }

    public String getFieldSyntax(Field f) {
        String jdoc = this.getJavaDoc(f);
        if (jdoc == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(jdoc, "\n");
        StringBuilder buf = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!token.equalsIgnoreCase("<PRE>")) continue;
            buf.append(tokenizer.nextToken());
            return buf.toString();
        }
        return jdoc;
    }

    public String getJavaDocUrl(Field f) {
        if (f == null) {
            return null;
        }
        String fieldCall = this.getField(f);
        String jdocPath = this._jdocFile + "#" + fieldCall;
        return jdocPath;
    }

    public String getJavaDoc(Field f) {
        if (f == null) {
            return null;
        }
        String fieldCall = this.getField(f);
        String lookForLine = "<A NAME=\"" + fieldCall + "\">";
        String endLine = "</DL>";
        StringBuilder buf = new StringBuilder();
        boolean done = false;
        for (int i = 0; i < this._fileContents.size(); ++i) {
            String line = this._fileContents.get(i);
            if (line.contains(lookForLine)) {
                buf.append("<html>");
                buf.append(line);
                buf.append("\n");
                for (int j = i + 1; j < this._fileContents.size(); ++j) {
                    line = this._fileContents.get(j);
                    if (line.contains(endLine)) {
                        done = true;
                        break;
                    }
                    buf.append(line);
                    buf.append("\n");
                }
            }
            if (done) break;
        }
        if (buf.length() == 0 && this._cls != null) {
            Class superCls = this._cls.getSuperclass();
            JavaDocParser superJavaDoc = JavaDocParser.createParser(superCls);
            return superJavaDoc.getJavaDoc(f);
        }
        buf.append("</html>");
        return buf.toString();
    }

    public String getField(Field f) {
        if (f == null) {
            return null;
        }
        return f.getName();
    }

    public String getMethodSyntax(Method m) {
        String jdoc = this.getJavaDoc(m);
        if (jdoc == null) {
            return JavaDocParser.getMethodCall(m);
        }
        return JavaDocParser.getMethodSyntaxFromJavaDoc(jdoc);
    }

    public static String getMethodSyntaxFromJavaDoc(String jdoc) {
        StringTokenizer tokenizer = new StringTokenizer(jdoc, "\n");
        StringBuilder buf = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!token.equalsIgnoreCase("<PRE>") && !token.startsWith("<pre>")) continue;
            if (token.startsWith("<pre>")) {
                buf.append(token);
            }
            token = tokenizer.nextToken();
            buf.append(token);
            while (!token.contains(")") && tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                buf.append(token);
            }
            return buf.toString();
        }
        return jdoc;
    }

    public String getJavaDocUrl(Constructor ctor) {
        if (ctor == null) {
            return null;
        }
        String ctorCall = JavaDocParser.getConstructorCall(ctor);
        String jdocPath = this._jdocFile + "#" + ctorCall;
        return jdocPath;
    }

    public String getJavaDoc(Constructor ctor) {
        if (ctor == null) {
            return null;
        }
        String ctorCall = JavaDocParser.getConstructorCall(ctor);
        String lookForLine = "<A NAME=\"" + ctorCall + "\">";
        String endLine = "<HR>";
        String endLine2 = "</DL>";
        StringBuilder buf = new StringBuilder();
        boolean done = false;
        for (int i = 0; i < this._fileContents.size(); ++i) {
            String line = this._fileContents.get(i);
            if (line.contains(lookForLine)) {
                buf.append("<html>");
                buf.append(line);
                buf.append("\n");
                for (int j = i + 1; j < this._fileContents.size(); ++j) {
                    line = this._fileContents.get(j);
                    if (line.contains(endLine) || line.contains(endLine2)) {
                        done = true;
                        break;
                    }
                    buf.append(line);
                    buf.append("\n");
                }
            }
            if (done) break;
        }
        if (buf.length() == 0) {
            return null;
        }
        buf.append("</html>");
        return buf.toString();
    }

    public String getJavaDocUrl(Method m) {
        if (m == null) {
            return null;
        }
        String methodCall = JavaDocParser.getMethodCall(m);
        String jdocPath = this._jdocFile + "#" + methodCall;
        return jdocPath;
    }

    public String getJavaDoc(Method m) {
        if (m == null) {
            return null;
        }
        String methodCall = JavaDocParser.getMethodCall(m);
        Object lookForLine = "<A NAME=\"" + methodCall + "\">";
        String methodCall2 = methodCall.replace('(', '-');
        methodCall2 = methodCall2.replace(')', '-');
        methodCall2 = methodCall2.replace(", ", "-");
        Object lookForLine2 = "<a name=\"" + methodCall2 + "\">";
        lookForLine2 = ((String)lookForLine2).toLowerCase();
        lookForLine = ((String)lookForLine).toLowerCase();
        String endLine = "<HR>".toLowerCase();
        String endLine2 = "</ul>";
        StringBuilder buf = new StringBuilder();
        boolean done = false;
        for (int i = 0; i < this._fileContents.size(); ++i) {
            String line = this._fileContents.get(i);
            if ((line = line.toLowerCase()).contains((CharSequence)lookForLine) || line.contains((CharSequence)lookForLine2)) {
                buf.append("<html>");
                buf.append(line);
                buf.append("\n");
                for (int j = i + 1; j < this._fileContents.size(); ++j) {
                    line = this._fileContents.get(j);
                    if (line.contains(endLine) || line.contains(endLine2)) {
                        done = true;
                        break;
                    }
                    buf.append(line);
                    buf.append("\n");
                }
            }
            if (done) break;
        }
        if (buf.length() == 0 && this._cls != null) {
            Class superCls = this._cls.getSuperclass();
            JavaDocParser superJavaDoc = JavaDocParser.createParser(superCls);
            return superJavaDoc.getJavaDoc(m);
        }
        buf.append("</html>");
        return buf.toString();
    }

    public void close() {
        this._fileContents.clear();
    }

    public static String getConstructorCall(Constructor ctor) {
        try {
            StringBuilder sb = new StringBuilder();
            String name = ctor.getName();
            int idx = name.lastIndexOf(".");
            if (idx > -1) {
                name = name.substring(idx + 1);
            }
            sb.append(name).append('(');
            Class<?>[] params = ctor.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                sb.append(JavaDocParser.getTypeName(params[j]));
                if (j >= params.length - 1) continue;
                sb.append(',');
            }
            sb.append(')');
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    public static String getMethodCall(Method method) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(method.getName()).append('(');
            Class<?>[] params = method.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                sb.append(JavaDocParser.getTypeName(params[j]));
                if (j >= params.length - 1) continue;
                sb.append(", ");
            }
            sb.append(')');
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    public static String getTypeName(Class type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }
}

