/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.LogTimeIntervals;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import rma.util.RMAIO;

public class LogFileNamer
implements LogTimeIntervals {
    String timeInterval;
    long nextTimeForNewFile = 0L;
    boolean localTime = true;
    String directory = null;
    String baseFilename = null;
    PrintWriter _out = null;

    public LogFileNamer(String directory, String baseFileName, String timeInterval, boolean localTime) {
        this.directory = RMAIO.parsePathName(directory);
        this.baseFilename = baseFileName;
        this.timeInterval = timeInterval;
        this.localTime = localTime;
        if (!this.isValidTimeInterval()) {
            throw new IllegalArgumentException("Invalid timeInterval " + timeInterval);
        }
    }

    public void setOut(FileOutputStream out) {
        this._out = new PrintWriter(out);
    }

    public boolean isValidTimeInterval() {
        for (int i = 0; i < TIME_INTERVALS.length; ++i) {
            if (!this.timeInterval.equalsIgnoreCase(TIME_INTERVALS[i])) continue;
            return true;
        }
        this.msgOut("LogFileNamer: invalid time interval " + this.timeInterval);
        return false;
    }

    public long getTimeForNextFile() {
        return this.nextTimeForNewFile;
    }

    public String getNewFilename(long currentTime) throws IOException {
        SimpleDateFormat simpleDateFormat = null;
        String theDateMask = null;
        String filename = null;
        Date startDate = null;
        if (this.timeInterval.equalsIgnoreCase("hr")) {
            long intervalsFromBase = currentTime / 3600000L;
            this.nextTimeForNewFile = (intervalsFromBase + 1L) * 3600000L;
            theDateMask = new String("yyyy.MM.dd.HH");
            startDate = new Date();
        } else {
            GregorianCalendar gc = null;
            gc = this.localTime ? new GregorianCalendar() : new GregorianCalendar(TimeZone.getTimeZone("utc"));
            int day = 0;
            int month = 0;
            int year = 0;
            int dayOfWeek = -1;
            if (this.timeInterval.equalsIgnoreCase("dy")) {
                theDateMask = new String("yyyy.MM.dd");
                day = gc.get(5);
                month = gc.get(2);
                year = gc.get(1);
                gc.clear();
                gc.set(year, month, day);
                startDate = gc.getTime();
                gc.roll(5, true);
                this.nextTimeForNewFile = gc.getTime().getTime();
            } else if (this.timeInterval.equalsIgnoreCase("wk")) {
                theDateMask = new String("yyyy.MM.dd");
                day = gc.get(5);
                month = gc.get(2);
                year = gc.get(1);
                dayOfWeek = gc.get(7);
                gc.clear();
                gc.set(year, month, day);
                gc.add(5, -(dayOfWeek - 1));
                startDate = gc.getTime();
                gc.add(5, 7);
                this.nextTimeForNewFile = gc.getTime().getTime();
            } else if (this.timeInterval.equalsIgnoreCase("mo")) {
                theDateMask = new String("yyyy.MM");
                month = gc.get(2);
                year = gc.get(1);
                gc.clear();
                gc.set(year, month, 1);
                startDate = gc.getTime();
                gc.roll(2, true);
                this.nextTimeForNewFile = gc.getTime().getTime();
            } else if (this.timeInterval.equalsIgnoreCase("yr")) {
                theDateMask = new String("yyyy");
                year = gc.get(1);
                gc.clear();
                gc.set(year, 0, 1);
                startDate = gc.getTime();
                gc.roll(1, true);
                this.nextTimeForNewFile = gc.getTime().getTime();
            }
        }
        if (this.localTime) {
            simpleDateFormat = new SimpleDateFormat(theDateMask);
        } else {
            TimeZone tzLocal = TimeZone.getDefault();
            TimeZone.setDefault(TimeZone.getTimeZone("utc"));
            simpleDateFormat = new SimpleDateFormat(theDateMask);
            TimeZone.setDefault(tzLocal);
        }
        filename = this.directory + "/" + this.baseFilename + "." + this.timeInterval + "." + simpleDateFormat.format(startDate);
        if (!this.localTime) {
            filename = filename + ".utc";
        }
        this.msgOut(filename);
        Date nextDate = new Date();
        nextDate.setTime(this.nextTimeForNewFile);
        this.msgOut("NextTime: " + nextDate);
        return filename;
    }

    private void msgOut(String msg) {
        if (this._out != null) {
            this._out.println(msg);
        }
    }
}

