/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.LogFileNamer;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.rmi.RMISecurityException;
import java.util.Date;

public class LogPrintStream
extends OutputStream {
    String directory = null;
    String baseFilename = null;
    String timeInterval = null;
    boolean localTime = true;
    boolean echoToOut = false;
    long nextTimeForNewFile = 0L;
    Date date = null;
    long currentTime = 0L;
    PrintStream logPrintStream = null;
    FileOutputStream _sysOut = null;
    PrintWriter _sysErr = null;
    LogFileNamer logNamer;

    public LogPrintStream(String directory, String baseFilename, String timeInterval, boolean localTime, boolean echoToOut) {
        this.directory = directory;
        this.baseFilename = baseFilename;
        this.timeInterval = timeInterval;
        this.localTime = localTime;
        this.echoToOut = echoToOut;
        this.date = new Date();
        this.currentTime = this.date.getTime();
        this.logNamer = new LogFileNamer(directory, baseFilename, timeInterval, localTime);
        this._sysErr = new PrintWriter(new FileOutputStream(FileDescriptor.err));
        this.logPrintStream = this.getNewLogPrintStreamFile();
        if (echoToOut) {
            try {
                this._sysOut = new FileOutputStream(FileDescriptor.out);
                this.logNamer.setOut(this._sysOut);
            }
            catch (RMISecurityException se) {
                System.err.println("init:Caught RMISecurityException se " + se);
                echoToOut = false;
            }
            catch (Exception e) {
                System.err.println("init:Error Creating file for System.out" + e);
                echoToOut = false;
            }
        }
    }

    public void setTimeInterval(String timeInterval) {
        this.timeInterval = timeInterval;
    }

    private void isTimeForNewStream() {
        this.date = new Date();
        this.currentTime = this.date.getTime();
        if (this.currentTime > this.nextTimeForNewFile) {
            this.logPrintStream.close();
            this.logPrintStream = this.getNewLogPrintStreamFile();
        }
    }

    private PrintStream getNewLogPrintStreamFile() {
        FileOutputStream fileOutputStream = null;
        File logsDir = new File(this.directory);
        if (!logsDir.isDirectory()) {
            if (logsDir.mkdirs()) {
                this._sysErr.println("Made 'logs' directory: " + logsDir);
            } else {
                this._sysErr.println("Could not make 'logs' directory: " + logsDir);
                return null;
            }
        }
        try {
            fileOutputStream = new FileOutputStream(this.logNamer.getNewFilename(this.currentTime), true);
            this.nextTimeForNewFile = this.logNamer.getTimeForNextFile();
        }
        catch (IOException ioe) {
            this._sysErr.println(ioe.getMessage());
            return null;
        }
        return new PrintStream(fileOutputStream, true);
    }

    @Override
    public void close() throws IOException {
        this.logPrintStream.close();
    }

    @Override
    public void flush() throws IOException {
        this.logPrintStream.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.echoToOut) {
            this._sysOut.write(b, off, len);
        }
        this.isTimeForNewStream();
        this.logPrintStream.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.echoToOut) {
            this._sysOut.write(b);
        }
        this.isTimeForNewStream();
        this.logPrintStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.echoToOut) {
            this._sysOut.write(b);
        }
        this.isTimeForNewStream();
        this.logPrintStream.write(b);
    }
}

