/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.LogFileNamer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;

public class LogPrintWriter
extends PrintWriter {
    String directory = null;
    String baseFilename = null;
    String timeInterval = null;
    boolean localTime = true;
    boolean echoToOut = false;
    long nextTimeForNewFile = 0L;
    Date date = null;
    long currentTime = 0L;
    PrintWriter logPrintWriter = null;
    LogFileNamer logNamer;

    public LogPrintWriter(String directory, String baseFilename, String timeInterval, boolean localTime, boolean echoToOut) {
        super(System.out);
        this.directory = directory;
        this.baseFilename = baseFilename;
        this.timeInterval = timeInterval;
        this.localTime = localTime;
        this.echoToOut = echoToOut;
        this.date = new Date();
        this.currentTime = this.date.getTime();
        this.logNamer = new LogFileNamer(directory, baseFilename, timeInterval, localTime);
        this.logPrintWriter = this.getNewLogPrintWriterFile();
    }

    @Override
    public boolean checkError() {
        return this.logPrintWriter.checkError();
    }

    @Override
    public void close() {
        this.logPrintWriter.close();
        this.logPrintWriter = null;
    }

    @Override
    public void flush() {
        this.logPrintWriter.flush();
    }

    @Override
    public void println(String x) {
        if (this.echoToOut) {
            System.out.println(x);
        }
        this.isTimeForNewStream();
        this.logPrintWriter.println(x);
    }

    @Override
    public void println(int x) {
        if (this.echoToOut) {
            System.out.println(x);
        }
        this.isTimeForNewStream();
        this.logPrintWriter.println(x);
    }

    @Override
    public void println(long x) {
        if (this.echoToOut) {
            System.out.println(x);
        }
        this.isTimeForNewStream();
        this.logPrintWriter.println(x);
    }

    @Override
    public void println(char x) {
        if (this.echoToOut) {
            System.out.println(x);
        }
        this.isTimeForNewStream();
        this.logPrintWriter.println(x);
    }

    @Override
    public void println(char[] x) {
        if (this.echoToOut) {
            System.out.println(x);
        }
        this.isTimeForNewStream();
        this.logPrintWriter.println(x);
    }

    @Override
    public void println(float x) {
        if (this.echoToOut) {
            System.out.println(x);
        }
        this.isTimeForNewStream();
        this.logPrintWriter.println(x);
    }

    @Override
    public void println(double x) {
        if (this.echoToOut) {
            System.out.println(x);
        }
        this.isTimeForNewStream();
        this.logPrintWriter.println(x);
    }

    @Override
    public void println(Object x) {
        if (this.echoToOut) {
            System.out.println(x);
        }
        this.isTimeForNewStream();
        this.logPrintWriter.println(x);
    }

    @Override
    public void println(boolean x) {
        if (this.echoToOut) {
            System.out.println(x);
        }
        this.isTimeForNewStream();
        this.logPrintWriter.println(x);
    }

    @Override
    public void print(String x) {
        if (this.echoToOut) {
            System.out.print(x);
        }
        this.isTimeForNewStream();
        this.logPrintWriter.print(x);
    }

    @Override
    public void print(int x) {
        if (this.echoToOut) {
            System.out.print(x);
        }
        this.isTimeForNewStream();
        this.logPrintWriter.print(x);
    }

    @Override
    public void print(long x) {
        if (this.echoToOut) {
            System.out.print(x);
        }
        this.isTimeForNewStream();
        this.logPrintWriter.print(x);
    }

    @Override
    public void print(char x) {
        if (this.echoToOut) {
            System.out.print(x);
        }
        this.isTimeForNewStream();
        this.logPrintWriter.print(x);
    }

    @Override
    public void print(char[] x) {
        if (this.echoToOut) {
            System.out.print(x);
        }
        this.isTimeForNewStream();
        this.logPrintWriter.print(x);
    }

    @Override
    public void print(float x) {
        if (this.echoToOut) {
            System.out.print(x);
        }
        this.isTimeForNewStream();
        this.logPrintWriter.print(x);
    }

    @Override
    public void print(double x) {
        if (this.echoToOut) {
            System.out.print(x);
        }
        this.isTimeForNewStream();
        this.logPrintWriter.print(x);
    }

    @Override
    public void print(Object x) {
        if (this.echoToOut) {
            System.out.print(x);
        }
        this.isTimeForNewStream();
        this.logPrintWriter.print(x);
    }

    @Override
    public void print(boolean x) {
        if (this.echoToOut) {
            System.out.print(x);
        }
        this.isTimeForNewStream();
        this.logPrintWriter.print(x);
    }

    @Override
    public void write(String x, int off, int len) {
        this.isTimeForNewStream();
        this.logPrintWriter.write(x, off, len);
    }

    @Override
    public void write(String x) {
        this.isTimeForNewStream();
        this.logPrintWriter.print(x);
    }

    @Override
    public void write(int x) {
        this.isTimeForNewStream();
        this.logPrintWriter.print(x);
    }

    @Override
    public void write(char[] buf) {
        this.isTimeForNewStream();
        this.logPrintWriter.print(buf);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        this.isTimeForNewStream();
        this.logPrintWriter.print(buf);
    }

    public void setTimeInterval(String timeInterval) {
        this.timeInterval = timeInterval;
    }

    private void isTimeForNewStream() {
        this.date = new Date();
        this.currentTime = this.date.getTime();
        if (this.currentTime > this.nextTimeForNewFile) {
            this.logPrintWriter.close();
            this.logPrintWriter = this.getNewLogPrintWriterFile();
        }
    }

    private PrintWriter getNewLogPrintWriterFile() {
        FileOutputStream fileOutputStream = null;
        File logsDir = new File(this.directory);
        if (!logsDir.isDirectory()) {
            if (logsDir.mkdirs()) {
                System.out.println("Made 'logs' directory: " + logsDir);
            } else {
                System.out.println("Could not make 'logs' directory: " + logsDir);
                return null;
            }
        }
        try {
            fileOutputStream = new FileOutputStream(this.logNamer.getNewFilename(this.currentTime), true);
            this.nextTimeForNewFile = this.logNamer.getTimeForNextFile();
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return null;
        }
        return new PrintWriter(fileOutputStream, true);
    }
}

