/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.data.IVerticalDatumOperations;
import hec.io.DataContainer;
import hec.io.PairedDataContainerVertDatum;
import hec.lang.annotation.Scriptable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.VerticalDatumException;

public class PairedDataContainer
extends DataContainer
implements Cloneable,
Serializable,
IVerticalDatumOperations<PairedDataContainer, VerticalDatumException> {
    private static final long serialVersionUID = -7044696510284207626L;
    public static final int NORMAL_WRITE = 0;
    public static final int ALLOCATE = 10;
    public static final int CURVE_WRITE = 11;
    public double[] xOrdinates = null;
    public double[][] yOrdinates = null;
    public boolean[] curveVisible = null;
    public int numberCurves = 0;
    public int numberOrdinates = 0;
    public int startingCurve = 0;
    public int endingCurve = 0;
    public int startingOrdinate = 0;
    public int endingOrdinate = 0;
    public String[] labels = null;
    public boolean labelsUsed = false;
    public String xunits = "";
    public String yunits = "";
    public String xtype = "";
    public String ytype = "";
    public String[] units = null;
    public String[] types = null;
    public String[] parameters = null;
    public int[] precisions = null;
    public int xprecision = -1;
    public int yprecision = -1;
    public boolean switchXyAxis = false;
    public int writeMethod = 0;
    public String xparameter = "";
    public String yparameter = "";
    public String other = "";
    public String date = "";
    public double datum = -3.4028234663852886E38;
    public double shift = -3.4028234663852886E38;
    public double offset = -3.4028234663852886E38;
    public int transformType = Integer.MIN_VALUE;

    @Scriptable
    public PairedDataContainer() {
    }

    @Scriptable
    public void setValues(double[] xOrdinates, double[][] yOrdinates) {
        this.xOrdinates = Arrays.copyOf(xOrdinates, xOrdinates.length);
        this.numberOrdinates = yOrdinates[0].length;
        this.numberCurves = yOrdinates.length;
        if (this.numberCurves != yOrdinates.length) {
            System.out.println("PairedDataContainer, setValues error - number of numberOrdinates is not the same");
            System.out.println("xOrdinates[] number: " + this.xOrdinates.length + "  yOrdinates[][] numberOrdinates " + this.numberOrdinates);
        }
        this.yOrdinates = new double[this.numberCurves][this.numberOrdinates];
        for (int i = 0; i < this.numberOrdinates; ++i) {
            for (int j = 0; j < this.numberCurves; ++j) {
                this.yOrdinates[j][i] = yOrdinates[j][i];
            }
        }
    }

    @Scriptable
    public void setNumberOrdinates(int numberOrdinates) {
        this.numberOrdinates = numberOrdinates;
    }

    @Scriptable
    public void setNumberCurves(int numberCurves) {
        this.numberCurves = numberCurves;
    }

    @Scriptable
    public int getNumberCurves() {
        return this.numberCurves;
    }

    @Scriptable
    public int getNumberOrdinates() {
        return this.numberOrdinates;
    }

    @Scriptable
    public double[] getXOridnates() {
        return Arrays.copyOf(this.xOrdinates, this.xOrdinates.length);
    }

    @Scriptable
    public double[][] getYOridnates() {
        double[][] yOrds = new double[this.yOrdinates.length][this.yOrdinates[0].length];
        for (int i = 0; i < this.yOrdinates[0].length; ++i) {
            for (int j = 0; j < this.yOrdinates.length; ++j) {
                yOrds[j][i] = this.yOrdinates[j][i];
            }
        }
        return yOrds;
    }

    @Scriptable
    public void setXUnits(String Xunits) {
        this.xunits = Xunits;
    }

    @Scriptable
    public void setXType(String Xtype) {
        this.xtype = Xtype;
    }

    @Scriptable
    public void setYUnits(String Yunits) {
        this.yunits = Yunits;
    }

    @Scriptable
    public void setYType(String Ytype) {
        this.ytype = Ytype;
    }

    @Scriptable
    public String getXUnits() {
        return this.xunits;
    }

    @Scriptable
    public String getXType() {
        return this.xtype;
    }

    @Scriptable
    public String getYUnits() {
        return this.yunits;
    }

    @Scriptable
    public String getYType() {
        return this.ytype;
    }

    @Scriptable
    public void setLabels(String[] labels) {
        this.labels = new String[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            this.labels[i] = labels[i];
        }
        this.labelsUsed = true;
    }

    @Scriptable
    public String[] getLabels() {
        if (!this.labelsUsed) {
            return null;
        }
        String[] labs = new String[this.labels.length];
        for (int i = 0; i < this.labels.length; ++i) {
            labs[i] = this.labels[i];
        }
        return labs;
    }

    @Scriptable
    public void allocateSpace(double[] xOrdinates, int numberCurves) {
        this.xOrdinates = Arrays.copyOf(xOrdinates, xOrdinates.length);
        this.numberOrdinates = this.xOrdinates.length;
        this.numberCurves = numberCurves;
        this.writeMethod = 10;
    }

    @Scriptable
    public void setXOrdinates(double[] xOrdinates) {
        this.xOrdinates = Arrays.copyOf(xOrdinates, xOrdinates.length);
        if (this.numberOrdinates == 0) {
            this.numberOrdinates = this.xOrdinates.length;
        }
    }

    @Scriptable
    public void setYOrdinates(double[][] yOrdinates) {
        if (this.numberOrdinates == 0) {
            this.numberOrdinates = yOrdinates[0].length;
        }
        if (this.numberCurves == 0) {
            this.numberCurves = yOrdinates.length;
        }
        this.yOrdinates = new double[yOrdinates.length][yOrdinates[0].length];
        for (int i = 0; i < yOrdinates[0].length; ++i) {
            for (int j = 0; j < yOrdinates.length; ++j) {
                this.yOrdinates[j][i] = yOrdinates[j][i];
            }
        }
    }

    @Scriptable
    public void setStartingEndingCurve(int startingCurve, int endingCurve) {
        this.startingCurve = startingCurve;
        this.endingCurve = endingCurve;
    }

    @Scriptable
    public void setStartingEndingOrdinage(int startingOrdinate, int endingOrdinate) {
        this.startingOrdinate = startingOrdinate;
        this.endingOrdinate = endingOrdinate;
    }

    @Scriptable
    public int getStartingCurve() {
        return this.startingCurve;
    }

    @Scriptable
    public int getEndingCurve() {
        return this.endingCurve;
    }

    @Scriptable
    public int getStartingOrdinate() {
        return this.startingOrdinate;
    }

    @Scriptable
    public int getEndingOrdinate() {
        return this.endingOrdinate;
    }

    @Scriptable
    public void clone(PairedDataContainer pdc) {
        super.clone(pdc);
        pdc.numberOrdinates = this.numberOrdinates;
        pdc.numberCurves = this.numberCurves;
        pdc.labelsUsed = this.labelsUsed;
        if (this.labelsUsed && this.labels != null) {
            pdc.labels = new String[this.labels.length];
            System.arraycopy(this.labels, 0, pdc.labels, 0, this.labels.length);
        }
        if (this.xOrdinates != null) {
            pdc.xOrdinates = new double[this.xOrdinates.length];
            System.arraycopy(this.xOrdinates, 0, pdc.xOrdinates, 0, this.xOrdinates.length);
        }
        if (this.yOrdinates != null) {
            pdc.yOrdinates = new double[this.yOrdinates.length][this.numberOrdinates];
            for (int i = 0; i < pdc.yOrdinates.length; ++i) {
                System.arraycopy(this.yOrdinates[i], 0, pdc.yOrdinates[i], 0, this.numberOrdinates);
            }
        }
        pdc.xunits = this.xunits;
        pdc.xtype = this.xtype;
        pdc.yunits = this.yunits;
        pdc.ytype = this.ytype;
        pdc.xprecision = this.xprecision;
        pdc.yprecision = this.yprecision;
        pdc.switchXyAxis = this.switchXyAxis;
        pdc.xparameter = this.xparameter;
        pdc.yparameter = this.yparameter;
        pdc.other = this.other;
        pdc.date = this.date;
        pdc.startingCurve = this.startingCurve;
        pdc.endingCurve = this.endingCurve;
        pdc.startingOrdinate = this.startingOrdinate;
        pdc.endingOrdinate = this.endingOrdinate;
        pdc.datum = this.datum;
        pdc.shift = this.shift;
        pdc.offset = this.offset;
        pdc.transformType = this.transformType;
        if (this.units != null) {
            pdc.units = new String[this.units.length];
            System.arraycopy(this.units, 0, pdc.units, 0, this.units.length);
        }
        if (this.parameters != null) {
            pdc.parameters = new String[this.parameters.length];
            System.arraycopy(this.parameters, 0, pdc.parameters, 0, this.parameters.length);
        }
        if (this.curveVisible != null) {
            pdc.curveVisible = new boolean[this.curveVisible.length];
            System.arraycopy(this.curveVisible, 0, pdc.curveVisible, 0, this.curveVisible.length);
        }
        if (this.types != null) {
            pdc.types = new String[this.types.length];
            System.arraycopy(this.types, 0, pdc.types, 0, this.types.length);
        }
        if (this.precisions != null) {
            pdc.precisions = new int[this.precisions.length];
            System.arraycopy(this.precisions, 0, pdc.precisions, 0, this.precisions.length);
        }
    }

    @Scriptable
    public Object clone() {
        PairedDataContainer pdc = new PairedDataContainer();
        this.clone(pdc);
        return pdc;
    }

    @Scriptable
    public String getAsString() {
        StringBuffer stb = new StringBuffer();
        stb.append("location " + this.fullName + "\n");
        stb.append("xunits " + this.xunits + "\n");
        stb.append("yunits " + this.yunits + "\n");
        stb.append("xtype " + this.xtype + "\n");
        stb.append("ytype " + this.ytype + "\n");
        for (int k = 0; k < this.numberCurves; ++k) {
            for (int j = 0; j < this.numberOrdinates; ++j) {
                stb.append("x" + this.xOrdinates[j] + " ");
                stb.append("y" + this.yOrdinates[k][j] + " ");
                stb.append("\n");
            }
            if (!this.labelsUsed || this.labels == null) continue;
            stb.append(" lab" + this.labels[k] + " ");
        }
        return stb.toString();
    }

    @Scriptable
    public String getAsXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\"?>\n");
        xml.append("<DSSPairedData>\n");
        xml.append("<location>" + this.fullName + "<location>\n");
        xml.append("<xunits>" + this.xunits + "</xunits>\n");
        xml.append("<yunits>" + this.yunits + "</yunits>\n");
        xml.append("<xtype>" + this.xtype + "</xtype>\n");
        xml.append("<ytype>" + this.ytype + "</ytype>\n");
        for (int k = 0; k < this.numberCurves; ++k) {
            xml.append("<Curve Num=" + (k + 1) + ">\n");
            for (int j = 0; j < this.numberOrdinates; ++j) {
                xml.append("<Ordinate num=" + (j + 1) + ">\n");
                xml.append("<x>" + this.xOrdinates[j] + "</x>\n ");
                xml.append("<y>" + this.yOrdinates[k][j] + "</y>\n");
                xml.append("</Ordinate>\n");
            }
            if (this.labelsUsed && this.labels != null) {
                xml.append("<label>" + this.labels[k] + "</label>\n");
            }
            xml.append("</Curve>\n");
        }
        xml.append("</DSSPairedData>\n");
        return xml.toString();
    }

    @Scriptable
    public static void ensureXOrdCapacity(PairedDataContainer pdc, int minimumCapacity) {
        if (minimumCapacity > PairedDataContainer.getXOrdCapacity(pdc)) {
            PairedDataContainer.enlargeXOrds(pdc, minimumCapacity);
        }
    }

    @Scriptable
    public static int getXOrdCapacity(PairedDataContainer pdc) {
        int capacity = -1;
        if (pdc != null && pdc.xOrdinates != null) {
            capacity = Math.min(pdc.numberOrdinates, pdc.xOrdinates.length);
        }
        return capacity;
    }

    @Scriptable
    public static void enlargeXOrds(PairedDataContainer pdc, int minimumCapacity) {
        PairedDataContainer.ensureXOrdinatesArrayCapacity(pdc, minimumCapacity);
        pdc.numberOrdinates = Math.max(pdc.numberOrdinates, minimumCapacity);
    }

    @Scriptable
    public static void ensureCurvesCapacity(PairedDataContainer pdc, int minimumCapacity) {
        for (int i = pdc.numberCurves - 1; i >= 0; --i) {
            PairedDataContainer.ensureCurveCapacity(pdc, i, minimumCapacity);
        }
    }

    @Scriptable
    public static void ensureCurveCapacity(PairedDataContainer pdc, int curveIndex, int minimumCapacity) {
        if (minimumCapacity > PairedDataContainer.getCurveCapacity(pdc, curveIndex)) {
            PairedDataContainer.ensureCurveExists(pdc, curveIndex);
            PairedDataContainer.enlargeCurve(pdc, curveIndex, minimumCapacity);
        }
    }

    @Scriptable
    public static int getCurveCapacity(PairedDataContainer pdc, int curveIndex) {
        int capacity = -1;
        if (pdc != null && pdc.yOrdinates != null && pdc.yOrdinates.length > curveIndex && pdc.yOrdinates[curveIndex] != null) {
            capacity = Math.min(pdc.yOrdinates[curveIndex].length, pdc.numberOrdinates);
        }
        return capacity;
    }

    private static void ensureXOrdinatesArrayCapacity(PairedDataContainer pdc, int minimumCapacity) {
        if (pdc.xOrdinates == null || minimumCapacity > pdc.xOrdinates.length) {
            int newSize = Math.max(64, minimumCapacity);
            double[] newXOrds = new double[newSize];
            Arrays.fill(newXOrds, -3.4028234663852886E38);
            if (pdc.xOrdinates != null) {
                System.arraycopy(pdc.xOrdinates, 0, newXOrds, 0, pdc.xOrdinates.length);
            }
            pdc.xOrdinates = newXOrds;
        }
    }

    @Scriptable
    public static boolean curveExists(PairedDataContainer pdcFrom, int fromIndex) {
        boolean hasCurve = false;
        if (null != pdcFrom && pdcFrom.numberCurves > fromIndex && pdcFrom.yOrdinates != null && pdcFrom.yOrdinates.length > fromIndex && pdcFrom.yOrdinates[fromIndex] != null) {
            hasCurve = true;
        }
        return hasCurve;
    }

    @Scriptable
    public static void ensureCurveExists(PairedDataContainer pdc, int curveIndex) {
        if (!PairedDataContainer.curveExists(pdc, curveIndex)) {
            int curvesToAllocate = Math.max(curveIndex + 1, pdc.numberCurves);
            double[][] newYOrds = new double[curvesToAllocate][];
            if (pdc.yOrdinates != null) {
                for (int i = 0; i < pdc.yOrdinates.length; ++i) {
                    if (null == pdc.yOrdinates[i]) continue;
                    newYOrds[i] = pdc.yOrdinates[i];
                }
            }
            pdc.yOrdinates = newYOrds;
            if (pdc.labelsUsed) {
                String template;
                PairedDataContainer.ensureLabelsCapacity(pdc, curveIndex);
                pdc.labels[curveIndex] = template = PairedDataContainer.guessLabelTemplate(pdc, curveIndex);
            }
            pdc.numberCurves = curvesToAllocate;
        }
    }

    public static String guessLabelTemplate(PairedDataContainer pdc, int curveIndex) {
        String label;
        String labelTemplate = "curve";
        if (pdc.labels != null && pdc.labels.length > 0 && null != (label = pdc.labels[0]) && !label.isEmpty()) {
            int firstNumber;
            String prefix = label.replaceFirst("[\\d]+$", "");
            String firstNumberLabel = label.substring(prefix.length());
            try {
                firstNumber = Integer.parseInt(firstNumberLabel);
            }
            catch (NumberFormatException e) {
                firstNumber = 1;
            }
            labelTemplate = prefix.concat(String.valueOf(firstNumber + curveIndex));
        }
        return labelTemplate;
    }

    @Scriptable
    public static void ensureLabelsCapacity(PairedDataContainer pdc, int curveIndex) {
        if (pdc.labels == null || pdc.labels.length <= curveIndex) {
            String[] newLabels = new String[curveIndex + 1];
            if (pdc.labels != null) {
                for (int i = 0; i < pdc.labels.length; ++i) {
                    newLabels[i] = pdc.labels[i];
                }
            }
            pdc.labels = newLabels;
        }
    }

    @Scriptable
    public static void enlargeCurve(PairedDataContainer pdc, int curveIndex, int minimumCapacity) {
        if (pdc.yOrdinates[curveIndex] == null || minimumCapacity > pdc.yOrdinates[curveIndex].length) {
            int newSize = Math.max(pdc.numberOrdinates, minimumCapacity);
            double[] newCurve = new double[newSize];
            Arrays.fill(newCurve, -3.4028234663852886E38);
            if (null != pdc.yOrdinates[curveIndex]) {
                System.arraycopy(pdc.yOrdinates[curveIndex], 0, newCurve, 0, pdc.yOrdinates[curveIndex].length);
            }
            pdc.yOrdinates[curveIndex] = newCurve;
        }
    }

    @Scriptable
    public static void copyCurve(PairedDataContainer pdcFrom, int fromIndex, PairedDataContainer pdcTo, int toIndex) {
        if (PairedDataContainer.curveExists(pdcFrom, fromIndex)) {
            PairedDataContainer.ensureCurveExists(pdcTo, toIndex);
            PairedDataContainer.ensureXOrdCapacity(pdcTo, pdcFrom.numberOrdinates);
            PairedDataContainer.ensureCurveCapacity(pdcTo, toIndex, pdcFrom.numberOrdinates);
            if (pdcTo.numberOrdinates > pdcFrom.numberOrdinates) {
                Arrays.fill(pdcTo.yOrdinates[toIndex], pdcFrom.numberOrdinates, pdcTo.numberOrdinates, -3.4028234663852886E38);
            }
            System.arraycopy(pdcFrom.yOrdinates[fromIndex], 0, pdcTo.yOrdinates[toIndex], 0, pdcFrom.numberOrdinates);
        } else {
            Logger.getLogger(PairedDataContainer.class.getName()).log(Level.WARNING, "Error, curve # " + fromIndex + " from " + pdcFrom.toString() + " is null or does not exist.");
        }
    }

    @Scriptable
    public static void copyCurves(PairedDataContainer pdcFrom, PairedDataContainer pdcTo) {
        for (int i = pdcFrom.numberCurves - 1; i >= 0; --i) {
            PairedDataContainer.copyCurve(pdcFrom, i, pdcTo, i);
        }
    }

    @Scriptable
    public static void copyXOrdinates(PairedDataContainer pdcFrom, PairedDataContainer pdcTo) {
        if (pdcTo.xOrdinates == null || pdcTo.xOrdinates.length != pdcFrom.numberOrdinates) {
            pdcTo.xOrdinates = new double[pdcFrom.numberOrdinates];
            pdcTo.numberOrdinates = pdcFrom.numberOrdinates;
        }
        System.arraycopy(pdcFrom.xOrdinates, 0, pdcTo.xOrdinates, 0, pdcFrom.numberOrdinates);
    }

    @Scriptable
    public static void copyLabels(PairedDataContainer pdcFrom, PairedDataContainer pdcTo) {
        if (pdcFrom.labels != null) {
            pdcTo.labels = Arrays.copyOf(pdcFrom.labels, pdcFrom.labels.length);
        }
    }

    @Override
    @Scriptable
    public PairedDataContainer expandVerticalDatum() {
        if (this instanceof VerticalDatum || this.supplementalInfo == null || this.supplementalInfo.indexOf("verticalDatumInfo:") == -1) {
            return (PairedDataContainer)this.clone();
        }
        try {
            VerticalDatumContainer vdc = this.extractVerticalDatum();
            return new PairedDataContainerVertDatum(this, vdc);
        }
        catch (IOException | RuntimeException | VerticalDatumException e) {
            Logger.getLogger(PairedDataContainer.class.getName()).log(Level.SEVERE, "expandVerticalDatum failed", e);
            return (PairedDataContainer)this.clone();
        }
    }

    @Override
    @Scriptable
    public PairedDataContainer collapseVerticalDatum() {
        if (this instanceof VerticalDatum) {
            PairedDataContainer collapsed = new PairedDataContainer();
            this.clone(collapsed);
            try {
                collapsed.insertVerticalDatum(((PairedDataContainerVertDatum)this).getVerticalDatumContainer());
            }
            catch (IOException | RuntimeException | VerticalDatumException e) {
                Logger.getLogger(PairedDataContainer.class.getName()).log(Level.SEVERE, "collapseVerticalDatum failed", e);
            }
            return collapsed;
        }
        return (PairedDataContainer)this.clone();
    }

    @Scriptable
    public void printToConsole() {
        int i;
        System.out.println("numberCurves: " + this.numberCurves);
        System.out.println("xunits: " + this.xunits);
        System.out.println("yunits: " + this.yunits);
        System.out.println("xtype: " + this.xtype);
        System.out.println("ytype: " + this.ytype);
        if (this.labels != null && this.labels.length > 0) {
            System.out.print(" xordinate");
            for (i = 0; i < this.labels.length; ++i) {
                System.out.print(", " + this.labels[i]);
                if (i <= this.labels.length - 1) continue;
                System.out.println(", ");
            }
            System.out.println();
        }
        if (this.xOrdinates != null) {
            for (i = 0; i < this.xOrdinates.length; ++i) {
                String s = "" + this.xOrdinates[i];
                for (int c2 = 0; c2 < this.numberCurves; ++c2) {
                    s = s + ", " + this.yOrdinates[c2][i];
                }
                System.out.println(s);
            }
        }
    }
}

