/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.PairedDataContainer;
import hec.util.TextUtil;
import java.io.IOException;
import java.util.HashMap;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.VerticalDatumException;

public class PairedDataContainerVertDatum
extends PairedDataContainer
implements VerticalDatum {
    private static final long serialVersionUID = -8296520844500259022L;
    private ElevParameter elevParameter = ElevParameter.UNSET;
    protected VerticalDatumContainer vdc = null;

    public PairedDataContainerVertDatum() {
    }

    public PairedDataContainerVertDatum(PairedDataContainer tsc) {
        if (tsc != null) {
            tsc.clone(this);
        }
    }

    public PairedDataContainerVertDatum(PairedDataContainer tsc, VerticalDatumContainer vdc) throws VerticalDatumException {
        if (tsc != null) {
            tsc.clone(this);
        }
        if (vdc != null) {
            this.vdc = vdc.clone();
        }
        this.initFromVdc();
    }

    public PairedDataContainerVertDatum(VerticalDatumContainer vdc) {
        if (vdc != null) {
            this.vdc = vdc.clone();
        }
    }

    @Override
    public Object clone() {
        PairedDataContainerVertDatum pdcvd = new PairedDataContainerVertDatum();
        this.clone(pdcvd);
        return pdcvd;
    }

    @Override
    public void clone(PairedDataContainer pdc) {
        super.clone(pdc);
        if (pdc instanceof PairedDataContainerVertDatum) {
            PairedDataContainerVertDatum pdcvd = (PairedDataContainerVertDatum)pdc;
            if (this.vdc == null) {
                pdcvd.vdc = null;
            } else {
                if (pdcvd.vdc == null) {
                    pdcvd.vdc = new VerticalDatumContainer();
                }
                this.vdc.clone(pdcvd.vdc);
            }
        }
    }

    public String getNativeVerticalDatum() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this.vdc.getNativeVerticalDatum();
    }

    public String getCurrentVerticalDatum() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this.vdc.getCurrentVerticalDatum();
    }

    public boolean isCurrentVerticalDatumEstimated() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this.vdc.isCurrentVerticalDatumEstimated();
    }

    public boolean toNativeVerticalDatum() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        double xOffset = -3.4028234663852886E38;
        double yOffset = -3.4028234663852886E38;
        switch (this.elevParameter) {
            case X: {
                xOffset = this.vdc.getCurrentOffset(this.xunits);
                break;
            }
            case Y: {
                yOffset = this.vdc.getCurrentOffset(this.yunits);
                break;
            }
            case XY: {
                xOffset = this.vdc.getCurrentOffset(this.xunits);
                yOffset = this.vdc.getCurrentOffset(this.yunits);
                break;
            }
            default: {
                throw new VerticalDatumException("Cannot determine if elevation is x, y, or both");
            }
        }
        boolean change = this.vdc.toNativeVerticalDatum();
        if (change) {
            int i;
            if (this.elevParameter == ElevParameter.X || this.elevParameter == ElevParameter.XY) {
                for (i = 0; i < this.numberOrdinates; ++i) {
                    if (this.xOrdinates[i] == -3.4028234663852886E38) continue;
                    int n = i;
                    this.xOrdinates[n] = this.xOrdinates[n] - xOffset;
                }
            }
            if (this.elevParameter == ElevParameter.Y || this.elevParameter == ElevParameter.XY) {
                for (i = 0; i < this.numberCurves; ++i) {
                    for (int j = 0; j < this.numberOrdinates; ++j) {
                        if (this.yOrdinates[i][j] == -3.4028234663852886E38) continue;
                        double[] dArray = this.yOrdinates[i];
                        int n = j;
                        dArray[n] = dArray[n] - yOffset;
                    }
                }
            }
            this.initFromVdc();
        }
        return change;
    }

    public boolean toNGVD29() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        double xOffset = -3.4028234663852886E38;
        double yOffset = -3.4028234663852886E38;
        switch (this.elevParameter) {
            case X: {
                xOffset = this.vdc.getNGVD29Offset(this.xunits) - this.vdc.getCurrentOffset(this.xunits);
                break;
            }
            case Y: {
                yOffset = this.vdc.getNGVD29Offset(this.yunits) - this.vdc.getCurrentOffset(this.yunits);
                break;
            }
            case XY: {
                xOffset = this.vdc.getNGVD29Offset(this.xunits) - this.vdc.getCurrentOffset(this.xunits);
                yOffset = this.vdc.getNGVD29Offset(this.yunits) - this.vdc.getCurrentOffset(this.yunits);
                break;
            }
            default: {
                throw new VerticalDatumException("Cannot determine if elevation is x, y, or both");
            }
        }
        boolean change = this.vdc.toNGVD29();
        if (change) {
            int i;
            if (this.elevParameter == ElevParameter.X || this.elevParameter == ElevParameter.XY) {
                for (i = 0; i < this.numberOrdinates; ++i) {
                    if (this.xOrdinates[i] == -3.4028234663852886E38) continue;
                    int n = i;
                    this.xOrdinates[n] = this.xOrdinates[n] + xOffset;
                }
            }
            if (this.elevParameter == ElevParameter.Y || this.elevParameter == ElevParameter.XY) {
                for (i = 0; i < this.numberCurves; ++i) {
                    for (int j = 0; j < this.numberOrdinates; ++j) {
                        if (this.yOrdinates[i][j] == -3.4028234663852886E38) continue;
                        double[] dArray = this.yOrdinates[i];
                        int n = j;
                        dArray[n] = dArray[n] + yOffset;
                    }
                }
            }
            this.initFromVdc();
        }
        return change;
    }

    public boolean toNAVD88() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        double xOffset = -3.4028234663852886E38;
        double yOffset = -3.4028234663852886E38;
        switch (this.elevParameter) {
            case X: {
                xOffset = this.vdc.getNAVD88Offset(this.xunits) - this.vdc.getCurrentOffset(this.xunits);
                break;
            }
            case Y: {
                yOffset = this.vdc.getNAVD88Offset(this.yunits) - this.vdc.getCurrentOffset(this.yunits);
                break;
            }
            case XY: {
                xOffset = this.vdc.getNAVD88Offset(this.xunits) - this.vdc.getCurrentOffset(this.xunits);
                yOffset = this.vdc.getNAVD88Offset(this.yunits) - this.vdc.getCurrentOffset(this.yunits);
                break;
            }
            default: {
                throw new VerticalDatumException("Cannot determine if elevation is x, y, or both");
            }
        }
        boolean change = this.vdc.toNAVD88();
        if (change) {
            int i;
            if (this.elevParameter == ElevParameter.X || this.elevParameter == ElevParameter.XY) {
                for (i = 0; i < this.numberOrdinates; ++i) {
                    if (this.xOrdinates[i] == -3.4028234663852886E38) continue;
                    int n = i;
                    this.xOrdinates[n] = this.xOrdinates[n] + xOffset;
                }
            }
            if (this.elevParameter == ElevParameter.Y || this.elevParameter == ElevParameter.XY) {
                for (i = 0; i < this.numberCurves; ++i) {
                    for (int j = 0; j < this.numberOrdinates; ++j) {
                        if (this.yOrdinates[i][j] == -3.4028234663852886E38) continue;
                        double[] dArray = this.yOrdinates[i];
                        int n = j;
                        dArray[n] = dArray[n] + yOffset;
                    }
                }
            }
            this.initFromVdc();
        }
        return change;
    }

    public boolean toVerticalDatum(String datum) throws VerticalDatumException {
        if (datum == null) {
            throw new VerticalDatumException("Null datum specified");
        }
        switch (datum.toUpperCase().replaceAll("(N[AG]VD)-(29|88)", "$1$2")) {
            case "NGVD29": {
                return this.toNGVD29();
            }
            case "NAVD88": {
                return this.toNAVD88();
            }
            case "NATIVE": {
                return this.toNativeVerticalDatum();
            }
            case "LOCAL": {
                if (!this.getNativeVerticalDatum().equals("LOCAL")) {
                    throw new VerticalDatumException("Object does not have LOCAL vertical datum");
                }
                return this.toNativeVerticalDatum();
            }
        }
        throw new VerticalDatumException("Unexpected datum: " + datum);
    }

    public boolean forceVerticalDatum(String datum) throws VerticalDatumException {
        return this.vdc.forceVerticalDatum(datum);
    }

    public double getCurrentOffset() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        double xOffset = -3.4028234663852886E38;
        double yOffset = -3.4028234663852886E38;
        switch (this.elevParameter) {
            case X: {
                return this.getCurrentOffset(this.xunits);
            }
            case Y: {
                return this.getCurrentOffset(this.yunits);
            }
            case XY: {
                xOffset = this.getCurrentOffset(this.xunits);
                yOffset = this.getCurrentOffset(this.yunits);
                if (xOffset == yOffset) {
                    return xOffset;
                }
                throw new VerticalDatumException("PairedDataContainer has different offsets for xunits (" + this.xunits + ") and yunits(" + this.yunits + ")");
            }
        }
        throw new VerticalDatumException("Cannot determine if elevation is x, y, or both");
    }

    public double getCurrentOffset(String unit) throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this.vdc.getCurrentOffset(unit);
    }

    public double getNGVD29Offset() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        double xOffset = -3.4028234663852886E38;
        double yOffset = -3.4028234663852886E38;
        switch (this.elevParameter) {
            case X: {
                return this.getNGVD29Offset(this.xunits);
            }
            case Y: {
                return this.getNGVD29Offset(this.yunits);
            }
            case XY: {
                xOffset = this.getNGVD29Offset(this.xunits);
                yOffset = this.getNGVD29Offset(this.yunits);
                if (xOffset == yOffset) {
                    return xOffset;
                }
                throw new VerticalDatumException("PairedDataContainer has different offsets for xunits (" + this.xunits + ") and yunits(" + this.yunits + ")");
            }
        }
        throw new VerticalDatumException("Cannot determine if elevation is x, y, or both");
    }

    public double getNGVD29Offset(String unit) throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this.vdc.getNGVD29Offset(unit);
    }

    public double getNAVD88Offset() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        double xOffset = -3.4028234663852886E38;
        double yOffset = -3.4028234663852886E38;
        switch (this.elevParameter) {
            case X: {
                return this.getNAVD88Offset(this.xunits);
            }
            case Y: {
                return this.getNAVD88Offset(this.yunits);
            }
            case XY: {
                xOffset = this.getNAVD88Offset(this.xunits);
                yOffset = this.getNAVD88Offset(this.yunits);
                if (xOffset == yOffset) {
                    return xOffset;
                }
                throw new VerticalDatumException("PairedDataContainer has different offsets for xunits (" + this.xunits + ") and yunits(" + this.yunits + ")");
            }
        }
        throw new VerticalDatumException("Cannot determine if elevation is x, y, or both");
    }

    public double getNAVD88Offset(String unit) throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this.vdc.getNAVD88Offset(unit);
    }

    public boolean isNGVD29OffsetEstimated() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this.vdc.isNGVD29OffsetEstimated();
    }

    public boolean isNAVD88OffsetEstimated() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this.vdc.isNAVD88OffsetEstimated();
    }

    public String getVerticalDatumInfo() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this.vdc.getVerticalDatumInfo();
    }

    public void setVerticalDatumInfo(String xmlStr) throws VerticalDatumException {
        if (this.vdc == null) {
            this.vdc = new VerticalDatumContainer();
        }
        this.vdc.setVerticalDatumInfo(xmlStr);
    }

    public void setVerticalDatumContainer(VerticalDatumContainer vdc) throws VerticalDatumException {
        this.vdc = vdc == null ? vdc : vdc.clone();
        this.initFromVdc();
    }

    private void checkParameter() throws VerticalDatumException {
        this.elevParameter = this.xparameter != null && this.xparameter.toUpperCase().startsWith("ELEV") ? (this.yparameter != null && this.yparameter.toUpperCase().startsWith("ELEV") ? ElevParameter.XY : ElevParameter.X) : (this.yparameter != null && this.yparameter.toUpperCase().startsWith("ELEV") ? ElevParameter.Y : ElevParameter.UNSET);
        if (this.elevParameter == ElevParameter.UNSET && this.xparameter != null && this.xparameter.trim().length() != 0 && this.yparameter != null && this.yparameter.trim().length() != 0) {
            throw new VerticalDatumException("X or Y parameter must be elevation - got \"" + this.xparameter + " - " + this.yparameter + "\"");
        }
    }

    private void checkVerticalDatumContainer() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("VerticalDatumContainer has not been initialized");
        }
        this.checkParameter();
    }

    private void initFromVdc() throws VerticalDatumException {
        if (this.vdc == null) {
            this.verticalDatum = 0;
            this.verticalUnits = 0;
        } else {
            if (this.vdc.currentDatum == null) {
                this.verticalDatum = 0;
            } else {
                switch (this.vdc.currentDatum) {
                    default: {
                        this.verticalDatum = 0;
                        break;
                    }
                    case "NAVD88": {
                        this.verticalDatum = 1;
                        break;
                    }
                    case "NGVD29": {
                        this.verticalDatum = 2;
                    }
                }
            }
            if (this.vdc.unit == null) {
                this.verticalUnits = 0;
            } else {
                switch (this.vdc.unit) {
                    default: {
                        this.verticalUnits = 0;
                        break;
                    }
                    case "ft": {
                        this.verticalUnits = 1;
                        break;
                    }
                    case "m": {
                        this.verticalUnits = 2;
                    }
                }
            }
        }
    }

    @Override
    public VerticalDatumContainer extractVerticalDatum() throws VerticalDatumException, IOException {
        String vdi;
        if (this.vdc != null) {
            return this.vdc.clone();
        }
        HashMap<String, String> si = this.getSupplementalInfo();
        if (si.containsKey("verticalDatumInfo") && (vdi = si.get("verticalDatumInfo")) != null) {
            return new VerticalDatumContainer(TextUtil.uncompress(vdi, "base64"));
        }
        return null;
    }

    @Override
    public void insertVerticalDatum(VerticalDatumContainer vdc) throws IOException {
        this.vdc = vdc.clone();
        HashMap<String, String> si = this.getSupplementalInfo();
        if (si.containsKey("verticalDatumInfo")) {
            si.remove("verticalDatumInfo");
            this.setSupplementalInfo(si);
        }
    }

    public VerticalDatumContainer getVerticalDatumContainer() {
        return this.vdc;
    }

    private static enum ElevParameter {
        UNSET,
        X,
        Y,
        XY;

    }
}

