/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.lang.PasswordFileEntry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import rma.util.RMAIO;

public class PasswordFile
implements AutoCloseable {
    private static final int SALT_LENGTH = 8;
    static final String VERSION10 = "v1.0";
    static final String VERSION20 = "v2.0";
    private static final String DELIMITER = "|";
    private static String CURRENT_VERSION = "v2.0";
    private static final String COMMENT = "#";
    private String _fileName;
    private Vector<String> _fileContents = new Vector();
    private File _lckFile = null;
    private static final Logger logger = Logger.getLogger(PasswordFile.class.getName());

    public PasswordFile(String fileName, boolean lock) throws IOException {
        this._fileName = RMAIO.parsePathName(fileName);
        String filename = RMAIO.getPathNoExtension(this._fileName);
        if (lock) {
            this._lckFile = new File(filename + ".lck");
            try {
                if (!this._lckFile.createNewFile()) {
                    if (this._lckFile.exists()) {
                        throw new IOException("File " + this._fileName + " is currently locked");
                    }
                    throw new IOException("Failed to create lock file " + this._lckFile.getPath());
                }
            }
            catch (IOException ioe) {
                System.out.println("Error creating lock file " + this._lckFile.getPath() + " Error:" + ioe);
                throw ioe;
            }
        }
        this.readFile();
    }

    @Override
    public void close() {
        if (this._lckFile == null) {
            return;
        }
        if (!this._lckFile.delete() && this._lckFile.exists()) {
            System.out.println("close: failed to delete lock file " + this._lckFile.getPath());
        }
    }

    protected boolean readFile() {
        this._fileContents.clear();
        if (this._fileName == null) {
            return false;
        }
        File file = new File(this._fileName);
        if (!file.exists()) {
            this._fileContents.add(CURRENT_VERSION);
            System.out.println("readFile: " + file.getPath() + " doesn't exist");
            return true;
        }
        if (!file.canRead()) {
            System.out.println("readFile: can not read " + file.getPath());
            return false;
        }
        try {
            String version;
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            System.out.println("readFile: reading " + file.getPath());
            while ((line = reader.readLine()) != null) {
                this._fileContents.add(line.trim());
            }
            reader.close();
            if (this._fileContents.size() == 0) {
                this._fileContents.add(CURRENT_VERSION);
            }
            if ((version = this.getVersion()) != null && !version.equals(CURRENT_VERSION)) {
                this.updateToCurrentVersion(version);
            }
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    static final void setCurrentVersion(String version) {
        CURRENT_VERSION = version;
    }

    private boolean updateToCurrentVersion(String oldVersion) {
        Vector<String> newContents = new Vector<String>();
        String version = CURRENT_VERSION;
        boolean firstNonCommentLine = true;
        for (String line : this._fileContents) {
            String newLine;
            if (this.isComment(line)) {
                newContents.add(line);
                continue;
            }
            if (firstNonCommentLine) {
                version = line;
                newContents.add(CURRENT_VERSION);
                firstNonCommentLine = false;
                continue;
            }
            String tag = RMAIO.getType(line, DELIMITER);
            String param = RMAIO.getParam(line, DELIMITER);
            PasswordFileEntry entry = this.decryptEntry(version, param);
            try {
                newLine = this.createEntry(tag, entry.getUserName(), entry.getPassword());
            }
            catch (GeneralSecurityException e) {
                System.out.println("Error creating password entry: " + e.getMessage());
                return false;
            }
            newContents.add(newLine);
        }
        if (this._fileContents.size() == newContents.size()) {
            this._fileContents = newContents;
        }
        return this.writeFile();
    }

    public boolean writeFile() {
        if (this._fileName == null) {
            return false;
        }
        try {
            File file = new File(this._fileName);
            if (file.exists()) {
                // empty if block
            }
            boolean firstNonCommentLine = true;
            BufferedWriter writer = new BufferedWriter(new FileWriter(this._fileName));
            for (int i = 0; i < this._fileContents.size(); ++i) {
                String line = this._fileContents.get(i);
                if (this.isComment(line)) {
                    RMAIO.fout(writer, line);
                    continue;
                }
                if (firstNonCommentLine) {
                    RMAIO.fout(writer, CURRENT_VERSION);
                    firstNonCommentLine = false;
                    continue;
                }
                RMAIO.fout(writer, line);
            }
            writer.flush();
            writer.close();
        }
        catch (IOException ioe) {
            System.out.println("writeFile: error writing " + this._fileName + " Exception:" + ioe);
            return false;
        }
        return true;
    }

    protected boolean isComment(String line) {
        return line.startsWith(COMMENT);
    }

    public Vector getEntries() {
        Vector<Object> v = new Vector<Object>(this._fileContents.size());
        String version = CURRENT_VERSION;
        boolean firstNonCommentLine = true;
        for (int i = 0; i < this._fileContents.size(); ++i) {
            String line = this._fileContents.get(i);
            if (this.isComment(line)) {
                System.out.println(line);
                continue;
            }
            if (firstNonCommentLine) {
                v.add(line);
                version = line;
                firstNonCommentLine = false;
                continue;
            }
            String tag = RMAIO.getType(line, DELIMITER);
            String param = RMAIO.getParam(line, DELIMITER);
            PasswordFileEntry pfe = this.decryptEntry(version, param);
            if (pfe == null) continue;
            pfe.setId(tag);
            v.add(pfe);
        }
        return v;
    }

    public void print() {
        String version = CURRENT_VERSION;
        boolean firstNonCommentLine = true;
        for (int i = 0; i < this._fileContents.size(); ++i) {
            String line = this._fileContents.get(i);
            if (this.isComment(line)) {
                System.out.println(line);
                continue;
            }
            if (firstNonCommentLine) {
                System.out.println("Version=" + line);
                version = line;
                firstNonCommentLine = false;
                continue;
            }
            String tag = RMAIO.getType(line, DELIMITER);
            String param = RMAIO.getParam(line, DELIMITER);
            PasswordFileEntry pfe = this.decryptEntry(version, param);
            if (pfe != null) {
                pfe.setId(tag);
                System.out.println("Id=" + tag + " User=" + pfe.getUserName());
                continue;
            }
            System.out.println("Id=" + tag + " User=<unreadable>");
        }
    }

    public boolean add(String id, String user, String password) {
        if (id == null || user == null || password == null) {
            return false;
        }
        if (this.getEntry(id) != null) {
            System.out.println("add: id " + id + " already exists.");
            return false;
        }
        try {
            this._fileContents.add(this.createEntry(id, user, password));
        }
        catch (GeneralSecurityException e) {
            System.out.println("Error creating password entry: " + e.getMessage());
            return false;
        }
        return this.writeFile();
    }

    public boolean replace(String id, String user, String password) {
        String entry;
        if (id == null || user == null || password == null) {
            return false;
        }
        int idx = this.findEntry(id);
        if (idx == -1) {
            System.out.println("replace: id " + id + " doesn't exist.");
            return false;
        }
        try {
            entry = this.createEntry(id, user, password);
        }
        catch (GeneralSecurityException e) {
            System.out.println("Error creating password entry: " + e.getMessage());
            return false;
        }
        this._fileContents.set(idx, entry);
        return this.writeFile();
    }

    public boolean delete(String id) {
        if (id == null) {
            return false;
        }
        int idx = this.findEntry(id);
        if (idx == -1) {
            System.out.println("delete: id " + id + " doesn't exist.");
            return false;
        }
        this._fileContents.remove(idx);
        return this.writeFile();
    }

    private String createEntry(String id, String user, String password) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, InvalidKeySpecException, IllegalBlockSizeException, BadPaddingException {
        System.out.println("createEntry: for " + id + " user=" + user);
        StringBuffer buf = new StringBuffer(id);
        buf.append(DELIMITER);
        String userPass = user + DELIMITER + password;
        byte[] salted = this.cipherEncrypt(userPass);
        Base64.Encoder encoder = Base64.getEncoder();
        String encoded = encoder.encodeToString(salted);
        String rot13Encoded = this.rot13(encoded);
        buf.append(rot13Encoded);
        return buf.toString();
    }

    private byte[] cipherEncrypt(String userPass) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidKeySpecException, IllegalBlockSizeException, BadPaddingException {
        Random random = new Random();
        byte[] salt = new byte[8];
        random.nextBytes(salt);
        byte[] strBytes = userPass.getBytes();
        Cipher cipher = this.getCipher(salt, 1);
        byte[] encryptedStrBytes = cipher.doFinal(strBytes);
        byte[] saltyBytes = new byte[encryptedStrBytes.length + 8];
        System.arraycopy(salt, 0, saltyBytes, 0, 8);
        System.arraycopy(encryptedStrBytes, 0, saltyBytes, 8, encryptedStrBytes.length);
        return saltyBytes;
    }

    private Cipher getCipher(byte[] keyBytes, int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidKeySpecException {
        DESKeySpec keySpec = new DESKeySpec(keyBytes);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey key = keyFactory.generateSecret(keySpec);
        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        cipher.init(mode, key);
        return cipher;
    }

    public int findEntry(String identifier) {
        if (identifier == null) {
            return -1;
        }
        String version = CURRENT_VERSION;
        boolean firstNonCommentLine = true;
        for (int i = 0; i < this._fileContents.size(); ++i) {
            String line = this._fileContents.get(i);
            if (this.isComment(line)) continue;
            if (firstNonCommentLine) {
                version = line;
                firstNonCommentLine = false;
                continue;
            }
            String tag = RMAIO.getType(line, DELIMITER);
            String param = RMAIO.getParam(line, DELIMITER);
            if (!tag.equals(identifier)) continue;
            return i;
        }
        return -1;
    }

    public String getVersion() {
        String version = CURRENT_VERSION;
        for (int i = 0; i < this._fileContents.size(); ++i) {
            String line = this._fileContents.get(i);
            if (this.isComment(line)) continue;
            version = line;
            return version;
        }
        return null;
    }

    public PasswordFileEntry getEntry(String identifier) {
        if (identifier == null) {
            return null;
        }
        String version = CURRENT_VERSION;
        boolean firstNonCommentLine = true;
        for (int i = 0; i < this._fileContents.size(); ++i) {
            String line = this._fileContents.get(i);
            if (this.isComment(line)) continue;
            if (firstNonCommentLine) {
                version = line;
                firstNonCommentLine = false;
                continue;
            }
            String tag = RMAIO.getType(line, DELIMITER);
            String param = RMAIO.getParam(line, DELIMITER);
            if (!tag.equals(identifier)) continue;
            return this.decryptEntry(version, param);
        }
        return null;
    }

    private PasswordFileEntry decryptEntry(String version, String userPass) {
        if (VERSION10.equals(version)) {
            return this.decryptVersion10(userPass);
        }
        if (VERSION20.equals(version)) {
            return this.decryptVersion20(userPass);
        }
        return null;
    }

    private PasswordFileEntry decryptVersion20(String userPass) {
        byte[] saltyBytes = this.decryptVersion10String(userPass);
        byte[] salt = Arrays.copyOf(saltyBytes, 8);
        byte[] encryptedStrBytes = Arrays.copyOfRange(saltyBytes, 8, saltyBytes.length);
        try {
            Cipher cipher = this.getCipher(salt, 2);
            byte[] strBytes = cipher.doFinal(encryptedStrBytes);
            userPass = new String(strBytes);
            return this.buildPasswordFileEntry(userPass);
        }
        catch (GeneralSecurityException e) {
            System.out.println("decryptVersion20: error decrypting " + e);
            return null;
        }
    }

    private PasswordFileEntry decryptVersion10(String userPass) {
        userPass = new String(this.decryptVersion10String(userPass));
        return this.buildPasswordFileEntry(userPass);
    }

    private PasswordFileEntry buildPasswordFileEntry(String userPass) {
        PasswordFileEntry up = new PasswordFileEntry(RMAIO.getType(userPass, DELIMITER), RMAIO.getParam(userPass, DELIMITER));
        return up;
    }

    private byte[] decryptVersion10String(String userPass) {
        String decryptedUserPass = this.rot13(userPass);
        try {
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] decoded = decoder.decode(decryptedUserPass);
            return decoded;
        }
        catch (IllegalArgumentException ioe) {
            System.out.println("decryptVersion10: error decrypting " + ioe);
            return null;
        }
    }

    private String rot13(String userPass) {
        byte[] inBytes = userPass.getBytes();
        byte[] outBytes = new byte[inBytes.length];
        int abyte = 0;
        for (int i = 0; i < inBytes.length; ++i) {
            int cap;
            abyte = inBytes[i];
            abyte = ((abyte &= ~(cap = abyte & 0x20)) >= 65 && abyte <= 90 ? (abyte - 65 + 13) % 26 + 65 : abyte) | cap;
            outBytes[i] = (byte)abyte;
        }
        return new String(outBytes);
    }

    private static void printUsage() {
        System.out.println("USAGE: PasswordFile <file> print");
        System.out.println("\t PasswordFile <file> add <id> <user> <password>");
        System.out.println("\t PasswordFile <file> replace <id> <user> <password>");
        System.out.println("\t PasswordFile <file> delete <id>");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            PasswordFile.printUsage();
        }
        String file = args[0];
        PasswordFile pf = null;
        try {
            pf = new PasswordFile(file, true);
            pf._lckFile.deleteOnExit();
        }
        catch (IOException ioe) {
            System.exit(2);
        }
        if ("print".equalsIgnoreCase(args[1])) {
            pf.print();
            pf.close();
            System.exit(0);
        } else if ("add".equalsIgnoreCase(args[1]) && args.length == 5) {
            if (pf.add(args[2], args[3], args[4])) {
                pf.close();
                System.exit(0);
            }
        } else if ("replace".equalsIgnoreCase(args[1]) && args.length == 5) {
            if (pf.replace(args[2], args[3], args[4])) {
                pf.close();
                System.exit(0);
            }
        } else if ("delete".equalsIgnoreCase(args[1]) && args.length == 3) {
            if (pf.delete(args[2])) {
                pf.close();
                System.exit(0);
            }
        } else if ("get".equalsIgnoreCase(args[1]) && args.length == 3) {
            PasswordFileEntry up = pf.getEntry(args[2]);
            pf.close();
            if (up != null) {
                System.out.println(up.toString());
                System.exit(0);
            }
        } else {
            PasswordFile.printUsage();
        }
        System.exit(1);
    }
}

