/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import com.google.common.flogger.FluentLogger;
import hec.io.DaemonThreadFactory;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class PeriodicLogger
extends TimerTask {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    public static final String RUN_PROPERTY = "PeriodicLogger.run";
    private static final long MILLISECONDS_IN_SECOND = 1000L;
    private static final long SECONDS_IN_MINUTE = 60L;
    private static final long MILLIS_IN_MINUTE = 60000L;
    public static final String MESSAGE_PROPERTY = "PeriodicLogger.message";
    private final ScheduledExecutorService _execService;

    private PeriodicLogger(ScheduledExecutorService execService) {
        this._execService = execService;
    }

    @Override
    public void run() {
        ((FluentLogger.Api)LOGGER.atInfo()).log(System.getProperty(MESSAGE_PROPERTY, ""));
        PeriodicLogger.schedule(this, this._execService);
    }

    public void shutdown() {
        this._execService.shutdown();
    }

    public static PeriodicLogger runAtFixedRate(boolean isDaemon) {
        ScheduledExecutorService singleThreadScheduledExecutor = isDaemon ? Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory()) : Executors.newSingleThreadScheduledExecutor();
        PeriodicLogger periodicLogger = new PeriodicLogger(singleThreadScheduledExecutor);
        PeriodicLogger.schedule(periodicLogger, singleThreadScheduledExecutor);
        return periodicLogger;
    }

    private static void schedule(PeriodicLogger periodicLogger, ScheduledExecutorService singleThreadScheduledExecutor) {
        LocalDateTime now = LocalDateTime.now();
        ((FluentLogger.Api)LOGGER.atFine()).log("Current time is %s", (Object)now);
        int mins = now.getMinute();
        mins = (mins + 15) / 15 * 15;
        ((FluentLogger.Api)LOGGER.atFine()).log("Calculated minutes: %s", mins);
        int hour = now.getHour();
        if (mins == 60) {
            mins = 0;
            if (hour < 24) {
                ++hour;
            }
        }
        boolean incrementDay = false;
        if (hour == 24) {
            ((FluentLogger.Api)LOGGER.atFine()).log("Hour is 24, crossing the midnight boundary. Resetting hour to 0, incrementing day.");
            incrementDay = true;
            hour = 0;
        }
        ((FluentLogger.Api)LOGGER.atFine()).log("Calculated hour: %s", hour);
        LocalDateTime timeToRun = LocalDateTime.now();
        timeToRun = timeToRun.withHour(hour);
        timeToRun = timeToRun.withMinute(mins);
        timeToRun = timeToRun.withSecond(0);
        timeToRun = timeToRun.withNano(0);
        if (incrementDay) {
            timeToRun = timeToRun.plusDays(1L);
        }
        ((FluentLogger.Api)LOGGER.atFine()).log("Calculated time to run: %s", (Object)timeToRun);
        long delay = ChronoUnit.MILLIS.between(now, timeToRun);
        ((FluentLogger.Api)LOGGER.atFine()).log("Delay: %s", delay);
        if (delay < 1L) {
            ((FluentLogger.Api)LOGGER.atWarning()).log("Warning: Delay %s is less than 1ms! Scheduling start time is %s and calculated time is %s", (Object)delay, (Object)now, (Object)timeToRun);
        }
        singleThreadScheduledExecutor.schedule(periodicLogger, delay, TimeUnit.MILLISECONDS);
        ((FluentLogger.Api)LOGGER.atFine()).log("Logger scheduled to run in %s ms.", delay);
    }
}

