/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.ProcessOutputLine;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ProcessOutput
implements Serializable {
    static final long serialVersionUID = -4467745498135452600L;
    private int _exitCode;
    private List _processOutput = new ArrayList();
    private String _cmd;

    public ProcessOutput(String cmd) {
        this._cmd = cmd;
    }

    public ProcessOutput(String[] cmd) {
        StringBuffer buf = new StringBuffer();
        if (cmd != null) {
            for (int i = 0; i < cmd.length; ++i) {
                buf.append(cmd[i]);
                buf.append(" ");
            }
            this._cmd = buf.toString();
        }
    }

    public void setExitCode(int code) {
        this._exitCode = code;
    }

    public int getExitCode() {
        return this._exitCode;
    }

    public void setProcessOutput(List output) {
        if (output != null) {
            this._processOutput.addAll(output);
        }
    }

    public List<String> getProcessOutput() {
        ArrayList<String> l = new ArrayList<String>(this._processOutput.size());
        int size = this._processOutput.size();
        for (int i = 0; i < size; ++i) {
            Object obj = this._processOutput.get(i);
            if (obj == null) continue;
            l.add(obj.toString());
        }
        return l;
    }

    public List<String> getStderr() {
        ArrayList<String> l = new ArrayList<String>();
        int size = this._processOutput.size();
        for (int i = 0; i < size; ++i) {
            ProcessOutputLine line;
            Object obj = this._processOutput.get(i);
            if (!(obj instanceof ProcessOutputLine) || !(line = (ProcessOutputLine)obj).isStderr()) continue;
            l.add(line.getLine());
        }
        return l;
    }

    public List<String> getStdout() {
        ArrayList<String> l = new ArrayList<String>();
        int size = this._processOutput.size();
        for (int i = 0; i < size; ++i) {
            Object obj = this._processOutput.get(i);
            if (obj instanceof ProcessOutputLine) {
                ProcessOutputLine line = (ProcessOutputLine)obj;
                if (!line.isStdout()) continue;
                l.add(line.getLine());
                continue;
            }
            if (obj == null) continue;
            l.add(obj.toString());
        }
        return l;
    }

    public void addProcessOutput(ProcessOutputLine message) {
        this._processOutput.add(message);
    }

    public String getCommand() {
        return this._cmd;
    }
}

