/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.ProcessOutputLine;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;

public class ProcessOutputReader
extends Thread {
    private BufferedReader _reader;
    private List _output;
    private long _linesRead;
    private boolean _echoOutput;
    private boolean _stderr;

    public ProcessOutputReader(BufferedReader reader, List output, String name, boolean echoOutput, boolean stderr) {
        super(name + " Reader");
        this._output = output;
        this._reader = reader;
        this._echoOutput = echoOutput;
        this._stderr = stderr;
        this.setPriority(7);
        this.start();
    }

    public void close() {
        if (this._reader != null) {
            try {
                this._reader.close();
                this._reader = null;
            }
            catch (IOException e) {
                System.out.println("close: IOException " + e);
            }
        }
    }

    @Override
    public void run() {
        if (this._reader == null) {
            return;
        }
        System.out.println("readOutput: " + this.getName() + " started");
        try {
            String line;
            while (this._reader != null && (line = this._reader.readLine()) != null) {
                ++this._linesRead;
                this._output.add(new ProcessOutputLine(line, this._stderr));
                if (!this._echoOutput) continue;
                System.out.println(line);
            }
        }
        catch (IOException e) {
            System.out.println("readOutput:IOException " + e);
            return;
        }
    }

    public boolean hasReadLines() {
        return this._linesRead > 0L;
    }

    public long getLinesRead() {
        return this._linesRead;
    }
}

