/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import java.io.Serializable;

public class RatingValuesContainer
implements Cloneable,
Serializable {
    public double[] values = null;
    public int interpolateBehavior = 0;
    public int underflowBehavior = 0;
    public double underflowValue = 0.0;
    public int overflowBehavior = 0;
    public double overflowValue = 0.0;

    public Object clone() {
        RatingValuesContainer rvc = new RatingValuesContainer();
        rvc.copyFrom(this);
        return rvc;
    }

    public void copyFrom(RatingValuesContainer other) {
        this.values = (double[])other.values.clone();
        this.interpolateBehavior = other.interpolateBehavior;
        this.underflowBehavior = other.underflowBehavior;
        this.underflowValue = other.underflowValue;
        this.overflowBehavior = other.overflowBehavior;
        this.overflowValue = other.overflowValue;
    }

    public boolean equals(RatingValuesContainer other) {
        if (other == null) {
            return false;
        }
        if (other.values == null && this.values != null) {
            return false;
        }
        if (other.values != null && this.values == null) {
            return false;
        }
        if (this.values.length != other.values.length) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == other.values[i]) continue;
            return false;
        }
        if (this.interpolateBehavior != other.interpolateBehavior) {
            return false;
        }
        if (this.underflowBehavior != other.underflowBehavior) {
            return false;
        }
        if (this.underflowValue != other.underflowValue) {
            return false;
        }
        if (this.overflowBehavior != other.overflowBehavior) {
            return false;
        }
        return this.overflowValue == other.overflowValue;
    }

    public boolean isValid() {
        int LIN_INTERP = 1;
        int LOG_INTERP = 2;
        int STEP_PREV = 3;
        int STEP_NEXT = 4;
        int STEP_NEAREST = 5;
        int NOT_ALLOWED = 11;
        int EXTRAPOLATE = 12;
        int USE_NEAREST = 13;
        int USE_VALUE = 14;
        int USE_OFFSET = 15;
        if (this.values == null || this.values.length < 1) {
            System.out.println("RatingValuesContainer is invalid : values");
            return false;
        }
        if (this.interpolateBehavior < LIN_INTERP || this.interpolateBehavior > STEP_NEAREST) {
            System.out.println("RatingValuesContainer is invalid : interpolateBehavior");
            return false;
        }
        if (this.underflowBehavior < NOT_ALLOWED || this.underflowBehavior > USE_OFFSET) {
            System.out.println("RatingValuesContainer is invalid : underflowBehavior");
            return false;
        }
        if ((this.underflowBehavior == USE_VALUE || this.underflowBehavior == USE_OFFSET) && this.underflowValue == -3.4028234663852886E38) {
            System.out.println("RatingValuesContainer is invalid : underflowValue");
            return false;
        }
        if (this.overflowBehavior < NOT_ALLOWED || this.overflowBehavior > USE_OFFSET) {
            System.out.println("RatingValuesContainer is invalid : overflowBehavior");
            return false;
        }
        if ((this.overflowBehavior == USE_VALUE || this.overflowBehavior == USE_OFFSET) && this.overflowValue == -3.4028234663852886E38) {
            System.out.println("RatingValuesContainer is invalid : overflowValue");
            return false;
        }
        return true;
    }
}

