/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.EndianInputStream;
import hec.io.EndianOutputStream;
import hec.io.FileLock;
import hec.io.HecFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import rma.util.RMAIO;

public class SimpleFile
extends File
implements HecFile {
    protected static final String TMP_EXTENSION = ".tmp";
    protected static final String BAK_EXTENSION = ".bak";
    protected static boolean _staticWriteToTmpDefault = true;
    protected boolean _writeToTmp = _staticWriteToTmpDefault;
    boolean _appendingWrite = false;

    public static void setWriteToTmpFile(boolean writeToTmp) {
        _staticWriteToTmpDefault = writeToTmp;
    }

    public SimpleFile(File parent, String child) {
        super(parent, child);
    }

    public SimpleFile(String parent, String child) {
        super(parent, child);
    }

    public SimpleFile(String pathname) {
        super(pathname);
    }

    @Override
    public boolean appendByteArray(byte[] byteArray) {
        Object tmpFileName = this._writeToTmp ? this.getPath() + TMP_EXTENSION : this.getPath();
        try {
            File tmpFile;
            if (this._writeToTmp && this._appendingWrite && !(tmpFile = new File((String)tmpFileName)).exists()) {
                this.copyFile(this, tmpFile);
            }
            RandomAccessFile raFile = new RandomAccessFile((String)tmpFileName, "rw");
            long length = raFile.length();
            raFile.seek(length);
            raFile.write(byteArray);
            raFile.close();
            return true;
        }
        catch (Exception e) {
            System.out.println(e);
            if (!this.isFile()) {
                System.out.println("********** RMA File : \"" + (String)tmpFileName + "\". Is not a File **********");
                return false;
            }
            if (!this.canWrite()) {
                System.out.println("********** RMA File : \"" + (String)tmpFileName + "\" is *READ-ONLY*. **********");
                return false;
            }
            e.printStackTrace(System.out);
            return false;
        }
    }

    protected void copyFile(File src, File dest) throws IOException {
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dest);
        in.getChannel().transferTo(0L, src.length(), out.getChannel());
        in.close();
        out.close();
    }

    @Override
    public void close() throws IOException {
        System.out.println("SimpleFile.close TODO implement me");
    }

    @Override
    public BufferedWriter getAppendedBufferedWriter() {
        BufferedWriter writer = null;
        try {
            FileWriter fw = new FileWriter((String)(this._writeToTmp ? this + TMP_EXTENSION : this.getAbsolutePath()), true);
            writer = new BufferedWriter(fw);
        }
        catch (IOException e) {
            System.out.println("getAppendedBufferedWriter:IOException occurred " + e);
        }
        return writer;
    }

    @Override
    public DataOutputStream getAppendedDataOutputStream() {
        DataOutputStream stream = null;
        try {
            FileOutputStream fos = new FileOutputStream((String)(this._writeToTmp ? this + TMP_EXTENSION : this.getAbsolutePath()), true);
            stream = new DataOutputStream(fos);
        }
        catch (FileNotFoundException e) {
            System.out.println("getAppendedDataOutputStream:FileNotFoundException occurred " + e);
            e.printStackTrace(System.out);
        }
        return stream;
    }

    @Override
    public BufferedReader getBufferedReader() {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this));
        }
        catch (FileNotFoundException e) {
            System.out.println("getBufferedReader:FileNotFoundException occurred " + e);
        }
        return reader;
    }

    @Override
    public BufferedWriter getBufferedWriter() {
        BufferedWriter writer = null;
        try {
            FileWriter fw = new FileWriter((String)(this._writeToTmp ? this + TMP_EXTENSION : this.getAbsolutePath()));
            writer = new BufferedWriter(fw);
        }
        catch (IOException e) {
            System.out.println("getBufferedWriter:IOException occurred " + e);
        }
        return writer;
    }

    @Override
    public byte[] getByteArray() {
        return this.getByteArray(false);
    }

    public synchronized byte[] getByteArray(boolean compress) {
        try {
            FileInputStream fis = new FileInputStream(this);
            long available = this.length();
            byte[] byteArray = new byte[(int)available];
            fis.read(byteArray);
            fis.close();
            return byteArray;
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("getByteArray: File Not Found: " + this.getPath());
            System.out.println(fnfe.getMessage());
        }
        catch (IOException ioe) {
            System.out.println("getByteArray: File IO Exception: " + this.getPath());
            System.out.println(ioe.getMessage());
            ioe.printStackTrace(System.out);
        }
        return new byte[0];
    }

    @Override
    public byte[] getByteArray(long off, int len) {
        try {
            FileInputStream fis = new FileInputStream(this);
            long available = this.length();
            long wants = off + (long)len;
            if (available < wants) {
                len = (int)(available - off);
            }
            byte[] byteArray = new byte[len];
            fis.skip(off);
            fis.read(byteArray);
            fis.close();
            return byteArray;
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("getByteArray:File Not Found: " + this.getPath());
            System.out.println(fnfe.getMessage());
        }
        catch (IOException ioe) {
            System.out.println("getByteArray:File IO Exception: " + this.getPath());
            System.out.println(ioe.getMessage());
            ioe.printStackTrace(System.out);
        }
        return null;
    }

    @Override
    public ByteArrayInputStream getByteArrayInputStream() {
        System.out.println("SimpleFile.getByteArrayInputStream TODO implement me");
        return null;
    }

    @Override
    public ByteArrayOutputStream getByteArrayOutputStream() {
        System.out.println("SimpleFile.getByteArrayOutputStream TODO implement me");
        return null;
    }

    @Override
    public long getCheckSum() {
        return RMAIO.getCheckSum(this);
    }

    @Override
    public DataInputStream getDataInputStream() {
        DataInputStream stream = null;
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this));
            stream = new DataInputStream(bis);
        }
        catch (FileNotFoundException e) {
            System.out.println("getDataInputStream:FileNotFoundException occurred " + e);
            e.printStackTrace(System.out);
        }
        return stream;
    }

    @Override
    public DataOutputStream getDataOutputStream() {
        DataOutputStream stream = null;
        try {
            FileOutputStream fos = new FileOutputStream((String)(this._writeToTmp ? this + TMP_EXTENSION : this.getAbsolutePath()));
            BufferedOutputStream outputStream = new BufferedOutputStream(fos);
            stream = new DataOutputStream(outputStream);
        }
        catch (FileNotFoundException e) {
            System.out.println("getDataOutputStream:FileNotFoundException occurred " + e);
            e.printStackTrace(System.out);
        }
        return stream;
    }

    @Override
    public EndianInputStream getEndianInputStream() {
        EndianInputStream stream = null;
        try {
            stream = new EndianInputStream(new BufferedInputStream(new FileInputStream(this)));
        }
        catch (FileNotFoundException e) {
            System.out.println("getEndianInputStream:FileNotFoundException occurred " + e);
        }
        return stream;
    }

    @Override
    public EndianOutputStream getEndianOutputStream() {
        EndianOutputStream stream = null;
        try {
            stream = new EndianOutputStream(new BufferedOutputStream(new FileOutputStream(this)));
        }
        catch (FileNotFoundException e) {
            System.out.println("getEndianOutputStream:FileNotFoundException occurred " + e);
        }
        return stream;
    }

    @Override
    public ObjectInputStream getObjectInputStream() {
        ObjectInputStream stream = null;
        try {
            stream = new ObjectInputStream(new FileInputStream(this));
        }
        catch (FileNotFoundException e) {
            System.out.println("getObjectInputStream:FileNotFoundException occurred " + e);
        }
        catch (IOException e) {
            System.out.println("getObjectInputStream:IOException occurred " + e);
        }
        return stream;
    }

    @Override
    public ObjectOutputStream getObjectOutputStream() throws IOException {
        ObjectOutputStream stream = new ObjectOutputStream(new FileOutputStream(this));
        return stream;
    }

    @Override
    public boolean getUsingCompression() {
        return false;
    }

    @Override
    public boolean isNetworked() {
        return false;
    }

    @Override
    public boolean lockFile(FileLock fLock) {
        return true;
    }

    @Override
    public void notify(String message) {
    }

    @Override
    public boolean save() {
        return true;
    }

    @Override
    public boolean setByteArray(byte[] byteArray) {
        Object tmpFileName;
        Object object = tmpFileName = this._writeToTmp ? this.getPath() + TMP_EXTENSION : this.getPath();
        if (this.isDirectory()) {
            System.out.println("************ RMA File : \"" + (String)tmpFileName + "\". Is a Directory ************");
            return false;
        }
        try {
            FileOutputStream fos = new FileOutputStream((String)tmpFileName);
            fos.write(byteArray);
            fos.close();
            return true;
        }
        catch (Exception e) {
            System.out.println(e);
            if (!this.isFile()) {
                System.out.println("********** RMA File : \"" + (String)tmpFileName + "\". Is not a File **********");
                return false;
            }
            if (!this.canWrite()) {
                System.out.println("********** RMA File : \"" + (String)tmpFileName + "\" is *READ-ONLY*. **********");
                return false;
            }
            e.printStackTrace(System.out);
            return false;
        }
    }

    @Override
    public void setUseCompression(boolean compress) {
    }

    @Override
    public boolean unlockFile(FileLock fLock) {
        return true;
    }

    @Override
    public void writeBytes(long bytePos, byte[] bytes) {
        String tmpFileName;
        File tmpFile;
        if (this._writeToTmp && (tmpFile = new File(tmpFileName = this.getPath() + TMP_EXTENSION)).exists()) {
            throw new IllegalStateException("Unable to write to this file because a Stream is currently writing.");
        }
        try {
            RandomAccessFile raFile = new RandomAccessFile(this, "rw");
            raFile.seek(bytePos);
            raFile.write(bytes, 0, bytes.length);
            raFile.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("writeFloat:FileNotFoundException occurred " + e);
        }
        catch (IOException e) {
            System.out.println("writeFloat:IOException occurred " + e);
        }
    }

    @Override
    public void writeFloat(long bytePos, float f) {
        String tmpFileName;
        File tmpFile;
        if (this._writeToTmp && (tmpFile = new File(tmpFileName = this.getPath() + TMP_EXTENSION)).exists()) {
            throw new IllegalStateException("Unable to write to this file because a Stream is currently writing.");
        }
        try {
            RandomAccessFile raFile = new RandomAccessFile(this, "rw");
            raFile.seek(bytePos);
            raFile.writeFloat(f);
        }
        catch (FileNotFoundException e) {
            System.out.println("writeFloat:FileNotFoundException occurred " + e);
        }
        catch (IOException e) {
            System.out.println("writeFloat:IOException occurred " + e);
        }
    }
}

