/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.EndianInputStream;
import hec.io.EndianOutputStream;
import hec.io.FileLock;
import hec.io.HecFile;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleHecFileImpl
extends File
implements HecFile {
    public SimpleHecFileImpl(String path) {
        super(path);
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public String getPath() {
        return super.getPath();
    }

    @Override
    public boolean canRead() {
        return super.canRead();
    }

    @Override
    public boolean isFile() {
        return super.isFile();
    }

    @Override
    public boolean exists() {
        return super.exists();
    }

    @Override
    public boolean canWrite() {
        return super.canWrite();
    }

    @Override
    public boolean mkdirs() {
        return super.mkdirs();
    }

    @Override
    public long length() {
        return super.length();
    }

    @Override
    public long lastModified() {
        return super.lastModified();
    }

    @Override
    public byte[] getByteArray() {
        try {
            FileInputStream fis = new FileInputStream(this);
            int available = fis.available();
            byte[] byteArray = new byte[available];
            fis.read(byteArray);
            fis.close();
            return byteArray;
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("File Not Found: " + this.getPath());
            System.out.println(fnfe.getMessage());
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            System.out.println("File IO Exception: " + this.getPath());
            System.out.println(ioe.getMessage());
            ioe.printStackTrace();
        }
        return null;
    }

    @Override
    public byte[] getByteArray(long off, int len) {
        try {
            FileInputStream fis = new FileInputStream(this);
            long available = this.length();
            long wants = off + (long)len;
            if (available < wants) {
                len = (int)(available - off);
            }
            byte[] byteArray = new byte[len];
            fis.skip(off);
            fis.read(byteArray);
            fis.close();
            return byteArray;
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("File Not Found: " + this.getPath());
            System.out.println(fnfe.getMessage());
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            System.out.println("File IO Exception: " + this.getPath());
            System.out.println(ioe.getMessage());
            ioe.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean setByteArray(byte[] byteArray) {
        try {
            FileOutputStream fos = new FileOutputStream(this);
            fos.write(byteArray);
            fos.close();
            return true;
        }
        catch (Exception e) {
            System.out.println(e);
            if (!this.isFile()) {
                System.out.println("********** SimpleHecFileImpl File : \"" + this.getPath() + "\". Is not a File **********");
                return false;
            }
            if (!this.canWrite()) {
                System.out.println("********** SimpleHecFileImpl File : \"" + this.getPath() + "\" is *READ-ONLY*. **********");
                return false;
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean appendByteArray(byte[] byteArray) {
        try {
            RandomAccessFile raFile = new RandomAccessFile(this, "rw");
            long length = raFile.length();
            raFile.seek(length);
            raFile.write(byteArray);
            raFile.close();
            return true;
        }
        catch (Exception e) {
            System.out.println(e);
            if (!this.isFile()) {
                System.out.println("********** SimpleHecFileImpl File : \"" + this.getPath() + "\". Is not a File **********");
                return false;
            }
            if (!this.canWrite()) {
                System.out.println("********** SimpleHecFileImpl File : \"" + this.getPath() + "\" is *READ-ONLY*. **********");
                return false;
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public BufferedWriter getBufferedWriter() {
        BufferedWriter bufferedWriter = null;
        try {
            FileWriter fw = new FileWriter(this){

                @Override
                public void close() throws IOException {
                    this.flush();
                    super.close();
                }
            };
            bufferedWriter = new BufferedWriter(fw);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        return bufferedWriter;
    }

    @Override
    public BufferedWriter getAppendedBufferedWriter() {
        BufferedWriter bufferedWriter = null;
        try {
            FileWriter fw = new FileWriter(this.getPath(), true){

                @Override
                public void close() throws IOException {
                    this.flush();
                    super.close();
                }
            };
            bufferedWriter = new BufferedWriter(fw);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        return bufferedWriter;
    }

    @Override
    public DataOutputStream getDataOutputStream() {
        DataOutputStream dataOutputStream = null;
        try {
            FileOutputStream fos = new FileOutputStream(this.getPath(), true);
            dataOutputStream = new DataOutputStream(fos);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        return dataOutputStream;
    }

    @Override
    public DataOutputStream getAppendedDataOutputStream() {
        DataOutputStream dataOutputStream = null;
        try {
            FileOutputStream fos = new FileOutputStream(this.getPath(), true);
            dataOutputStream = new DataOutputStream(fos);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        return dataOutputStream;
    }

    @Override
    public DataInputStream getDataInputStream() {
        DataInputStream dataInputStream = null;
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this));
            dataInputStream = new DataInputStream(bis);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        return dataInputStream;
    }

    @Override
    public ObjectOutputStream getObjectOutputStream() throws IOException {
        ObjectOutputStream objectOutputStream = null;
        try {
            FileOutputStream fos = new FileOutputStream(this);
            objectOutputStream = new ObjectOutputStream(fos);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        return objectOutputStream;
    }

    @Override
    public ObjectInputStream getObjectInputStream() {
        ObjectInputStream objectInputStream = null;
        try {
            FileInputStream fis = new FileInputStream(this);
            objectInputStream = new ObjectInputStream(fis);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        return objectInputStream;
    }

    @Override
    public synchronized ByteArrayOutputStream getByteArrayOutputStream() {
        return null;
    }

    @Override
    public synchronized ByteArrayInputStream getByteArrayInputStream() {
        return null;
    }

    @Override
    public synchronized EndianInputStream getEndianInputStream() {
        EndianInputStream dataInputStream = null;
        try {
            FileInputStream fis = new FileInputStream(this);
            dataInputStream = new EndianInputStream(fis);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        return dataInputStream;
    }

    @Override
    public synchronized EndianOutputStream getEndianOutputStream() {
        EndianOutputStream dataOutputStream = null;
        try {
            FileOutputStream fos = new FileOutputStream(this);
            dataOutputStream = new EndianOutputStream(fos);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        return dataOutputStream;
    }

    @Override
    public boolean save() {
        return true;
    }

    @Override
    public BufferedReader getBufferedReader() {
        try {
            return new BufferedReader(new FileReader(this));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(SimpleHecFileImpl.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public void notify(String message) {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public long getCheckSum() {
        long l;
        block14: {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException ex) {
                Logger.getLogger(SimpleHecFileImpl.class.getName()).log(Level.SEVERE, null, ex);
                return -1L;
            }
            InputStream is = Files.newInputStream(Paths.get(this.getAbsolutePath(), new String[0]), new OpenOption[0]);
            try {
                int length;
                byte[] tempData = new byte[1024];
                int nread = 0;
                int bytesRead = 0;
                while ((nread = is.read(tempData)) != -1) {
                    md.update(tempData, 0, nread);
                    bytesRead += nread;
                }
                byte[] digest = md.digest();
                int i = 0;
                long sum = 0L;
                long data = 0L;
                for (length = digest.length; length > 1; length -= 2) {
                    data = digest[i] << 8 & 0xFF00 | digest[i + 1] & 0xFF;
                    if (((sum += data) & 0xFFFFFFFFFFFF0000L) > 0L) {
                        sum &= 0xFFFFL;
                        ++sum;
                    }
                    i += 2;
                }
                if (length > 0 && ((sum += (long)(digest[i] << 8 & 0xFF00)) & 0xFFFFFFFFFFFF0000L) > 0L) {
                    sum &= 0xFFFFL;
                    ++sum;
                }
                sum ^= 0xFFFFFFFFFFFFFFFFL;
                l = sum &= 0xFFFFL;
                if (is == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    Logger.getLogger(SimpleHecFileImpl.class.getName()).log(Level.SEVERE, null, ex);
                    return -1L;
                }
            }
            is.close();
        }
        return l;
    }

    @Override
    public boolean isNetworked() {
        return false;
    }

    @Override
    public boolean lockFile(FileLock fLock) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean unlockFile(FileLock fLock) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setUseCompression(boolean compress) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean getUsingCompression() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeFloat(long bytePos, float f) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeBytes(long bytePos, byte[] bytes) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

