/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.RatingValuesContainer;
import hec.io.SimpleRatingContainer;
import java.io.Serializable;

public class StreamRatingContainer
extends SimpleRatingContainer
implements Cloneable,
Serializable {
    public boolean measuredIsElevation = false;
    public double datumElevation = -3.4028234663852886E38;
    public double constantOffset = -3.4028234663852886E38;
    public RatingValuesContainer variableOffsetBreakpoints = null;
    public RatingValuesContainer variableOffsetValues = null;
    public int shiftCount = 0;
    public int shiftTimeInterpolateBehavior = Integer.MIN_VALUE;
    public int shiftTimeUnderflowBehavior = Integer.MIN_VALUE;
    public int shiftTimeOverflowBehavior = Integer.MIN_VALUE;
    public long[] shiftEffectiveTimes = null;
    public long[] shiftActivatedTimes = null;
    public double[] constantShifts = null;
    public RatingValuesContainer[] variableShiftBreakpoints = null;
    public RatingValuesContainer[] variableShiftValues = null;

    @Override
    public Object clone() {
        StreamRatingContainer src = new StreamRatingContainer();
        src.copyFrom(this);
        return src;
    }

    public void copyFrom(StreamRatingContainer other) {
        int i;
        super.copyFrom(other);
        this.measuredIsElevation = other.measuredIsElevation;
        this.datumElevation = other.datumElevation;
        this.constantOffset = other.constantOffset;
        this.variableOffsetBreakpoints = other.variableOffsetBreakpoints == null ? null : (RatingValuesContainer)other.variableOffsetBreakpoints.clone();
        this.variableOffsetValues = other.variableOffsetValues == null ? null : (RatingValuesContainer)other.variableOffsetValues.clone();
        this.shiftCount = other.shiftCount;
        this.shiftTimeInterpolateBehavior = other.shiftTimeInterpolateBehavior;
        this.shiftTimeUnderflowBehavior = other.shiftTimeUnderflowBehavior;
        this.shiftTimeOverflowBehavior = other.shiftTimeOverflowBehavior;
        this.shiftEffectiveTimes = (long[])(other.shiftEffectiveTimes == null ? null : (long[])other.shiftEffectiveTimes.clone());
        this.shiftActivatedTimes = (long[])(other.shiftActivatedTimes == null ? null : (long[])other.shiftActivatedTimes.clone());
        this.constantShifts = (double[])(other.constantShifts == null ? null : (double[])other.constantShifts.clone());
        if (other.variableShiftBreakpoints == null) {
            this.variableShiftBreakpoints = null;
        } else {
            this.variableShiftBreakpoints = new RatingValuesContainer[other.variableShiftBreakpoints.length];
            for (i = 0; i < other.variableShiftBreakpoints.length; ++i) {
                this.variableShiftBreakpoints[i] = other.variableShiftBreakpoints[i] == null ? null : (RatingValuesContainer)other.variableShiftBreakpoints[i].clone();
            }
        }
        if (other.variableShiftValues == null) {
            this.variableShiftValues = null;
        } else {
            this.variableShiftValues = new RatingValuesContainer[other.variableShiftValues.length];
            for (i = 0; i < other.variableShiftValues.length; ++i) {
                this.variableShiftValues[i] = other.variableShiftValues[i] == null ? null : (RatingValuesContainer)other.variableShiftValues[i].clone();
            }
        }
    }

    public boolean equals(StreamRatingContainer other) {
        int i;
        if (other == null) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (this.measuredIsElevation != other.measuredIsElevation) {
            return false;
        }
        if (this.datumElevation != other.datumElevation) {
            return false;
        }
        if (this.constantOffset != other.constantOffset) {
            return false;
        }
        if (other.variableOffsetBreakpoints == null ? this.variableOffsetBreakpoints != null : !this.variableOffsetBreakpoints.equals(other.variableOffsetBreakpoints)) {
            return false;
        }
        if (other.variableOffsetValues == null ? this.variableOffsetValues != null : !this.variableOffsetValues.equals(other.variableOffsetValues)) {
            return false;
        }
        if (this.shiftCount != other.shiftCount) {
            return false;
        }
        if (this.shiftTimeInterpolateBehavior != other.shiftTimeInterpolateBehavior) {
            return false;
        }
        if (this.shiftTimeUnderflowBehavior != other.shiftTimeUnderflowBehavior) {
            return false;
        }
        if (this.shiftTimeOverflowBehavior != other.shiftTimeOverflowBehavior) {
            return false;
        }
        if (other.shiftEffectiveTimes == null) {
            if (this.shiftEffectiveTimes != null) {
                return false;
            }
        } else {
            if (this.shiftEffectiveTimes == null) {
                return false;
            }
            if (this.shiftEffectiveTimes.length != other.shiftEffectiveTimes.length) {
                return false;
            }
            for (i = 0; i < this.shiftEffectiveTimes.length; ++i) {
                if (this.shiftEffectiveTimes[i] == other.shiftEffectiveTimes[i]) continue;
                return false;
            }
        }
        if (other.shiftActivatedTimes == null) {
            if (this.shiftActivatedTimes != null) {
                return false;
            }
        } else {
            if (this.shiftActivatedTimes == null) {
                return false;
            }
            if (this.shiftActivatedTimes.length != other.shiftActivatedTimes.length) {
                return false;
            }
            for (i = 0; i < this.shiftActivatedTimes.length; ++i) {
                if (this.shiftActivatedTimes[i] == other.shiftActivatedTimes[i]) continue;
                return false;
            }
        }
        if (other.constantShifts == null) {
            if (this.constantShifts != null) {
                return false;
            }
        } else {
            if (this.constantShifts == null) {
                return false;
            }
            if (this.constantShifts.length != other.constantShifts.length) {
                return false;
            }
            for (i = 0; i < this.constantShifts.length; ++i) {
                if (this.constantShifts[i] == other.constantShifts[i]) continue;
                return false;
            }
        }
        if (other.variableShiftBreakpoints == null) {
            if (this.variableShiftBreakpoints != null) {
                return false;
            }
        } else {
            if (this.variableShiftBreakpoints == null) {
                return false;
            }
            if (this.variableShiftBreakpoints.length != other.variableShiftBreakpoints.length) {
                return false;
            }
            for (i = 0; i < this.variableShiftBreakpoints.length; ++i) {
                if (this.variableShiftBreakpoints[i] == null) {
                    if (other.variableShiftBreakpoints[i] == null) continue;
                    return false;
                }
                if (other.variableShiftBreakpoints[i] == null) {
                    return false;
                }
                if (this.variableShiftBreakpoints[i].equals(other.variableShiftBreakpoints[i])) continue;
                return false;
            }
        }
        if (other.variableShiftValues == null) {
            if (this.variableShiftValues != null) {
                return false;
            }
        } else {
            if (this.variableShiftValues == null) {
                return false;
            }
            if (this.variableShiftValues.length != other.variableShiftValues.length) {
                return false;
            }
            for (i = 0; i < this.variableShiftValues.length; ++i) {
                if (this.variableShiftValues[i] == null) {
                    if (other.variableShiftValues[i] == null) continue;
                    return false;
                }
                if (other.variableShiftValues[i] == null) {
                    return false;
                }
                if (this.variableShiftValues[i].equals(other.variableShiftValues[i])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isValid() {
        if (this.constantOffset == -3.4028234663852886E38) {
            if (this.variableOffsetBreakpoints == null) {
                if (this.variableOffsetValues != null) {
                    System.out.println("StreamRatingContainer is invalid : inconsistent definition on variable offsets");
                    return false;
                }
            } else {
                if (!this.variableOffsetBreakpoints.isValid()) {
                    System.out.println("StreamRatingContainer is invalid : variableOffsetBreakpoints");
                    return false;
                }
                if (this.variableOffsetValues == null) {
                    System.out.println("StreamRatingContainer is invalid : variableOffsetValues is null");
                    return false;
                }
                if (!this.variableOffsetValues.isValid()) {
                    System.out.println("StreamRatingContainer is invalid : variableOffsetValues");
                    return false;
                }
                if (this.variableOffsetBreakpoints.values.length != this.variableOffsetValues.values.length) {
                    System.out.println("StreamRatingContainer is invalid : inconsistent length on variable offsets");
                    return false;
                }
            }
        } else {
            if (this.variableOffsetBreakpoints != null) {
                System.out.println("StreamRatingContainer is invalid : constant and variable offsets are both defined");
                return false;
            }
            if (this.variableOffsetValues != null) {
                System.out.println("StreamRatingContainer is invalid : constant and variable offsets are both defined");
                return false;
            }
        }
        if (this.shiftCount == 0) {
            if (this.shiftEffectiveTimes != null) {
                System.out.println("StreamRatingContainer is invalid : shiftEffectiveTimes is defined when shiftCount is zero");
                return false;
            }
            if (this.shiftActivatedTimes != null) {
                System.out.println("StreamRatingContainer is invalid : shiftActivatedTimes is defined when shiftCount is zero");
                return false;
            }
            if (this.constantShifts != null) {
                System.out.println("StreamRatingContainer is invalid : constantShifts is defined when shiftCount is zero");
                return false;
            }
            if (this.variableShiftBreakpoints != null) {
                System.out.println("StreamRatingContainer is invalid : variableShiftBreakpoints is defined when shiftCount is zero");
                return false;
            }
            if (this.variableShiftValues != null) {
                System.out.println("StreamRatingContainer is invalid : variableShiftValues is defined when shiftCount is zero");
                return false;
            }
        } else {
            int LIN_INTERP = 1;
            int LOG_INTERP = 2;
            int STEP_PREV = 3;
            int STEP_NEXT = 4;
            int STEP_NEAREST = 5;
            int NOT_ALLOWED = 11;
            int EXTRAPOLATE = 12;
            int USE_NEAREST = 13;
            int USE_VALUE = 14;
            int USE_OFFSET = 15;
            int USE_NONE = 16;
            int LIN_INTERP_TO_NONE = 17;
            if (this.shiftTimeInterpolateBehavior < LIN_INTERP || this.shiftTimeInterpolateBehavior > STEP_NEAREST) {
                System.out.println("StreamRatingContainer is invalid : shiftTimeInterpolateBehavior");
                return false;
            }
            if (this.shiftTimeUnderflowBehavior < NOT_ALLOWED || this.shiftTimeUnderflowBehavior > LIN_INTERP_TO_NONE) {
                System.out.println("StreamRatingContainer is invalid : shiftTimeUnderflowBehavior");
                return false;
            }
            if (this.shiftTimeOverflowBehavior < NOT_ALLOWED || this.shiftTimeOverflowBehavior > LIN_INTERP_TO_NONE) {
                System.out.println("StreamRatingContainer is invalid : shiftTimeOverflowBehavior");
                return false;
            }
            if (this.shiftEffectiveTimes == null || this.shiftEffectiveTimes.length != this.shiftCount) {
                System.out.println("StreamRatingContainer is invalid : shiftEffectiveTimes is null or length not != shiftCount");
                return false;
            }
            if (this.shiftActivatedTimes == null || this.shiftActivatedTimes.length != this.shiftCount) {
                System.out.println("StreamRatingContainer is invalid : shiftActivatedTimes is null or length not != shiftCount");
                return false;
            }
            if (this.constantShifts == null || this.constantShifts.length != this.shiftCount) {
                System.out.println("StreamRatingContainer is invalid : constantShifts is null or length not != shiftCount");
                return false;
            }
            if (this.variableShiftBreakpoints == null || this.variableShiftBreakpoints.length != this.shiftCount) {
                System.out.println("StreamRatingContainer is invalid : variableShiftBreakpoints is null or length not != shiftCount");
                return false;
            }
            if (this.variableShiftValues == null || this.variableShiftValues.length != this.shiftCount) {
                System.out.println("StreamRatingContainer is invalid : variableShiftValues is null or length not != shiftCount");
                return false;
            }
            for (int i = 0; i < this.shiftCount; ++i) {
                if (this.shiftEffectiveTimes[i] == Long.MIN_VALUE) {
                    System.out.println("StreamRatingContainer is invalid : shiftEffectiveTimes[" + i + "] is undefined");
                    return false;
                }
                if (this.constantShifts[i] == -3.4028234663852886E38) {
                    if (this.variableShiftBreakpoints[i] == null || !this.variableShiftBreakpoints[i].isValid()) {
                        System.out.println("StreamRatingContainer is invalid : variableShiftBreakpoints[" + i + "]");
                        return false;
                    }
                    if (this.variableShiftValues[i] == null || !this.variableShiftValues[i].isValid()) {
                        System.out.println("StreamRatingContainer is invalid : variableShiftValues[" + i + "]");
                        return false;
                    }
                    if (this.variableShiftBreakpoints[i].values.length == this.variableShiftValues[i].values.length) continue;
                    System.out.println("StreamRatingContainer is invalid : inconsistent lenght on variable shift [" + i + "]");
                    return false;
                }
                if (this.variableShiftBreakpoints[i] != null) {
                    System.out.println("StreamRatingContainer is invalid : variableShiftBreakpoints[" + i + "] is null when constantShift[" + i + "] is undefined");
                    return false;
                }
                if (this.variableShiftValues[i] == null) continue;
                System.out.println("StreamRatingContainer is invalid : variableShiftValues[" + i + "] is null when constantShift[" + i + "] is undefined");
                return false;
            }
        }
        return true;
    }
}

