/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.Conversion;
import hec.io.DataContainer;
import hec.io.StreamRatingContainer;
import java.io.Serializable;

public class StreamRatingSeriesContainer
extends DataContainer
implements Cloneable,
Serializable {
    public String subLocation = "";
    public String measuredParameter = "";
    public String measuredSubParameter = "";
    public String measuredUnits = "";
    public String ratedParameter = "";
    public String ratedSubParameter = "";
    public String ratedUnits = "";
    public long startTime = Long.MIN_VALUE;
    public long endTime = Long.MIN_VALUE;
    public long[] availableTimes = null;
    public int ratingCount;
    public int interpolateBehavior = 0;
    public int underflowBehavior = 0;
    public int overflowBehavior = 0;
    public StreamRatingContainer[] ratings = null;

    public Object clone() {
        StreamRatingSeriesContainer srsc = new StreamRatingSeriesContainer();
        srsc.copyFrom(this);
        return srsc;
    }

    public void copyFrom(StreamRatingSeriesContainer other) {
        this.fileName = other.fileName;
        this.supplementalInfo = other.supplementalInfo;
        this.modified = other.modified;
        this.fullName = other.fullName;
        this.watershed = other.watershed;
        this.location = other.location;
        this.subLocation = other.subLocation;
        this.version = other.version;
        this.subVersion = other.subVersion;
        this.measuredParameter = other.measuredParameter;
        this.measuredSubParameter = other.measuredSubParameter;
        this.measuredUnits = other.measuredUnits;
        this.ratedParameter = other.ratedParameter;
        this.ratedSubParameter = other.ratedSubParameter;
        this.ratedUnits = other.ratedUnits;
        this.startTime = other.startTime;
        this.endTime = other.endTime;
        this.availableTimes = other.availableTimes == null ? null : (long[])other.availableTimes.clone();
        this.ratingCount = other.ratingCount;
        this.interpolateBehavior = other.interpolateBehavior;
        this.underflowBehavior = other.underflowBehavior;
        this.overflowBehavior = other.overflowBehavior;
        if (other.ratings == null) {
            this.ratings = null;
        } else {
            this.ratings = new StreamRatingContainer[other.ratings.length];
            for (int i = 0; i < other.ratings.length; ++i) {
                this.ratings[i] = (StreamRatingContainer)other.ratings[i].clone();
            }
        }
    }

    public boolean equals(StreamRatingSeriesContainer other) {
        int i;
        if (other == null) {
            return false;
        }
        if (!Conversion.equivalentStrings(this.fileName, other.fileName)) {
            return false;
        }
        if (!Conversion.equivalentStrings(this.supplementalInfo, other.supplementalInfo)) {
            return false;
        }
        if (this.modified != other.modified) {
            return false;
        }
        if (!Conversion.equivalentStrings(this.fullName, other.fullName)) {
            return false;
        }
        if (!Conversion.equivalentStrings(this.watershed, other.watershed)) {
            return false;
        }
        if (!Conversion.equivalentStrings(this.location, other.location)) {
            return false;
        }
        if (!Conversion.equivalentStrings(this.subLocation, other.subLocation)) {
            return false;
        }
        if (!Conversion.equivalentStrings(this.version, other.version)) {
            return false;
        }
        if (!Conversion.equivalentStrings(this.subVersion, other.subVersion)) {
            return false;
        }
        if (!Conversion.equivalentStrings(this.measuredParameter, other.measuredParameter)) {
            return false;
        }
        if (!Conversion.equivalentStrings(this.measuredSubParameter, other.measuredSubParameter)) {
            return false;
        }
        if (!Conversion.equivalentStrings(this.measuredUnits, other.measuredUnits)) {
            return false;
        }
        if (!Conversion.equivalentStrings(this.ratedParameter, other.ratedParameter)) {
            return false;
        }
        if (!Conversion.equivalentStrings(this.ratedSubParameter, other.ratedSubParameter)) {
            return false;
        }
        if (!Conversion.equivalentStrings(this.ratedUnits, other.ratedUnits)) {
            return false;
        }
        if (this.startTime != other.startTime) {
            return false;
        }
        if (this.endTime != other.endTime) {
            return false;
        }
        if (this.availableTimes == null) {
            if (other.availableTimes != null) {
                return false;
            }
        } else {
            if (other.availableTimes.length != this.availableTimes.length) {
                return false;
            }
            for (i = 0; i < this.availableTimes.length; ++i) {
                if (other.availableTimes[i] == this.availableTimes[i]) continue;
                return false;
            }
        }
        if (this.ratingCount != other.ratingCount) {
            return false;
        }
        if (this.interpolateBehavior != other.interpolateBehavior) {
            return false;
        }
        if (this.underflowBehavior != other.underflowBehavior) {
            return false;
        }
        if (this.overflowBehavior != other.overflowBehavior) {
            return false;
        }
        if (other.ratings == null) {
            if (this.ratings != null) {
                return false;
            }
        } else {
            if (other.ratings.length != this.ratings.length) {
                return false;
            }
            for (i = 0; i < this.ratings.length; ++i) {
                if (other.ratings[i].equals(this.ratings[i])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isValid() {
        if (this.fullName == null || this.fullName.length() < 1) {
            System.out.println("StreamRatingSeriesContainer is invalid : fullName");
            return false;
        }
        if (this.measuredParameter == null || this.measuredParameter.length() < 1) {
            System.out.println("StreamRatingSeriesContainer is invalid : measuredParameter");
            return false;
        }
        if (this.measuredUnits == null || this.measuredUnits.length() < 1) {
            System.out.println("StreamRatingSeriesContainer is invalid : measuredUnits");
            return false;
        }
        if (this.ratedParameter == null || this.ratedParameter.length() < 1) {
            System.out.println("StreamRatingSeriesContainer is invalid : ratedParameter");
            return false;
        }
        if (this.ratedUnits == null || this.ratedUnits.length() < 1) {
            System.out.println("StreamRatingSeriesContainer is invalid : ratedUnits");
            return false;
        }
        if (this.ratingCount == 0) {
            if (this.ratings != null) {
                System.out.println("StreamRatingSeriesContainer is invalid : ratings");
                return false;
            }
        } else {
            int LIN_INTERP = 1;
            int LOG_INTERP = 2;
            int STEP_PREV = 3;
            int STEP_NEXT = 4;
            int STEP_NEAREST = 5;
            int NOT_ALLOWED = 11;
            int EXTRAPOLATE = 12;
            int USE_NEAREST = 13;
            int USE_VALUE = 14;
            int USE_OFFSET = 15;
            String[] baseParts = this.fullName.replaceAll("/", "/ ").trim().split("/");
            String[] ratingParts = null;
            if (this.interpolateBehavior < LIN_INTERP || this.interpolateBehavior > STEP_NEAREST) {
                System.out.println("StreamRatingSeriesContainer is invalid : interpolateBehavior");
                return false;
            }
            if (this.underflowBehavior < NOT_ALLOWED || this.underflowBehavior > USE_OFFSET) {
                System.out.println("StreamRatingSeriesContainer is invalid : underflowBehavior");
                return false;
            }
            if (this.overflowBehavior < NOT_ALLOWED || this.overflowBehavior > USE_OFFSET) {
                System.out.println("StreamRatingSeriesContainer is invalid : overflowBehavior");
                return false;
            }
            for (int i = 0; i < this.ratingCount; ++i) {
                if (!this.ratings[i].isValid()) {
                    System.out.println("StreamRatingSeriesContainer is invalid : ratings[" + i + "]");
                    return false;
                }
                if (baseParts.length == 7) {
                    ratingParts = this.ratings[i].fullName.replaceAll("/", "/ ").trim().split("/");
                    if (ratingParts.length != 7) {
                        System.out.println("StreamRatingSeriesContainer is invalid : ratings[" + i + "].fullName");
                        return false;
                    }
                    for (int j = 0; j < 7; ++j) {
                        if (j == 4 || Conversion.equivalentStrings(baseParts[j].trim(), ratingParts[j].trim())) continue;
                        System.out.println("StreamRatingSeriesContainer is invalid : ratings[" + i + "].fullName");
                        return false;
                    }
                } else if (!Conversion.equivalentStrings(this.fullName, this.ratings[i].fullName)) {
                    System.out.println("StreamRatingSeriesContainer is invalid : ratings[" + i + "].fullName");
                    return false;
                }
                if (!Conversion.equivalentStrings(this.watershed, this.ratings[i].watershed)) {
                    System.out.println("StreamRatingSeriesContainer is invalid : ratings[" + i + "].watershed");
                    return false;
                }
                if (!Conversion.equivalentStrings(this.location, this.ratings[i].location)) {
                    System.out.println("StreamRatingSeriesContainer is invalid : ratings[" + i + "].location");
                    return false;
                }
                if (!Conversion.equivalentStrings(this.subLocation, this.ratings[i].subLocation)) {
                    System.out.println("StreamRatingSeriesContainer is invalid : ratings[" + i + "].subLocation");
                    return false;
                }
                if (!Conversion.equivalentStrings(this.version, this.ratings[i].version)) {
                    System.out.println("StreamRatingSeriesContainer is invalid : ratings[" + i + "].version");
                    return false;
                }
                if (!Conversion.equivalentStrings(this.subVersion, this.ratings[i].subVersion)) {
                    System.out.println("StreamRatingSeriesContainer is invalid : ratings[" + i + "].subVersion");
                    return false;
                }
                if (!Conversion.equivalentStrings(this.measuredParameter, this.ratings[i].measuredParameter)) {
                    System.out.println("StreamRatingSeriesContainer is invalid : ratings[" + i + "].measuredParameter");
                    return false;
                }
                if (!Conversion.equivalentStrings(this.measuredSubParameter, this.ratings[i].measuredSubParameter)) {
                    System.out.println("StreamRatingSeriesContainer is invalid : ratings[" + i + "].measuredSubParameter");
                    return false;
                }
                if (!Conversion.equivalentStrings(this.measuredUnits, this.ratings[i].measuredUnits)) {
                    System.out.println("StreamRatingSeriesContainer is invalid : ratings[" + i + "].measuredUnits");
                    return false;
                }
                if (!Conversion.equivalentStrings(this.ratedParameter, this.ratings[i].ratedParameter)) {
                    System.out.println("StreamRatingSeriesContainer is invalid : ratings[" + i + "].ratedParameter");
                    return false;
                }
                if (!Conversion.equivalentStrings(this.ratedSubParameter, this.ratings[i].ratedSubParameter)) {
                    System.out.println("StreamRatingSeriesContainer is invalid : ratings[" + i + "].ratedSubParameter");
                    return false;
                }
                if (Conversion.equivalentStrings(this.ratedUnits, this.ratings[i].ratedUnits)) continue;
                System.out.println("StreamRatingSeriesContainer is invalid : ratings[" + i + "].ratedUnits");
                return false;
            }
        }
        return true;
    }
}

