/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.AsciiSerializable;
import hec.io.HecFile;
import hec.io.Identifier;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;

public final class TextFileReference
implements AsciiSerializable {
    private String _filename = null;
    private String _value = null;
    private transient FilenameProvider _fp = null;

    public TextFileReference() {
    }

    public TextFileReference(FilenameProvider provider) {
        this._fp = provider;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public String getFilename() {
        if (this._filename == null && this._fp != null) {
            this._fp.provide();
        }
        return this._filename;
    }

    public void setFilename(String filename) {
        this._filename = filename;
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static String getValue(TextFileReference ref, String defaultVal) {
        String retval = null;
        if (ref != null) {
            retval = ref.getValue();
        }
        if (retval == null) {
            retval = defaultVal;
        }
        return retval;
    }

    public static String setValue(TextFileReference ref, String script) {
        String retval;
        if (ref != null) {
            ref.setValue(script);
            retval = null;
        } else {
            retval = script;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeValue(Identifier remoteId) throws IOException {
        boolean worked = false;
        if (remoteId != null) {
            try (HecFile hecFile = null;){
                hecFile = remoteId.getFile();
                String stringContents = this.getValue();
                try (BufferedWriter bufferedWriter = hecFile.getBufferedWriter();){
                    if (stringContents != null && !stringContents.isEmpty()) {
                        bufferedWriter.write(stringContents);
                    }
                }
                worked = true;
            }
        }
        return worked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readValue(Identifier remoteId) throws IOException {
        boolean worked = false;
        if (remoteId != null) {
            try (HecFile hecFile = null;){
                hecFile = remoteId.getFile();
                StringBuilder buf = new StringBuilder();
                try (BufferedReader br = hecFile.getBufferedReader();){
                    String line;
                    while ((line = br.readLine()) != null) {
                        buf.append(line);
                        buf.append("\n");
                    }
                }
                this.setValue(buf.toString());
                worked = true;
            }
        }
        return worked;
    }

    public static interface FilenameProvider {
        public void provide();
    }
}

