/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.heclib.dss.DSSPathname;
import hec.io.DataContainer;
import hec.io.TimeSeriesContainer;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;

public class TimeSeriesCollectionContainer
extends DataContainer
implements Cloneable,
Serializable {
    protected TimeSeriesContainer[] timeSeriesContainers = null;
    protected String[] sequences = null;
    protected int[] times = null;
    protected boolean _dirtyTimes = true;
    protected boolean _dirtySequences = true;

    public Object clone() {
        TimeSeriesCollectionContainer container = new TimeSeriesCollectionContainer();
        this.clone(container);
        return container;
    }

    public void clone(TimeSeriesCollectionContainer collection) {
        super.clone(collection);
        int number = this.timeSeriesContainers.length;
        collection.timeSeriesContainers = new TimeSeriesContainer[number];
        for (int i = 0; i < number; ++i) {
            TimeSeriesContainer tsc = this.timeSeriesContainers[i];
            collection.timeSeriesContainers[i] = (TimeSeriesContainer)tsc.clone();
        }
        collection.sequences = this.sequences != null ? Arrays.copyOf(this.sequences, this.sequences.length) : null;
        if (this.times != null) {
            collection.times = Arrays.copyOf(this.times, this.times.length);
        } else {
            this.times = null;
        }
        collection.setDirty();
    }

    public void add(TimeSeriesContainer tsc) {
        if (this.timeSeriesContainers == null) {
            this.timeSeriesContainers = new TimeSeriesContainer[1];
            this.timeSeriesContainers[0] = tsc;
            tsc.clone(this);
        } else {
            this.timeSeriesContainers = Arrays.copyOf(this.timeSeriesContainers, this.timeSeriesContainers.length + 1);
            this.timeSeriesContainers[this.timeSeriesContainers.length - 1] = tsc;
        }
        this._dirtyTimes = true;
        this._dirtySequences = true;
    }

    public void finishedAdding() {
        if (this.timeSeriesContainers == null) {
            return;
        }
        if (this.timeSeriesContainers.length == 0) {
            return;
        }
        if (this.fullName == null || this.fullName.length() == 0) {
            this.timeSeriesContainers[0].clone(this);
        }
        this.setDirty();
        this.removeNonSequencedContainers();
    }

    public void set(TimeSeriesContainer[] containers) {
        this.timeSeriesContainers = containers;
        this.finishedAdding();
    }

    public boolean set(TimeSeriesContainer[] containers, int startingSequenceNumber) {
        if (containers == null) {
            return false;
        }
        TimeSeriesContainer[] tscontainers = new TimeSeriesContainer[containers.length];
        for (int i = 0; i < containers.length; ++i) {
            TimeSeriesContainer tsc = (TimeSeriesContainer)containers[i].clone();
            DSSPathname path = new DSSPathname(tsc.fullName);
            path.setCollectionSequence(startingSequenceNumber++);
            tsc.fullName = path.getPathname();
            tscontainers[i] = tsc;
        }
        this.set(tscontainers);
        return true;
    }

    public boolean set(TimeSeriesContainer[] containers, String[] sequences) {
        if (containers == null) {
            return false;
        }
        if (sequences == null) {
            return false;
        }
        if (containers.length != sequences.length) {
            return false;
        }
        TimeSeriesContainer[] tscontainers = new TimeSeriesContainer[containers.length];
        for (int i = 0; i < containers.length; ++i) {
            TimeSeriesContainer tsc = (TimeSeriesContainer)containers[i].clone();
            DSSPathname path = new DSSPathname(tsc.fullName);
            path.setCollectionSequence(sequences[i]);
            tsc.fullName = path.getPathname();
            tscontainers[i] = tsc;
        }
        this.set(tscontainers);
        return true;
    }

    public TimeSeriesContainer[] get() {
        return this.timeSeriesContainers;
    }

    public int size() {
        if (this.timeSeriesContainers == null) {
            return 0;
        }
        return this.timeSeriesContainers.length;
    }

    public TimeSeriesContainer get(int index) {
        if (this.timeSeriesContainers == null) {
            return null;
        }
        if (index >= this.timeSeriesContainers.length) {
            return null;
        }
        return this.timeSeriesContainers[index];
    }

    public TimeSeriesContainer get(String sequence) {
        if (this.timeSeriesContainers == null) {
            return null;
        }
        String[] seq = this.getSequences();
        for (int i = 0; i < seq.length; ++i) {
            if (!sequence.equals(seq[i])) continue;
            return this.timeSeriesContainers[i];
        }
        return null;
    }

    public int[] getTimes() {
        if (this.timeSeriesContainers == null) {
            return null;
        }
        if (this.timeSeriesContainers.length == 0) {
            return null;
        }
        if (!this._dirtyTimes) {
            return this.times;
        }
        boolean allSame = true;
        TimeSeriesContainer tsc0 = this.timeSeriesContainers[0];
        if (tsc0.times == null) {
            return null;
        }
        if (this.timeSeriesContainers.length > 1) {
            for (int i = 1; i < this.timeSeriesContainers.length; ++i) {
                TimeSeriesContainer tsc = this.timeSeriesContainers[i];
                if (tsc.times == null) break;
                if (tsc0.times.length != tsc.times.length) {
                    allSame = false;
                    break;
                }
                for (int j = 0; j < tsc.times.length; ++j) {
                    if (tsc0.times[j] == tsc.times[j]) continue;
                    allSame = false;
                    break;
                }
                if (!allSame) break;
            }
        }
        if (allSame) {
            this.times = Arrays.copyOf(tsc0.times, tsc0.times.length);
        } else {
            int i;
            int count = 0;
            for (i = 0; i < this.timeSeriesContainers.length; ++i) {
                TimeSeriesContainer tsc = this.timeSeriesContainers[i];
                if (tsc.times == null) continue;
                count += tsc.times.length;
            }
            this.times = new int[count];
            for (i = 0; i < tsc0.times.length; ++i) {
                this.times[i] = tsc0.times[i];
            }
            count = tsc0.times.length;
            for (i = 1; i < this.timeSeriesContainers.length; ++i) {
                TimeSeriesContainer tsc = this.timeSeriesContainers[i];
                if (tsc.times == null) continue;
                for (int j = 0; j < tsc.times.length; ++j) {
                    int itime = tsc.times[j];
                    if (this.contains(this.times, count, itime)) continue;
                    this.times[count++] = itime;
                }
            }
            this.times = Arrays.copyOf(this.times, count);
            Arrays.sort(this.times);
        }
        this._dirtyTimes = false;
        return this.times;
    }

    protected boolean contains(int[] array, int arrayCount, int value) {
        for (int i = 0; i < arrayCount; ++i) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    public String[] getSequences() {
        if (this.timeSeriesContainers == null) {
            return null;
        }
        if (this.timeSeriesContainers.length == 0) {
            return null;
        }
        if (!this._dirtySequences) {
            return this.sequences;
        }
        this.sequences = new String[this.timeSeriesContainers.length];
        boolean error = false;
        for (int i = 0; i < this.timeSeriesContainers.length; ++i) {
            TimeSeriesContainer tsc = this.timeSeriesContainers[i];
            String seq = DSSPathname.getCollectionSequence(tsc.fullName);
            if (seq == null) {
                error = true;
                break;
            }
            this.sequences[i] = seq;
        }
        if (error) {
            this.removeNonSequencedContainers();
            return this.sequences;
        }
        this._dirtySequences = false;
        return this.sequences;
    }

    public String[] getPathnameList() {
        if (this.timeSeriesContainers == null) {
            return null;
        }
        if (this.timeSeriesContainers.length == 0) {
            return null;
        }
        String[] pathnames = new String[this.timeSeriesContainers.length];
        for (int i = 0; i < this.timeSeriesContainers.length; ++i) {
            TimeSeriesContainer tsc = this.timeSeriesContainers[i];
            pathnames[i] = tsc.fullName;
        }
        return pathnames;
    }

    public int numberOfSequences() {
        if (this.timeSeriesContainers == null) {
            return 0;
        }
        return this.timeSeriesContainers.length;
    }

    public void setDirty() {
        this._dirtyTimes = true;
        this._dirtySequences = true;
    }

    public boolean remove(TimeSeriesContainer tsc) {
        if (this.timeSeriesContainers == null) {
            return false;
        }
        if (tsc == null) {
            return false;
        }
        int pos = -1;
        for (int i = 0; i < this.timeSeriesContainers.length; ++i) {
            if (this.timeSeriesContainers[i] != tsc) continue;
            pos = i;
            break;
        }
        if (pos == -1) {
            return false;
        }
        if (this.timeSeriesContainers.length == 1) {
            this.timeSeriesContainers = null;
        } else {
            TimeSeriesContainer[] containers = new TimeSeriesContainer[this.timeSeriesContainers.length - 1];
            int count = 0;
            for (int i = 0; i < this.timeSeriesContainers.length; ++i) {
                if (i == pos) continue;
                containers[count++] = this.timeSeriesContainers[i];
            }
            this.timeSeriesContainers = containers;
        }
        this.finishedAdding();
        return true;
    }

    public boolean remove(int index) {
        if (this.timeSeriesContainers == null) {
            return false;
        }
        if (index >= this.timeSeriesContainers.length) {
            return false;
        }
        if (index < 0) {
            return false;
        }
        if (this.timeSeriesContainers.length <= 1 && index == 0) {
            this.timeSeriesContainers = null;
        } else {
            TimeSeriesContainer[] containers = new TimeSeriesContainer[this.timeSeriesContainers.length - 1];
            int count = 0;
            for (int i = 0; i < this.timeSeriesContainers.length; ++i) {
                if (i == index) continue;
                containers[count++] = this.timeSeriesContainers[i];
            }
            this.timeSeriesContainers = containers;
        }
        this.finishedAdding();
        return true;
    }

    @Deprecated
    public boolean checkContainers() {
        return this.removeNonSequencedContainers();
    }

    private boolean removeNonSequencedContainers() {
        boolean success = false;
        Vector<TimeSeriesContainer> notColl = new Vector<TimeSeriesContainer>();
        for (int i = 0; i < this.timeSeriesContainers.length; ++i) {
            TimeSeriesContainer tsc = this.timeSeriesContainers[i];
            String seq = DSSPathname.getCollectionSequence(tsc.fullName);
            if (seq != null) continue;
            notColl.add(tsc);
        }
        if (notColl.size() == 0) {
            success = true;
        } else {
            int newlen = this.timeSeriesContainers.length - notColl.size();
            if (newlen <= 0) {
                this.timeSeriesContainers = null;
                this.times = null;
                this.sequences = null;
                this.setDirty();
                return false;
            }
            for (int i = 0; i < notColl.size(); ++i) {
                TimeSeriesContainer tsc = (TimeSeriesContainer)notColl.get(i);
                this.remove(tsc);
            }
        }
        this._dirtyTimes = true;
        this._dirtySequences = true;
        this.getSequences();
        return success;
    }
}

