/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.data.IVerticalDatumOperations;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.io.DataContainer;
import hec.io.TimeSeriesContainerVertDatum;
import hec.io.TsDataSetStats;
import hec.lang.annotation.Scriptable;
import java.io.IOException;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Optional;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.data.timeseries.VersionDate;
import mil.army.usace.hec.data.timeseries.VersionDateFactory;
import mil.army.usace.hec.data.timeseries.VersionDateFormatter;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.VerticalDatumException;

public class TimeSeriesContainer
extends DataContainer
implements Cloneable,
Serializable,
IVerticalDatumOperations<TimeSeriesContainer, VerticalDatumException> {
    private static final Logger LOGGER = Logger.getLogger(TimeSeriesContainer.class.getName());
    private static final long serialVersionUID = -7951440163892076050L;
    public double[] values = null;
    public int[] times = null;
    public int[] quality = null;
    public int numberValues = 0;
    @Deprecated
    public int interval = 0;
    @Deprecated
    public int startTime = 0;
    @Deprecated
    public int endTime = 0;
    public HecTime startHecTime = new HecTime();
    public HecTime endHecTime = new HecTime();
    public String units = "";
    public String type = "";
    public int precision = -1;
    public String subLocation = "";
    public String parameter = "";
    public String subParameter = "";
    public String timeZoneID = null;
    public int timeZoneRawOffset = 0;
    private boolean _compressData = false;
    public int julianBaseDate = 0;
    public int timeGranularitySeconds = 60;
    public boolean retrieveAllTimes = false;
    public int[][] quality7 = null;
    public int sizeEachQuality7 = 0;
    public int[][] inotes;
    public int sizeEachNote;
    public String[] cnotes = null;
    public int numberDepths = 0;
    public double[] profileDepths = null;
    public double[][] profileValues = null;
    public String unitsProfileDepths = "";
    public String unitsProfileValues = "";
    public String profileLabel = "";
    private VersionDate _versionDate = null;

    @Scriptable
    public void setUnits(String dataUnits) {
        this.units = dataUnits;
    }

    @Scriptable
    public String getUnits() {
        return this.units;
    }

    @Scriptable
    public void setType(String dataType) {
        this.type = dataType;
    }

    @Scriptable
    public String getType() {
        return this.type;
    }

    public int set(double[] dataValues, HecTimeArray hecTimes) {
        if (dataValues.length > hecTimes.numberElements()) {
            return -1;
        }
        int[] timesStuff = TimeSeriesContainer.getJulianDateAndTimeGranularity(hecTimes, dataValues.length);
        if (timesStuff == null) {
            return -2;
        }
        return this.set(dataValues, hecTimes, timesStuff[0], timesStuff[1]);
    }

    @Scriptable
    public int setTimes(HecTimeArray hecTimes) {
        if (hecTimes == null) {
            this.times = null;
            this.julianBaseDate = 0;
            return 0;
        }
        int[] timesStuff = TimeSeriesContainer.getJulianDateAndTimeGranularity(hecTimes, hecTimes.numberElements());
        if (timesStuff == null) {
            return -2;
        }
        return this.set(hecTimes, timesStuff[0], timesStuff[1]);
    }

    public static int[] getJulianDateAndTimeGranularity(HecTimeArray hecTimes, int dataValuesLength) {
        int julBaseDate = 0;
        int timeGranularityInSeconds = hecTimes.element(0).getTimeGranularityInSeconds();
        int firstJulian = hecTimes.element(0).julian();
        int lastJulian = hecTimes.element(dataValuesLength - 1).julian();
        long numberDays = (long)lastJulian - (long)firstJulian + 1L;
        if (numberDays > Integer.MAX_VALUE) {
            return null;
        }
        int[] values = new int[2];
        if (timeGranularityInSeconds == 60) {
            if (numberDays > 0x5555555L) {
                timeGranularityInSeconds = 86400;
            } else if (numberDays > 0x16C16CL) {
                timeGranularityInSeconds = 3600;
            }
        }
        if (timeGranularityInSeconds == 1) {
            julBaseDate = firstJulian;
        } else if (timeGranularityInSeconds == 60) {
            if (lastJulian > 0x16C16C) {
                julBaseDate = firstJulian;
            } else if (firstJulian < -1490000) {
                julBaseDate = firstJulian;
            }
        } else if (timeGranularityInSeconds == 3600) {
            if (lastJulian > 0x5555550) {
                julBaseDate = firstJulian;
            } else if (firstJulian < -89478000) {
                julBaseDate = firstJulian;
            }
        }
        values[0] = julBaseDate;
        values[1] = timeGranularityInSeconds;
        return values;
    }

    @Scriptable
    public int set(double[] dataValues, HecTimeArray hecTimes, int julBaseDate, int timeGranularityInSeconds) {
        if (dataValues.length > hecTimes.numberElements()) {
            return -1;
        }
        this.numberValues = dataValues.length;
        this.values = Arrays.copyOf(dataValues, dataValues.length);
        return this.set(hecTimes, julBaseDate, timeGranularityInSeconds);
    }

    public int set(HecTimeArray hecTimes, int julBaseDate, int timeGranularityInSeconds) {
        if (timeGranularityInSeconds != 1 && timeGranularityInSeconds != 60 && timeGranularityInSeconds != 3600 && timeGranularityInSeconds != 86400) {
            return -3;
        }
        this.timeGranularitySeconds = timeGranularityInSeconds;
        this.julianBaseDate = julBaseDate;
        this.times = new int[hecTimes.numberElements()];
        for (int i = 0; i < hecTimes.numberElements(); ++i) {
            HecTime htime = hecTimes.element(i);
            long days = htime.julian() - this.julianBaseDate;
            this.times[i] = (int)(days * 86400L / (long)this.timeGranularitySeconds) + htime.secondsSinceMidnight() / this.timeGranularitySeconds;
        }
        if (!this.startHecTime.isDefined()) {
            this.setStartTime(hecTimes.element(0));
        }
        if (!this.endHecTime.isDefined()) {
            this.setEndTime(hecTimes.element(hecTimes.numberElements() - 1));
        }
        return 0;
    }

    @Scriptable
    public int set(double[] dataValues, long[] minutes) {
        if (dataValues.length != minutes.length) {
            return -1;
        }
        this.numberValues = dataValues.length;
        this.timeGranularitySeconds = 60;
        HecTime hecTime = new HecTime();
        hecTime.setMinutes(minutes[0]);
        int firstJulian = hecTime.julian();
        hecTime.setMinutes(minutes[this.numberValues - 1]);
        int lastJulian = hecTime.julian();
        long numberDays = (long)lastJulian - (long)firstJulian + 1L;
        if (numberDays > Integer.MAX_VALUE) {
            return -2;
        }
        if (numberDays > 0x5555555L) {
            this.timeGranularitySeconds = 86400;
        } else if (numberDays > 0x16C16CL) {
            this.timeGranularitySeconds = 3600;
        }
        if (this.timeGranularitySeconds == 60) {
            if (lastJulian > 0x16C16C) {
                this.julianBaseDate = firstJulian;
            } else if (firstJulian < -1490000) {
                this.julianBaseDate = firstJulian;
            }
        } else if (this.timeGranularitySeconds == 3600) {
            if (lastJulian > 0x5555550) {
                this.julianBaseDate = firstJulian;
            } else if (firstJulian < -89478000) {
                this.julianBaseDate = firstJulian;
            }
        }
        this.values = Arrays.copyOf(dataValues, dataValues.length);
        this.times = new int[dataValues.length];
        if (this.julianBaseDate == 0 && this.timeGranularitySeconds == 60) {
            for (int i = 0; i < this.numberValues; ++i) {
                this.times[i] = (int)minutes[i];
            }
        } else if (this.timeGranularitySeconds == 60) {
            long minsInBase = (long)this.julianBaseDate * 1440L;
            for (int i = 0; i < this.numberValues; ++i) {
                this.times[i] = (int)(minutes[i] - minsInBase);
            }
        } else {
            long timeInBase = (long)this.julianBaseDate * 86400L / (long)this.timeGranularitySeconds;
            for (int i = 0; i < this.numberValues; ++i) {
                this.times[i] = (int)(minutes[i] * 60L / (long)this.timeGranularitySeconds - timeInBase);
            }
        }
        HecTime htime = new HecTime();
        htime.set(this.times[0], this.timeGranularitySeconds, this.julianBaseDate);
        this.setStartTime(htime);
        htime.set(this.times[this.values.length - 1], this.timeGranularitySeconds, this.julianBaseDate);
        this.setEndTime(htime);
        return 0;
    }

    @Scriptable
    public int setValues(double[] dataValues) {
        this.values = Arrays.copyOf(dataValues, dataValues.length);
        this.numberValues = this.values.length;
        return 0;
    }

    @Scriptable
    public void setStartTime(HecTime start) {
        this.startHecTime.set(start);
        long days = start.julian() - this.julianBaseDate;
        long time = (long)((int)(days * 86400L / (long)this.timeGranularitySeconds)) + (long)(start.secondsSinceMidnight() / this.timeGranularitySeconds);
        this.startTime = time < Integer.MAX_VALUE ? (int)time : 0;
    }

    @Scriptable
    public HecTime getStartTime() {
        HecTime start = new HecTime();
        if (this.startHecTime.isDateDefined()) {
            start.set(this.startHecTime);
        } else if (this.startTime == 0 && this.endTime == 0) {
            start.setUndefined();
        } else {
            start.set(this.startTime, this.timeGranularitySeconds, this.julianBaseDate);
        }
        return start;
    }

    @Scriptable
    public void setEndTime(HecTime end) {
        this.endHecTime.set(end);
        long days = end.julian() - this.julianBaseDate;
        long time = (long)((int)(days * 86400L / (long)this.timeGranularitySeconds)) + (long)(end.secondsSinceMidnight() / this.timeGranularitySeconds);
        this.endTime = time < Integer.MAX_VALUE ? (int)time : 0;
    }

    @Scriptable
    public HecTime getEndTime() {
        HecTime end = new HecTime();
        if (this.endHecTime.isDateDefined()) {
            end.set(this.endHecTime);
        } else if (this.startTime == 0 && this.endTime == 0) {
            end.setUndefined();
        } else {
            end.set(this.endTime, this.timeGranularitySeconds, this.julianBaseDate);
        }
        return end;
    }

    @Scriptable
    public HecTimeArray getTimes() {
        if (this.numberValues < 1) {
            return null;
        }
        HecTimeArray hecTimeArray = new HecTimeArray(this.numberValues);
        if (this.times != null) {
            for (int i = 0; i < this.times.length; ++i) {
                HecTime hecTime = new HecTime();
                hecTime.set(this.times[i], this.timeGranularitySeconds, this.julianBaseDate);
                hecTimeArray.set(i, hecTime);
            }
        } else if (this.interval > 0) {
            if (this.startHecTime.isDefined()) {
                for (int i = 0; i < this.numberValues; ++i) {
                    HecTime hecTime = new HecTime(this.startHecTime);
                    hecTime.increment(i, this.interval);
                    hecTimeArray.set(i, hecTime);
                }
            } else {
                for (int i = 0; i < this.numberValues; ++i) {
                    HecTime hecTime = new HecTime();
                    hecTime.set(this.startTime, this.timeGranularitySeconds, this.julianBaseDate);
                    hecTime.increment(i, this.interval);
                    hecTimeArray.set(i, hecTime);
                }
            }
        } else {
            hecTimeArray = null;
        }
        return hecTimeArray;
    }

    @Scriptable
    public HecTime getHecTime(int index) {
        if (index < 0 || index >= this.numberValues) {
            return null;
        }
        HecTime hecTime = new HecTime();
        if (this.times != null && index < this.times.length) {
            hecTime.set(this.times[index], this.timeGranularitySeconds, this.julianBaseDate);
        } else if (this.interval > 0) {
            hecTime.set(this.startTime, this.timeGranularitySeconds, this.julianBaseDate);
            hecTime.increment(index, this.interval);
        }
        return hecTime;
    }

    @Scriptable
    @Deprecated
    public int getTimeInterval() {
        if (this.interval == 0) {
            DSSPathname path = new DSSPathname(this.getFullName());
            String sintl = path.isCwmsTsId() ? path.getDPart() : path.getEPart();
            int tsIntervalSeconds = DSSPathname.getTSIntervalSeconds(sintl, null);
            if (this.timeGranularitySeconds == 0) {
                this.timeGranularitySeconds = 60;
            }
            this.interval = tsIntervalSeconds / this.timeGranularitySeconds;
        }
        return this.interval;
    }

    @Scriptable
    public int getTimeIntervalSeconds() {
        this.getTimeInterval();
        if (this.interval > 0) {
            return this.interval * this.timeGranularitySeconds;
        }
        return this.interval;
    }

    @Scriptable
    public int getNumberValues() {
        return this.numberValues;
    }

    @Scriptable
    public double[] getValues() {
        if (this.values == null) {
            return new double[0];
        }
        return Arrays.copyOf(this.values, this.values.length);
    }

    @Scriptable
    public double getValue(int index) {
        if (index < 0 || index >= this.values.length) {
            return -3.4028234663852886E38;
        }
        return this.values[index];
    }

    @Scriptable
    public double getValue(HecTime time) {
        long beg;
        long end;
        if (time == null || this.values == null || this.numberValues < 1 || this.numberValues > this.values.length) {
            return -3.4028234663852886E38;
        }
        if (this.startHecTime.isDefined() && time.lessThan(this.startHecTime)) {
            return -3.4028234663852886E38;
        }
        if (this.endHecTime.isDefined() && time.greaterThan(this.endHecTime)) {
            return -3.4028234663852886E38;
        }
        HecTime hecTime = new HecTime();
        int ipos = -1;
        if (this.times == null) {
            if (this.interval <= 0) {
                return -3.4028234663852886E38;
            }
            int numberPeriods = this.startHecTime.computeNumberIntervals(time, this.interval);
            hecTime.set(this.startHecTime);
            hecTime.increment(numberPeriods, this.interval);
            if (hecTime.equalTo(time) || numberPeriods == 0) {
                return this.values[numberPeriods];
            }
            if (numberPeriods < 0 || numberPeriods >= this.numberValues) {
                return -3.4028234663852886E38;
            }
            ipos = numberPeriods;
            end = hecTime.getMinutes();
            hecTime.increment(-1, this.interval);
            beg = hecTime.getMinutes();
        } else {
            hecTime.set(this.times[0], this.timeGranularitySeconds, this.julianBaseDate);
            if (time.lessThan(hecTime)) {
                return -3.4028234663852886E38;
            }
            long minutesStart = hecTime.getMinutes();
            hecTime.set(this.times[this.times.length - 1], this.timeGranularitySeconds, this.julianBaseDate);
            if (time.greaterThan(hecTime)) {
                return -3.4028234663852886E38;
            }
            long minutesEnd = hecTime.getMinutes();
            int startOrd = (int)((time.getMinutes() - minutesStart) * (long)this.times.length / (minutesEnd - minutesStart));
            if (startOrd < 0) {
                startOrd = 0;
            }
            if (startOrd > this.times.length - 1) {
                startOrd = this.times.length - 1;
            }
            hecTime.set(this.times[startOrd], this.timeGranularitySeconds, this.julianBaseDate);
            if (time.equalTo(hecTime)) {
                return this.values[startOrd];
            }
            if (time.greaterThan(hecTime)) {
                for (int i = startOrd; i < this.times.length; ++i) {
                    hecTime.set(this.times[i], this.timeGranularitySeconds, this.julianBaseDate);
                    if (time.equalTo(hecTime)) {
                        return this.values[i];
                    }
                    if (!hecTime.greaterThan(time)) continue;
                    ipos = i;
                    break;
                }
            } else {
                for (int i = startOrd; i >= 0; --i) {
                    hecTime.set(this.times[i], this.timeGranularitySeconds, this.julianBaseDate);
                    if (time.equalTo(hecTime)) {
                        return this.values[i];
                    }
                    if (!hecTime.lessThan(time)) continue;
                    ipos = i;
                    break;
                }
            }
            if (ipos < 1) {
                return -3.4028234663852886E38;
            }
            end = hecTime.getMinutes();
            hecTime.set(this.times[ipos - 1], this.timeGranularitySeconds, this.julianBaseDate);
            beg = hecTime.getMinutes();
        }
        long ask = time.getMinutes();
        double answer = this.values[ipos - 1] + (this.values[ipos] - this.values[ipos - 1]) * ((double)(ask - beg) / (double)(end - beg));
        return answer;
    }

    @Scriptable
    public int setQuality(int[] qualityIn) {
        if (this.values != null && this.numberValues != qualityIn.length) {
            System.out.println("Warning:  Number of quality values does not match number of data values");
            System.out.println("Number of data values: " + this.numberValues);
            System.out.println("Number of quality values: " + qualityIn.length);
            if (this.fullName != null && this.fullName.length() > 2) {
                System.out.println("Name: " + this.fullName);
            }
        }
        this.quality = Arrays.copyOf(qualityIn, qualityIn.length);
        return 0;
    }

    @Scriptable
    public int[] getQuality() {
        return this.quality == null ? null : Arrays.copyOf(this.quality, this.quality.length);
    }

    public int setQuality7(int[][] qualityIn) {
        if (this.values != null && this.numberValues != qualityIn.length) {
            System.out.println("Warning:  Number of quality values does not match number of data values");
            System.out.println("Number of data values: " + this.numberValues);
            System.out.println("Number of quality values: " + qualityIn.length);
            if (this.fullName != null && this.fullName.length() > 2) {
                System.out.println("Name: " + this.fullName);
            }
        }
        this.sizeEachQuality7 = qualityIn[0].length;
        if (this.sizeEachQuality7 > 0) {
            this.quality7 = new int[qualityIn.length][this.sizeEachQuality7];
            for (int i = 0; i < this.sizeEachQuality7; ++i) {
                for (int j = 0; j < qualityIn.length; ++j) {
                    this.quality7[j][i] = qualityIn[j][i];
                }
            }
        } else {
            this.quality7 = null;
        }
        return 0;
    }

    public int getQualitySize() {
        if (this.quality7 != null) {
            return this.quality7[0].length;
        }
        if (this.quality != null) {
            return 1;
        }
        return 0;
    }

    @Scriptable
    public int[][] getQuality7() {
        if (this.quality7 == null || this.quality7[0].length < 1) {
            if (this.quality != null) {
                int[][] qual = new int[this.quality.length][1];
                for (int j = 0; j < this.quality.length; ++j) {
                    qual[j][0] = this.quality[j];
                }
                return qual;
            }
            return null;
        }
        int[][] qual = new int[this.quality7.length][this.quality7[0].length];
        for (int i = 0; i < this.quality7[0].length; ++i) {
            for (int j = 0; j < this.quality7.length; ++j) {
                qual[j][i] = this.quality7[j][i];
            }
        }
        return qual;
    }

    public void setCharacterNotes(String[] characterNotes) {
        this.cnotes = Arrays.copyOf(characterNotes, characterNotes.length);
    }

    public String[] getCharacterNotes() {
        if (this.cnotes == null) {
            return new String[0];
        }
        return Arrays.copyOf(this.cnotes, this.cnotes.length);
    }

    @Scriptable
    public int setProfile(double[] profileDepths, double[][] profileValues) {
        this.profileDepths = Arrays.copyOf(profileDepths, profileDepths.length);
        this.numberDepths = profileValues[0].length;
        this.numberValues = profileValues.length;
        if (this.numberDepths != this.profileDepths.length) {
            System.out.println("TimeSeriesContainer, setProfile error - number of depths is not the same");
            System.out.println("profileDepths[] number: " + this.profileDepths.length + "  profileValues[][] numberDepths " + this.numberDepths);
        }
        this.profileValues = new double[profileValues.length][this.numberDepths];
        for (int i = 0; i < this.numberDepths; ++i) {
            for (int j = 0; j < profileValues.length; ++j) {
                this.profileValues[j][i] = profileValues[j][i];
            }
        }
        return 0;
    }

    public int getProfileNumberDepths() {
        if (this.profileValues == null) {
            return 0;
        }
        return this.profileValues[0].length;
    }

    public double[] getProfileDepths() {
        if (this.profileDepths == null) {
            return new double[0];
        }
        return Arrays.copyOf(this.profileDepths, this.profileDepths.length);
    }

    public double[][] getProfileValues() {
        if (this.profileValues == null) {
            return new double[0][0];
        }
        this.numberDepths = this.profileValues[0].length;
        double[][] profileVals = new double[this.profileValues.length][this.numberDepths];
        for (int i = 0; i < this.numberDepths; ++i) {
            for (int j = 0; j < this.profileValues.length; ++j) {
                profileVals[j][i] = this.profileValues[j][i];
            }
        }
        return profileVals;
    }

    public void setProfileDepthsUnits(String unitsProfileDepths) {
        this.unitsProfileDepths = unitsProfileDepths;
    }

    public void setProfileValuesUnits(String unitsProfileValues) {
        this.unitsProfileValues = unitsProfileValues;
    }

    public void setProfileLabel(String profileLabel) {
        this.profileLabel = profileLabel;
    }

    public String getProfileDepthsUnits() {
        return this.unitsProfileDepths;
    }

    public String getProfileValuesUnits() {
        return this.unitsProfileValues;
    }

    public String getProfileLabel() {
        return this.profileLabel;
    }

    @Scriptable
    public int[] getMinutes() {
        int[] minutes;
        if (this.timeGranularitySeconds == 60) {
            minutes = Arrays.copyOf(this.times, this.times.length);
        } else if (this.timeGranularitySeconds > 60) {
            int minsInGranularity = this.timeGranularitySeconds / 60;
            minutes = new int[this.times.length];
            for (int i = 0; i < this.numberValues; ++i) {
                minutes[i] = this.times[i] * minsInGranularity;
            }
        } else {
            minutes = new int[this.times.length];
            for (int i = 0; i < this.numberValues; ++i) {
                minutes[i] = this.times[i] * this.timeGranularitySeconds / 60;
            }
        }
        return minutes;
    }

    @Scriptable
    public long[] getMinutesLong() {
        if (this.times == null) {
            return null;
        }
        long[] minutes = new long[this.times.length];
        if (this.julianBaseDate == 0 && this.timeGranularitySeconds == 60) {
            for (int i = 0; i < this.times.length; ++i) {
                minutes[i] = this.times[i];
            }
        } else if (this.timeGranularitySeconds == 60) {
            long minsInBase = (long)this.julianBaseDate * 1440L;
            for (int i = 0; i < this.times.length; ++i) {
                minutes[i] = (long)this.times[i] + minsInBase;
            }
        } else if (this.timeGranularitySeconds > 60) {
            long minsInBase = (long)this.julianBaseDate * 1440L;
            long minsInGranularity = (long)this.timeGranularitySeconds / 60L;
            for (int i = 0; i < this.times.length; ++i) {
                minutes[i] = (long)this.times[i] * minsInGranularity + minsInBase;
            }
        } else {
            long minsInBase = (long)this.julianBaseDate * 1440L;
            for (int i = 0; i < this.times.length; ++i) {
                minutes[i] = (long)this.times[i] * (long)this.timeGranularitySeconds / 60L + minsInBase;
            }
        }
        return minutes;
    }

    @Scriptable
    public long getMinutesLong(int index) {
        long minutes;
        if (this.times == null) {
            return 0L;
        }
        if (this.julianBaseDate == 0 && this.timeGranularitySeconds == 60) {
            minutes = this.times[index];
        } else if (this.timeGranularitySeconds == 60) {
            long minsInBase = (long)this.julianBaseDate * 1440L;
            minutes = (long)this.times[index] + minsInBase;
        } else if (this.timeGranularitySeconds > 60) {
            long minsInBase = (long)this.julianBaseDate * 1440L;
            long minsInGranularity = (long)this.timeGranularitySeconds / 60L;
            minutes = (long)this.times[index] * minsInGranularity + minsInBase;
        } else {
            long minsInBase = (long)this.julianBaseDate * 1440L;
            minutes = (long)this.times[index] * (long)this.timeGranularitySeconds / 60L + minsInBase;
        }
        return minutes;
    }

    @Scriptable
    public int getJulianBaseDate() {
        return this.julianBaseDate;
    }

    @Scriptable
    public void setJulianBaseDate(int julBaseDate) {
        this.julianBaseDate = julBaseDate;
    }

    @Scriptable
    public int getTimeGranularitySeconds() {
        this.getTimeInterval();
        return this.timeGranularitySeconds;
    }

    @Scriptable
    public void setTimeGranularitySeconds(int timeGranularityInSeconds) {
        this.timeGranularitySeconds = timeGranularityInSeconds;
    }

    @Scriptable
    public boolean usesExtendedDates() {
        return this.julianBaseDate != 0 || this.timeGranularitySeconds != 60;
    }

    @Scriptable
    public Object clone() {
        TimeSeriesContainer container = new TimeSeriesContainer();
        this.clone(container);
        return container;
    }

    @Scriptable
    public void clone(TimeSeriesContainer tsc) {
        this._clone(tsc);
    }

    private void _clone(TimeSeriesContainer tsc) {
        int i;
        super.clone(tsc);
        tsc.numberValues = this.numberValues;
        if (this.values != null) {
            tsc.values = new double[this.values.length];
        }
        if (this.times != null) {
            tsc.times = new int[this.times.length];
        }
        if (this.quality != null) {
            tsc.quality = new int[this.quality.length];
        }
        tsc.numberDepths = this.numberDepths;
        if (this.profileDepths != null) {
            tsc.profileDepths = new double[this.profileDepths.length];
            for (i = 0; i < this.numberDepths; ++i) {
                tsc.profileDepths[i] = this.profileDepths[i];
            }
        }
        if (this.profileValues != null) {
            tsc.profileValues = new double[this.numberValues][this.numberDepths];
            for (i = 0; i < this.numberValues; ++i) {
                for (int j = 0; j < this.numberDepths; ++j) {
                    tsc.profileValues[i][j] = this.profileValues[i][j];
                }
            }
        }
        tsc.unitsProfileDepths = this.unitsProfileDepths;
        tsc.unitsProfileValues = this.unitsProfileValues;
        tsc.profileLabel = this.profileLabel;
        if (this.values != null) {
            System.arraycopy(this.values, 0, tsc.values, 0, this.values.length);
        }
        if (this.times != null) {
            System.arraycopy(this.times, 0, tsc.times, 0, this.times.length);
        }
        if (this.quality != null) {
            System.arraycopy(this.quality, 0, tsc.quality, 0, this.quality.length);
        }
        tsc.interval = this.interval;
        tsc.startTime = this.startTime;
        tsc.endTime = this.endTime;
        tsc.startHecTime.set(this.startHecTime);
        tsc.endHecTime.set(this.endHecTime);
        tsc.units = this.units;
        tsc.type = this.type;
        tsc.precision = this.precision;
        tsc.subLocation = this.subLocation;
        tsc.parameter = this.parameter;
        tsc.subParameter = this.subParameter;
        tsc.julianBaseDate = this.julianBaseDate;
        tsc.timeGranularitySeconds = this.timeGranularitySeconds;
        tsc.timeZoneID = this.timeZoneID != null ? this.timeZoneID : null;
        tsc.timeZoneRawOffset = this.timeZoneRawOffset;
        if (this._versionDate != null) {
            tsc._versionDate = VersionDateFactory.copy((VersionDate)this._versionDate);
        }
    }

    @Scriptable
    public void setTimeZoneID(String timeZoneIdentifier) {
        this.timeZoneID = timeZoneIdentifier;
        this.timeZoneRawOffset = TimeZone.getTimeZone(this.timeZoneID).getRawOffset();
    }

    @Scriptable
    public String getTimeZoneID() {
        return this.timeZoneID;
    }

    @Scriptable
    public void convertTimeZone(TimeZone toTimezone) {
        TimeZone fromTimezone = TimeZone.getTimeZone(this.timeZoneID);
        if (fromTimezone == null || toTimezone == null) {
            return;
        }
        Calendar calFrom = Calendar.getInstance(fromTimezone);
        Calendar calTo = Calendar.getInstance(toTimezone);
        HecTime hecTime = new HecTime();
        for (int i = 0; i < this.times.length; ++i) {
            if (this.times[i] == -2147483647) continue;
            hecTime.set(this.times[i], this.timeGranularitySeconds, this.julianBaseDate);
            calTo.setTimeInMillis(hecTime.getTimeInMillis(calFrom));
            hecTime.set(calTo);
            this.times[i] = hecTime.value();
        }
        hecTime = this.getStartTime();
        calTo.setTimeInMillis(hecTime.getTimeInMillis(calFrom));
        hecTime.set(calTo);
        this.setStartTime(hecTime);
        hecTime = this.getEndTime();
        calTo.setTimeInMillis(hecTime.getTimeInMillis(calFrom));
        hecTime.set(calTo);
        this.setEndTime(hecTime);
        this.timeZoneID = toTimezone.getID();
        this.timeZoneRawOffset = toTimezone.getRawOffset();
    }

    @Scriptable
    public boolean convertTimeZone(String toTimezoneID, boolean observeDST) {
        TimeZone fromTimezone = TimeZone.getTimeZone(this.timeZoneID);
        TimeZone toTimezone = TimeZone.getTimeZone(toTimezoneID);
        if (fromTimezone == null || toTimezone == null) {
            return false;
        }
        HecTime hecTime = new HecTime();
        for (int i = 0; i < this.times.length; ++i) {
            if (this.times[i] == -2147483647) continue;
            hecTime.set(this.times[i], this.timeGranularitySeconds, this.julianBaseDate);
            HecTime.convertTimeZone(hecTime, fromTimezone, toTimezone, observeDST);
            this.times[i] = hecTime.value();
        }
        hecTime = this.getStartTime();
        HecTime.convertTimeZone(hecTime, fromTimezone, toTimezone, observeDST);
        this.setStartTime(hecTime);
        hecTime = this.getEndTime();
        HecTime.convertTimeZone(hecTime, fromTimezone, toTimezone, observeDST);
        this.setEndTime(hecTime);
        this.timeZoneID = toTimezoneID;
        this.timeZoneRawOffset = toTimezone.getRawOffset();
        return true;
    }

    public boolean trimToTime(HecTime newStartTime, HecTime newEndTime, boolean bShrinkOnly) {
        boolean bRet = false;
        if (bShrinkOnly) {
            if (this.numberValues > 0 && this.times != null && this.times.length > 0) {
                this.startTime = this.times[0];
                if (newStartTime.lessThan(this.getStartTime())) {
                    newStartTime.set(this.getStartTime());
                }
                if (this.getEndTime().lessThan(newEndTime)) {
                    newEndTime.set(this.getEndTime());
                }
                bRet = this.trimToTime(newStartTime, newEndTime);
            }
        } else {
            bRet = this.trimToTime(newStartTime, newEndTime);
        }
        return bRet;
    }

    public boolean trimToTime(HecTime newStartTime, HecTime newEndTime) {
        if (newEndTime.lessThan(newStartTime)) {
            return false;
        }
        int timeIntervalSeconds = this.getTimeIntervalSeconds();
        int first = -1;
        int last = -1;
        if (this.times != null && this.interval < 1) {
            int i;
            HecTimeArray timeArray = this.getTimes();
            for (i = 0; i < timeArray.numberElements(); ++i) {
                if (!newStartTime.lessThanEqualTo(timeArray.element(i))) continue;
                first = i;
                break;
            }
            for (i = timeArray.numberElements() - 1; i >= 0; --i) {
                if (!newEndTime.greaterThanEqualTo(timeArray.element(i))) continue;
                last = i;
                break;
            }
            if (first == -1 && last == -1) {
                return false;
            }
            if (first == -1) {
                first = 0;
            }
            if (last == -1) {
                last = 0;
            }
            this.setStartTime(newStartTime);
            this.setEndTime(newEndTime);
        } else if (timeIntervalSeconds > 0) {
            int intervalOffset = 0;
            int intervalMinutes = timeIntervalSeconds / 60;
            HecTime htstart = this.getStartTime();
            if (timeIntervalSeconds >= 60) {
                intervalOffset = htstart.getIntervalOffset(intervalMinutes);
                if (intervalOffset != 0) {
                    htstart.adjustToIntervalOffset(intervalMinutes, 0);
                }
                newStartTime.adjustToIntervalOffset(intervalMinutes, 0);
                newEndTime.adjustToIntervalOffset(intervalMinutes, 0);
            }
            HecTime htend = new HecTime(htstart);
            first = htstart.computeNumberIntervalsSecs(newStartTime, timeIntervalSeconds);
            if (first > (last = htstart.computeNumberIntervalsSecs(newEndTime, timeIntervalSeconds))) {
                return false;
            }
            htstart.incrementSecs(first, timeIntervalSeconds);
            htend.incrementSecs(last, timeIntervalSeconds);
            if (intervalOffset != 0) {
                htstart.adjustToIntervalOffset(intervalMinutes, intervalOffset);
                htend.adjustToIntervalOffset(intervalMinutes, intervalOffset);
            }
            this.setStartTime(htstart);
            this.setEndTime(htend);
        } else {
            return false;
        }
        if (first != 0 || last != this.numberValues - 1) {
            if (first >= 0 && last < this.numberValues && this.quality7 == null && this.inotes == null && this.cnotes == null && this.profileValues == null) {
                if (this.times != null) {
                    this.times = Arrays.copyOfRange(this.times, first, last + 1);
                }
                this.values = Arrays.copyOfRange(this.values, first, last + 1);
                if (this.quality != null) {
                    this.quality = Arrays.copyOfRange(this.quality, first, last + 1);
                }
                this.numberValues = last - first + 1;
            } else {
                int j;
                int i;
                int size = last - first + 1;
                if (timeIntervalSeconds > 0 && this.times != null) {
                    this.times = null;
                }
                int[] newTimes = null;
                if (this.times != null) {
                    newTimes = new int[size];
                }
                double[] newValues = null;
                if (this.values != null) {
                    newValues = new double[size];
                }
                int[] newQuality = null;
                if (this.quality != null) {
                    newQuality = new int[size];
                }
                int[][] newQuality7 = null;
                if (this.quality7 != null) {
                    newQuality7 = new int[size][this.sizeEachQuality7];
                }
                int[][] newinotes = null;
                if (this.inotes != null) {
                    newinotes = new int[size][this.sizeEachNote];
                }
                String[] newcnotes = null;
                if (this.cnotes != null) {
                    newcnotes = new String[size];
                }
                double[][] newprofileValues = null;
                if (this.profileValues != null) {
                    newprofileValues = new double[size][this.numberDepths];
                }
                int ipos = 0;
                if (first < 0) {
                    int pfirst = -first;
                    for (i = 0; i < pfirst; ++i) {
                        if (newValues != null) {
                            newValues[ipos] = -3.4028234663852886E38;
                        }
                        if (newTimes != null) {
                            newTimes[ipos] = 0;
                        }
                        if (newQuality != null) {
                            newQuality[ipos] = 0;
                        }
                        if (newQuality7 != null) {
                            for (j = 0; j < this.sizeEachQuality7; ++j) {
                                newQuality7[ipos][j] = 0;
                            }
                        }
                        if (newinotes != null) {
                            for (j = 0; j < this.sizeEachNote; ++j) {
                                newinotes[ipos][j] = 0;
                            }
                        }
                        if (newcnotes != null) {
                            newcnotes[ipos] = "";
                        }
                        if (newprofileValues != null) {
                            for (j = 0; j < this.numberDepths; ++j) {
                                newprofileValues[ipos][j] = -3.4028234663852886E38;
                            }
                        }
                        ++ipos;
                    }
                    first = 0;
                }
                int endPos = last + 1;
                if (last >= this.numberValues) {
                    endPos = this.numberValues;
                }
                for (i = first; i < endPos; ++i) {
                    if (newValues != null) {
                        newValues[ipos] = this.values[i];
                    }
                    if (newQuality != null) {
                        newQuality[ipos] = this.quality[i];
                    }
                    if (newQuality7 != null) {
                        for (j = 0; j < this.sizeEachQuality7; ++j) {
                            newQuality7[ipos][j] = this.quality7[i][j];
                        }
                    }
                    if (newinotes != null) {
                        for (j = 0; j < this.sizeEachNote; ++j) {
                            newinotes[ipos][j] = this.inotes[i][j];
                        }
                    }
                    if (newcnotes != null) {
                        newcnotes[ipos] = this.cnotes[i];
                    }
                    if (newprofileValues != null) {
                        for (j = 0; j < this.numberDepths; ++j) {
                            newprofileValues[ipos][j] = this.profileValues[i][j];
                        }
                    }
                    if (newTimes != null) {
                        newTimes[ipos] = this.times[i];
                    }
                    ++ipos;
                }
                if (last > this.numberValues) {
                    for (i = this.numberValues; i <= last; ++i) {
                        if (newValues != null) {
                            newValues[ipos] = -3.4028234663852886E38;
                        }
                        if (newTimes != null) {
                            newTimes[ipos] = 0;
                        }
                        if (newQuality != null) {
                            newQuality[ipos] = 0;
                        }
                        if (newQuality7 != null) {
                            for (j = 0; j < this.sizeEachQuality7; ++j) {
                                newQuality7[ipos][j] = 0;
                            }
                        }
                        if (newinotes != null) {
                            for (j = 0; j < this.sizeEachNote; ++j) {
                                newinotes[ipos][j] = 0;
                            }
                        }
                        if (newcnotes != null) {
                            newcnotes[ipos] = "";
                        }
                        if (newprofileValues != null) {
                            for (j = 0; j < this.numberDepths; ++j) {
                                newprofileValues[ipos][j] = -3.4028234663852886E38;
                            }
                        }
                        ++ipos;
                    }
                }
                this.times = newTimes;
                this.values = newValues;
                this.quality = newQuality;
                this.quality7 = newQuality7;
                this.inotes = newinotes;
                this.cnotes = newcnotes;
                this.profileValues = newprofileValues;
                this.numberValues = size;
            }
        }
        if (this.times == null) {
            HecTimeArray htimes = this.getTimes();
            this.setTimes(htimes);
        }
        return true;
    }

    public boolean getDataSetStats(TsDataSetStats dataStats) {
        int i;
        if (this.values == null) {
            return false;
        }
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double total = 0.0;
        int minTime = 0;
        int maxTime = 0;
        int numberValid = 0;
        dataStats.locationName = this.location;
        dataStats.parameter = this.parameter;
        dataStats.firstValueTime.setUndefined();
        for (i = 0; i < this.values.length; ++i) {
            if (this.values[i] == -3.4028234663852886E38) continue;
            dataStats.firstValue.set(this.values[i], this.precision);
            dataStats.firstValueTime.set(this.times[i]);
            break;
        }
        if (!dataStats.firstValueTime.isDefined()) {
            dataStats.setUndefined();
            return false;
        }
        for (i = this.values.length - 1; i >= 0; --i) {
            if (this.values[i] == -3.4028234663852886E38) continue;
            dataStats.lastValue.set(this.values[i], this.precision);
            dataStats.lastValueTime.set(this.times[i]);
            break;
        }
        for (i = 0; i < this.values.length; ++i) {
            if (this.values[i] == -3.4028234663852886E38) continue;
            ++numberValid;
            if (this.values[i] < min) {
                min = this.values[i];
                minTime = i;
            }
            if (this.values[i] > max) {
                max = this.values[i];
                maxTime = i;
            }
            total += this.values[i];
        }
        int prec = this.precision;
        if (this.precision < 0) {
            String u = this.units.toLowerCase();
            prec = u.startsWith("cfs") ? 0 : (u.startsWith("m3") ? 0 : (u.startsWith("feet") ? 1 : (u.startsWith("met") ? 1 : (u.startsWith("deg") ? 1 : (u.startsWith("mm") ? 0 : 2)))));
        }
        dataStats.minValue.set(min, prec);
        dataStats.minValueTime.set(this.times[minTime]);
        dataStats.maxValue.set(max, prec);
        dataStats.maxValueTime.set(this.times[maxTime]);
        dataStats.total.set(total, prec);
        dataStats.average.set(total / (double)numberValid, prec);
        dataStats.totalNumber = this.values.length;
        dataStats.numberValid = numberValid;
        dataStats.numberMissing = this.values.length - numberValid;
        return true;
    }

    @Scriptable
    public double minimumValue() {
        double min = Double.POSITIVE_INFINITY;
        if (this.values == null) {
            return -3.4028234663852886E38;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == -3.4028234663852886E38 || !(this.values[i] < min)) continue;
            min = this.values[i];
        }
        if (min == Double.POSITIVE_INFINITY) {
            return -3.4028234663852886E38;
        }
        return min;
    }

    @Deprecated
    public double maxmimumValue() {
        return this.maximumValue();
    }

    @Scriptable
    public double maximumValue() {
        double max = Double.NEGATIVE_INFINITY;
        if (this.values == null) {
            return -3.4028234663852886E38;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == -3.4028234663852886E38 || !(this.values[i] > max)) continue;
            max = this.values[i];
        }
        if (max == Double.NEGATIVE_INFINITY) {
            return -3.4028234663852886E38;
        }
        return max;
    }

    @Scriptable
    public double mean() {
        double mean = 0.0;
        int cnt = 0;
        if (this.values == null) {
            return -3.4028234663852886E38;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == -3.4028234663852886E38) continue;
            mean += this.values[i];
            ++cnt;
        }
        if (cnt == 0) {
            return -3.4028234663852886E38;
        }
        return mean / (double)cnt;
    }

    public String getShortName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLocationName());
        sb.append(" ");
        sb.append(this.getVersionName());
        sb.append(" ");
        sb.append(this.getParameterName());
        if (this._versionDate != null) {
            this.appendVersionDate(sb);
        }
        return sb.toString();
    }

    @Scriptable
    public String getVersionName() {
        StringBuffer sb = new StringBuffer();
        if (this.version != null && this.version.length() > 0) {
            sb.append(this.version);
            if (this.subVersion != null && this.subVersion.length() > 0) {
                sb.append("-");
                sb.append(this.subVersion);
            }
            return sb.toString();
        }
        if (this.fullName == null) {
            return "";
        }
        if (this.fullName.length() == 0) {
            return "";
        }
        DSSPathname path = new DSSPathname(this.fullName);
        this.version = path.fPart();
        return this.version;
    }

    @Scriptable
    public String getParameterName() {
        StringBuffer sb = new StringBuffer();
        if (this.parameter != null && this.parameter.length() > 0) {
            sb.append(this.parameter);
            if (this.subParameter != null && this.subParameter.length() > 0) {
                sb.append("-");
                sb.append(this.subParameter);
            }
            return sb.toString();
        }
        if (this.fullName == null) {
            return "";
        }
        if (this.fullName.length() == 0) {
            return "";
        }
        DSSPathname path = new DSSPathname(this.fullName);
        this.parameter = path.cPart();
        return this.parameter;
    }

    @Scriptable
    public String getLocationName() {
        StringBuffer sb = new StringBuffer();
        if (this.location != null && this.location.length() > 0) {
            sb.append(this.location);
            if (this.subLocation != null && this.subLocation.length() > 0) {
                sb.append("-");
                sb.append(this.subLocation);
            }
            return sb.toString();
        }
        if (this.fullName == null) {
            return "";
        }
        if (this.fullName.length() == 0) {
            return "";
        }
        DSSPathname path = new DSSPathname(this.fullName);
        this.location = path.bPart();
        return this.location;
    }

    public void setCompressData(boolean compress) {
        this._compressData = compress;
    }

    public boolean compressData() {
        return this._compressData;
    }

    @Scriptable
    public String getAsString() {
        HecTime htime = new HecTime();
        StringBuffer stb = new StringBuffer();
        stb.append("location " + this.fullName + "\n");
        if (this.values == null || this.times == null) {
            return stb.toString();
        }
        for (int i = 0; i < this.values.length; ++i) {
            htime.set(this.times[i]);
            stb.append(" time " + htime.toString(104) + "  value " + this.values[i] + "\n");
        }
        return stb.toString();
    }

    @Scriptable
    public String getAsXML() {
        HecTime htime = new HecTime();
        StringBuffer xml = new StringBuffer();
        xml.append("<xml version 1.0>\n");
        xml.append("<HECDSSTimeSeriesData>\n");
        xml.append("<location>" + this.fullName + "</location>\n");
        if (this.values == null || this.times == null) {
            xml.append("</HECDSSTimeSeriesData>\n");
            return xml.toString();
        }
        for (int i = 0; i < this.values.length; ++i) {
            htime.set(this.times[i], this.timeGranularitySeconds, this.julianBaseDate);
            xml.append("<TimeSeriesRecord>\n");
            xml.append("<Time>" + htime.toString(104) + "</Time>\n");
            xml.append("<Value>" + this.values[i] + "</Value>\n");
            xml.append("</TimeSeriesRecord>\n");
        }
        xml.append("</HECDSSTimeSeriesData>\n");
        return xml.toString();
    }

    @Scriptable
    public int removeAllMissing() {
        int missing = 0;
        if (this.values == null) {
            return 0;
        }
        if (this.values.length == 0) {
            return 0;
        }
        for (int j = 0; j < this.values.length; ++j) {
            if (this.values[j] != -3.4028234663852886E38) continue;
            ++missing;
        }
        if (missing == 0) {
            this.numberValues = this.values.length;
            return this.values.length;
        }
        int number = this.values.length - missing;
        int[] newTimes = new int[number];
        double[] newValues = new double[number];
        int[] qual = null;
        if (this.quality != null) {
            qual = new int[number];
        }
        int count = 0;
        for (int j = 0; j < this.values.length; ++j) {
            if (this.values[j] == -3.4028234663852886E38) continue;
            newTimes[count] = this.times[j];
            newValues[count] = this.values[j];
            if (qual != null) {
                qual[count] = this.quality[j];
            }
            ++count;
        }
        this.numberValues = count;
        this.times = newTimes;
        this.values = newValues;
        this.quality = qual;
        return this.numberValues;
    }

    @Scriptable
    public void makeAscending() {
        boolean ascending = true;
        boolean badValues = false;
        TimeSeriesContainer tsc = this;
        for (int j = 0; j < tsc.times.length; ++j) {
            if (tsc.times[j] == -2147483647) {
                badValues = true;
            }
            if (j <= 0 || tsc.times[j] > tsc.times[j - 1]) continue;
            ascending = false;
        }
        double[] values = tsc.values;
        int[] times = tsc.times;
        int[] quality = tsc.quality;
        if (!ascending) {
            times = Arrays.copyOf(tsc.times, tsc.times.length);
            Arrays.sort(times);
        }
        if (!ascending || badValues) {
            int badCount = 0;
            for (int j = 0; j < times.length; ++j) {
                if (times[j] != -2147483647) continue;
                ++badCount;
            }
            int newSize = times.length - badCount;
            if (newSize < 1) {
                return;
            }
            int[] tmpTimes = new int[newSize];
            double[] tmpVals = new double[newSize];
            int[] tmpQuality = null;
            if (tsc.quality != null) {
                tmpQuality = new int[newSize];
            }
            int count = 0;
            block2: for (int j = 0; j < times.length; ++j) {
                int t = times[j];
                for (int k = 0; k < tsc.times.length; ++k) {
                    if (tsc.times[k] != t) continue;
                    tmpTimes[count] = t;
                    if (tsc.quality != null) {
                        tmpQuality[count] = quality[k];
                    }
                    tmpVals[count++] = values[k];
                    continue block2;
                }
            }
            tsc.times = Arrays.copyOf(tmpTimes, count);
            tsc.values = Arrays.copyOf(tmpVals, count);
            if (tsc.quality != null) {
                tsc.quality = Arrays.copyOf(tmpQuality, count);
            }
            tsc.numberValues = count;
            if (count > 0) {
                HecTime hecTime = new HecTime();
                hecTime.set(tsc.times[0], tsc.timeGranularitySeconds, tsc.julianBaseDate);
                this.setStartTime(hecTime);
                hecTime.set(tsc.times[count - 1], tsc.timeGranularitySeconds, tsc.julianBaseDate);
                this.setEndTime(hecTime);
            }
        }
    }

    @Override
    @Scriptable
    public TimeSeriesContainer expandVerticalDatum() {
        if (!(this instanceof VerticalDatum) && this.supplementalInfo != null && this.supplementalInfo.indexOf("verticalDatumInfo:") != -1) {
            try {
                VerticalDatumContainer vdc = this.extractVerticalDatum();
                TimeSeriesContainerVertDatum expanded = new TimeSeriesContainerVertDatum(this, vdc);
                HashMap<String, String> si = expanded.getSupplementalInfo();
                si.remove("verticalDatumInfo");
                if (si.containsKey("verticalDatum")) {
                    String currentVerticalDatum = si.get("verticalDatum");
                    if (currentVerticalDatum.equals("UNKNOWN")) {
                        LOGGER.warning("The Vertical Datum is '" + currentVerticalDatum + "' Vertical Datum Operation will be skipped");
                    } else {
                        expanded.forceVerticalDatum(currentVerticalDatum);
                    }
                    si.remove("verticalDatum");
                }
                expanded.setSupplementalInfo(si);
                return expanded;
            }
            catch (IOException | RuntimeException | VerticalDatumException e) {
                Logger.getLogger(TimeSeriesContainer.class.getName()).log(Level.SEVERE, "failed to expand TimeSeriesContainer", e);
            }
        }
        return (TimeSeriesContainer)this.clone();
    }

    @Override
    @Scriptable
    public TimeSeriesContainer collapseVerticalDatum() {
        if (this instanceof VerticalDatum) {
            TimeSeriesContainer collapsed = new TimeSeriesContainer();
            this._clone(collapsed);
            try {
                collapsed.insertVerticalDatum(((VerticalDatum)this).getVerticalDatumContainer());
                return collapsed;
            }
            catch (Exception e) {
                Logger.getLogger(TimeSeriesContainer.class.getName()).log(Level.SEVERE, "failed to collapse TimeSeriesContainer", e);
            }
        }
        return (TimeSeriesContainer)this.clone();
    }

    @Scriptable
    public void printToConsole() {
        this.printToConsole(this.numberValues);
    }

    @Scriptable
    public void printToConsole(int maxNumberToPrint) {
        if (this.values == null || this.times == null) {
            return;
        }
        System.out.println("TimeZoneID: " + this.getTimeZoneID());
        System.out.println("ID/Name: " + this.getFullName());
        HecTimeArray times = this.getTimes();
        for (int i = 0; i < this.values.length; ++i) {
            if (i >= maxNumberToPrint) continue;
            System.out.println(times.element(i).dateAndTime() + ", " + this.values[i]);
        }
    }

    public boolean allMissing() {
        if (this.values != null && this.values.length > 0) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == -3.4028234663852886E38) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasValidProfileData() {
        return this.profileValues != null && this.profileDepths != null && this.numberValues > 0 && this.numberValues == this.profileValues.length && this.profileValues[0].length == this.profileDepths.length;
    }

    public void setVersionDate(VersionDate versionDate) {
        this._versionDate = versionDate;
    }

    public VersionDate getVersionDate() {
        return this._versionDate;
    }

    public String getFullVersionedName() {
        StringBuilder sb = new StringBuilder(this.getFullName());
        if (this._versionDate != null) {
            this.appendVersionDate(sb);
        }
        return sb.toString();
    }

    private void appendVersionDate(StringBuilder sb) {
        String versionDate;
        ZoneId zoneId = null;
        if (HecTimeArray.getGlobalViewTimeZone() != null) {
            zoneId = HecTimeArray.getGlobalViewTimeZone().toZoneId();
        }
        if (zoneId == null) {
            zoneId = this.timeZoneID != null ? TimeZone.getTimeZone(this.timeZoneID).toZoneId() : TimeZone.getTimeZone("UTC").toZoneId();
        }
        if (!(versionDate = VersionDateFormatter.format((VersionDate)this._versionDate, (ZoneId)zoneId)).isEmpty()) {
            sb.append(":").append(versionDate);
        }
    }

    public Optional<VerticalDatum> getVerticalDatumMetadata() {
        return Optional.empty();
    }
}

