/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import com.google.common.flogger.FluentLogger;
import hec.data.tx.DSSTimeSeriesUtil;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.io.TimeSeriesContainer;
import java.time.Instant;
import java.time.ZoneId;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.function.Predicate;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.VersionDate;
import mil.army.usace.hec.data.timeseries.adapter.TimeSeriesDataAdapter;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.Duration;
import mil.army.usace.hec.metadata.DurationFactory;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalFactory;
import mil.army.usace.hec.metadata.IntervalOffset;
import mil.army.usace.hec.metadata.LocationID;
import mil.army.usace.hec.metadata.OfficeId;
import mil.army.usace.hec.metadata.Parameter;
import mil.army.usace.hec.metadata.ParameterType;
import mil.army.usace.hec.metadata.Units;
import mil.army.usace.hec.metadata.Version;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifierParts;

final class TimeSeriesContainerAdapter
implements TimeSeriesDataAdapter {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private final String _identifier;
    private final LocationID _locationId;
    private final Parameter _parameter;
    private final ParameterType _parameterType;
    private final Interval _interval;
    private final Duration _duration;
    private final Version _version;
    private final OfficeId _officeId;
    private final VerticalDatum _verticalDatum;
    private final Units _units;
    private final NavigableSet<Instant> _instants;
    private final double[] _values;
    private final Quality _quality;
    private final ZoneId _dataZoneId;
    private final VersionDate _versionDate;

    TimeSeriesContainerAdapter(TimeSeriesContainer container, TimeSeriesIdentifier timeSeriesIdentifier, ZoneId defaultDataZoneId) throws DataSetTimeSeriesException {
        try {
            this._identifier = timeSeriesIdentifier.toString();
            this._locationId = timeSeriesIdentifier.getLocationId();
            this._parameter = timeSeriesIdentifier.getParameter();
            this._parameterType = timeSeriesIdentifier.getParameterType();
            this._interval = timeSeriesIdentifier.getInterval();
            this._duration = TimeSeriesContainerAdapter.extractDuration(this._parameterType, this._interval);
            this._version = timeSeriesIdentifier.getVersion();
            this._officeId = timeSeriesIdentifier.getOfficeId().orElse(null);
            VerticalDatumContainer verticalDatum = null;
            if (container instanceof VerticalDatum) {
                verticalDatum = ((VerticalDatum)container).getVerticalDatumContainer();
            }
            this._verticalDatum = verticalDatum;
            this._units = new Units(container.getUnits());
            this._dataZoneId = Optional.ofNullable(container.getTimeZoneID()).map(TimeZone::getTimeZone).map(TimeZone::toZoneId).orElse(defaultDataZoneId);
            this._instants = TimeSeriesContainerAdapter.initializeTimeArray(container, this._interval, this._dataZoneId);
            this._values = container.getValues();
            Quality quality = null;
            if (container.getQuality() != null) {
                quality = new Quality(container.quality);
            }
            this._quality = quality;
            this._versionDate = container.getVersionDate();
        }
        catch (RuntimeException | DataSetIllegalArgumentException e) {
            throw new DataSetTimeSeriesException((Exception)e);
        }
    }

    TimeSeriesContainerAdapter(TimeSeriesContainer container, ZoneId defaultDataZoneId) throws DataSetTimeSeriesException {
        try {
            this._identifier = container.getFullName();
            this._dataZoneId = Optional.ofNullable(container.getTimeZoneID()).map(TimeZone::getTimeZone).map(TimeZone::toZoneId).orElse(defaultDataZoneId);
            this._locationId = new LocationID(container.getLocationName(), this._dataZoneId);
            this._parameter = new Parameter(container.getParameterName());
            this._parameterType = DSSTimeSeriesUtil.getParameterType(container.getType());
            this._interval = TimeSeriesContainerAdapter.extractInterval(container);
            this._duration = TimeSeriesContainerAdapter.extractDuration(this._parameterType, this._interval);
            this._version = new Version(container.getVersionName());
            this._officeId = null;
            VerticalDatumContainer verticalDatum = null;
            if (container instanceof VerticalDatum) {
                verticalDatum = ((VerticalDatum)container).getVerticalDatumContainer();
            }
            this._verticalDatum = verticalDatum;
            this._units = new Units(container.getUnits());
            this._instants = TimeSeriesContainerAdapter.initializeTimeArray(container, this._interval, this._dataZoneId);
            this._values = container.getValues();
            Quality quality = null;
            int[] containerQuality = container.getQuality();
            if (containerQuality != null) {
                quality = new Quality(containerQuality);
            }
            this._quality = quality;
            this._versionDate = container.getVersionDate();
        }
        catch (RuntimeException | DataSetIllegalArgumentException e) {
            throw new DataSetTimeSeriesException((Exception)e);
        }
    }

    private static Duration extractDuration(ParameterType parameterType, Interval interval) throws DataSetTimeSeriesException {
        Duration duration = parameterType == null || parameterType.isInstantaneous() ? DurationFactory.noDuration() : (Duration)DurationFactory.findAny((Predicate)DurationFactory.equalsName((String)interval.getInterval().replace("~", "").replace("Local", ""))).orElseThrow(() -> new DataSetTimeSeriesException("Could not find matching duration for parameter type: " + parameterType + " and interval: " + interval));
        return duration;
    }

    private static NavigableSet<Instant> initializeTimeArray(TimeSeriesContainer container, Interval interval, ZoneId dataZoneId) throws DataSetIllegalArgumentException {
        TreeSet<Instant> retval = new TreeSet<Instant>();
        HecTimeArray timeArray = container.getTimes();
        HecTime hecTime = timeArray.element(0);
        Instant start = hecTime.getInstant(dataZoneId);
        for (int i = 0; i < container.numberValues; ++i) {
            if (interval.isIrregular()) {
                HecTime nextTime = timeArray.element(i);
                retval.add(nextTime.getInstant(dataZoneId));
                continue;
            }
            retval.add(interval.getNextIntervalTime(start, (long)i, dataZoneId));
        }
        return retval;
    }

    private static Interval extractInterval(TimeSeriesContainer container) throws DataSetTimeSeriesException {
        Interval retval;
        int intervalSeconds = container.getTimeIntervalSeconds();
        String fullName = container.getFullName();
        if (intervalSeconds == 0) {
            try {
                retval = TimeSeriesIdentifierParts.extractInterval((String)fullName, (IntervalOffset)IntervalOffset.noOffset());
            }
            catch (DataSetIllegalArgumentException e) {
                retval = IntervalFactory.irregular();
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atFine()).withCause((Throwable)e)).log("TimeSeriesContainer defined with no interval and could not find interval string from identifier: " + fullName + " defaulting to irregular interval");
            }
        } else {
            DSSPathname dssPathname = new DSSPathname(fullName);
            String interval = dssPathname.getEPart();
            retval = interval.startsWith("~") || interval.endsWith("Local") ? (Interval)IntervalFactory.findAny(IntervalFactory.equalsSeconds((int)intervalSeconds).and(Interval::isLocalRegular)).orElseThrow(() -> new DataSetTimeSeriesException("Cannot find interval from time series container seconds: " + intervalSeconds)) : (Interval)IntervalFactory.findAny(IntervalFactory.equalsSeconds((int)intervalSeconds).and(Interval::isRegular)).orElseThrow(() -> new DataSetTimeSeriesException("Cannot find interval from time series container seconds: " + intervalSeconds));
        }
        return retval;
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public Optional<OfficeId> getOfficeId() {
        return Optional.ofNullable(this._officeId);
    }

    public NavigableSet<Instant> getInstants() {
        return this._instants;
    }

    public double[] getValues() {
        return this._values;
    }

    public Optional<Quality> getQuality() {
        return Optional.ofNullable(this._quality);
    }

    public Units getUnits() {
        return this._units;
    }

    public Parameter getParameter() {
        return this._parameter;
    }

    public ParameterType getParameterType() {
        return this._parameterType;
    }

    public Interval getInterval() {
        return this._interval;
    }

    public Optional<VerticalDatum> getVerticalDatum() {
        return Optional.ofNullable(this._verticalDatum);
    }

    public LocationID getLocationId() {
        return this._locationId;
    }

    public Duration getDuration() {
        return this._duration;
    }

    public Version getVersion() {
        return this._version;
    }

    public ZoneId getDataZoneId() {
        return this._dataZoneId;
    }

    public Optional<VersionDate> getVersionDate() {
        return Optional.ofNullable(this._versionDate);
    }
}

