/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.data.tx.QualityTx;
import hec.hecmath.computation.ComputationException;
import hec.io.TimeSeriesContainer;

public class TimeSeriesContainerAligner {
    protected static int nonAlignedQuality = QualityTx.setMissing_int(0);
    protected int controllingIndex = 0;
    protected int count = 0;
    protected TimeSeriesContainer[] tscs = null;
    protected int[] indicies = null;
    protected boolean[] aligned = null;
    protected boolean hasNext = false;
    protected boolean hasPrevious = false;
    protected boolean hasCurrent = false;

    public TimeSeriesContainerAligner(TimeSeriesContainer ... tscs) throws ComputationException {
        int i;
        if (tscs == null) {
            throw new ComputationException("At least one TimeSeriesContainer must be supplied.");
        }
        this.tscs = tscs;
        this.count = tscs.length;
        for (i = 0; i < this.count; ++i) {
            if (tscs[i] != null) continue;
            throw new ComputationException("All TimeSeriesContainers must not be null.");
        }
        this.indicies = new int[this.count];
        this.aligned = new boolean[this.count];
        for (i = 0; i < this.count; ++i) {
            this.aligned[i] = false;
            this.indicies[i] = -1;
        }
        this.alignFirst();
    }

    public void setControllingIndex(int index) {
        this.controllingIndex = index;
    }

    public void alignFirst() {
        int i;
        for (i = 0; i < this.count; ++i) {
            this.indicies[i] = 0;
        }
        int referenceTime = this.tscs[this.controllingIndex].times[0];
        for (i = 0; i < this.count; ++i) {
            while (this.tscs[i].times[this.indicies[i]] < referenceTime && this.indicies[i] < this.tscs[i].numberValues - 1) {
                int n = i;
                this.indicies[n] = this.indicies[n] + 1;
            }
            this.aligned[i] = this.tscs[i].times[this.indicies[i]] == referenceTime;
        }
        this.setBoundaryFlags();
    }

    public void alignLast() {
        int i;
        for (i = 0; i < this.count; ++i) {
            this.indicies[i] = this.tscs[i].numberValues - 1;
        }
        int referenceTime = this.tscs[this.controllingIndex].times[this.tscs[this.controllingIndex].numberValues - 1];
        for (i = 0; i < this.count; ++i) {
            while (this.tscs[i].times[this.indicies[i]] > referenceTime && this.indicies[i] > 0) {
                int n = i;
                this.indicies[n] = this.indicies[n] - 1;
            }
            this.aligned[i] = this.tscs[i].times[this.indicies[i]] == referenceTime;
        }
        this.setBoundaryFlags();
    }

    public void alignNext() {
        int n = this.controllingIndex;
        this.indicies[n] = this.indicies[n] + 1;
        if (this.indicies[this.controllingIndex] < this.tscs[this.controllingIndex].numberValues) {
            int referenceTime = this.tscs[this.controllingIndex].times[this.indicies[this.controllingIndex]];
            for (int i = 0; i < this.count; ++i) {
                while (this.tscs[i].times[this.indicies[i]] > referenceTime && this.indicies[i] > 0) {
                    int n2 = i;
                    this.indicies[n2] = this.indicies[n2] - 1;
                }
                while (this.tscs[i].times[this.indicies[i]] < referenceTime && this.indicies[i] < this.tscs[i].numberValues - 1) {
                    int n3 = i;
                    this.indicies[n3] = this.indicies[n3] + 1;
                }
                this.aligned[i] = this.tscs[i].times[this.indicies[i]] == referenceTime;
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                this.indicies[i] = this.tscs[i].numberValues;
                this.aligned[i] = false;
            }
        }
        this.setBoundaryFlags();
    }

    public void alignPrevious() {
        int n = this.controllingIndex;
        this.indicies[n] = this.indicies[n] - 1;
        if (this.indicies[this.controllingIndex] >= 0) {
            int referenceTime = this.tscs[this.controllingIndex].times[this.indicies[this.controllingIndex]];
            for (int i = 0; i < this.count; ++i) {
                while (this.tscs[i].times[this.indicies[i]] < referenceTime && this.indicies[i] < this.tscs[i].numberValues - 1) {
                    int n2 = i;
                    this.indicies[n2] = this.indicies[n2] + 1;
                }
                while (this.tscs[i].times[this.indicies[i]] > referenceTime && this.indicies[i] > 0) {
                    int n3 = i;
                    this.indicies[n3] = this.indicies[n3] - 1;
                }
                this.aligned[i] = this.tscs[i].times[this.indicies[i]] == referenceTime;
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                this.indicies[i] = -1;
                this.aligned[i] = false;
            }
        }
        this.setBoundaryFlags();
    }

    public void align(int index) {
        this.indicies[this.controllingIndex] = index;
        int referenceTime = this.tscs[this.controllingIndex].times[index];
        for (int i = 0; i < this.count; ++i) {
            while (this.tscs[i].times[this.indicies[i]] > referenceTime && this.indicies[i] > 0) {
                int n = i;
                this.indicies[n] = this.indicies[n] - 1;
            }
            while (this.tscs[i].times[this.indicies[i]] < referenceTime && this.indicies[i] < this.tscs[i].numberValues - 1) {
                int n = i;
                this.indicies[n] = this.indicies[n] + 1;
            }
            this.aligned[i] = this.tscs[i].times[this.indicies[i]] == referenceTime;
        }
        this.setBoundaryFlags();
    }

    public int getCount() {
        return this.count;
    }

    public int getAlignedCount() {
        int alignedCount = 0;
        for (int i = 0; i < this.count; ++i) {
            if (!this.aligned[i]) continue;
            ++alignedCount;
        }
        return alignedCount;
    }

    public boolean aligned(int i) {
        return this.aligned[i];
    }

    public int getIndex(int i) {
        return this.indicies[i];
    }

    public int getTime() {
        return this.aligned[this.controllingIndex] ? this.tscs[this.controllingIndex].times[this.indicies[this.controllingIndex]] : Integer.MIN_VALUE;
    }

    public double getValue(int i) {
        return this.aligned[i] ? this.tscs[i].values[this.indicies[i]] : -3.4028234663852886E38;
    }

    public int getQuality(int i) {
        return this.aligned[i] ? (this.tscs[i].quality == null ? 0 : this.tscs[i].quality[this.indicies[i]]) : nonAlignedQuality;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public boolean hasPrevious() {
        return this.hasPrevious;
    }

    public boolean hasCurrent() {
        return this.hasCurrent;
    }

    public TimeSeriesContainer getTsc(int i) {
        return this.tscs[i];
    }

    protected void setBoundaryFlags() {
        boolean hasNext = true;
        boolean hasPrevious = true;
        boolean hasCurrent = true;
        for (int i = 0; i < this.count; ++i) {
            if (this.indicies[i] == 0) {
                hasPrevious = false;
            }
            if (this.indicies[i] == this.tscs[i].numberValues - 1) {
                hasNext = false;
            }
            if (this.indicies[i] >= 0 && this.indicies[i] < this.tscs[i].numberValues) continue;
            hasCurrent = false;
        }
        this.hasNext = hasNext;
        this.hasPrevious = hasPrevious;
        this.hasCurrent = hasCurrent;
    }
}

