/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.data.tx.DSSTimeSeriesUtil;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerAdapter;
import hec.io.TimeSeriesContainerVertDatum;
import java.time.Instant;
import java.time.ZoneId;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.TimeZone;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.adapter.TimeSeriesAdapter;
import mil.army.usace.hec.data.timeseries.adapter.TimeSeriesDataAdapter;
import mil.army.usace.hec.data.timeseries.adapter.TimeSeriesDataConverter;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumException;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesException;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import rma.services.annotations.ServiceProvider;

public final class TimeSeriesContainerFactory {
    private TimeSeriesContainerFactory() {
        throw new AssertionError((Object)"Utility class");
    }

    public static TimeSeries toTimeSeries(TimeSeriesContainer timeSeriesContainer, TimeSeriesIdentifier identifier) throws DataSetTimeSeriesException {
        if (timeSeriesContainer.getTimeZoneID() == null) {
            throw new DataSetTimeSeriesException("Cannot convert TimeSeriesContainer to TimeSeries without a data time zone: " + timeSeriesContainer.getFullVersionedName());
        }
        ZoneId zoneId = TimeZone.getTimeZone(timeSeriesContainer.getTimeZoneID()).toZoneId();
        return (TimeSeries)TimeSeriesDataConverter.convert((TimeSeriesDataAdapter)new TimeSeriesContainerAdapter(timeSeriesContainer, identifier, zoneId), TimeSeries.class);
    }

    public static TimeSeries toTimeSeries(TimeSeriesContainer timeSeriesContainer, TimeSeriesIdentifier identifier, ZoneId defaultDataZoneId) throws DataSetTimeSeriesException {
        return (TimeSeries)TimeSeriesDataConverter.convert((TimeSeriesDataAdapter)new TimeSeriesContainerAdapter(timeSeriesContainer, identifier, defaultDataZoneId), TimeSeries.class);
    }

    public static TimeSeries toTimeSeries(TimeSeriesContainer timeSeriesContainer) throws DataSetTimeSeriesException {
        if (timeSeriesContainer.getTimeZoneID() == null) {
            throw new DataSetTimeSeriesException("Cannot convert TimeSeriesContainer to TimeSeries without a data time zone: " + timeSeriesContainer.getFullVersionedName());
        }
        ZoneId zoneId = TimeZone.getTimeZone(timeSeriesContainer.getTimeZoneID()).toZoneId();
        return (TimeSeries)TimeSeriesDataConverter.convert((TimeSeriesDataAdapter)new TimeSeriesContainerAdapter(timeSeriesContainer, zoneId), TimeSeries.class);
    }

    public static TimeSeries toTimeSeries(TimeSeriesContainer timeSeriesContainer, ZoneId defaultDataZoneId) throws DataSetTimeSeriesException {
        return (TimeSeries)TimeSeriesDataConverter.convert((TimeSeriesDataAdapter)new TimeSeriesContainerAdapter(timeSeriesContainer, defaultDataZoneId), TimeSeries.class);
    }

    public static TimeSeriesContainer toTimeSeriesContainer(TimeSeries timeSeries) throws DataSetTimeSeriesException {
        return (TimeSeriesContainer)TimeSeriesDataConverter.convert((TimeSeriesDataAdapter)new TimeSeriesAdapter(timeSeries), TimeSeriesContainer.class);
    }

    @ServiceProvider(service=TimeSeriesDataConverter.class)
    public static final class TimeSeriesContainerConverter
    implements TimeSeriesDataConverter<TimeSeriesContainer> {
        public boolean canConvertTo(Class<?> destinationType) {
            return destinationType.isAssignableFrom(TimeSeriesContainer.class);
        }

        public TimeSeriesContainer convert(TimeSeriesDataAdapter adapter) throws DataSetTimeSeriesIllegalArgumentException {
            try {
                TimeSeriesContainer tsc = new TimeSeriesContainer();
                tsc.setFullName(adapter.getIdentifier());
                tsc.location = adapter.getLocationId().getBaseLocation();
                tsc.subLocation = adapter.getLocationId().getSubLocation();
                tsc.parameter = adapter.getParameter().getBaseParameter();
                tsc.subParameter = adapter.getParameter().getSubParameter();
                tsc.version = adapter.getVersion().toString();
                tsc.interval = adapter.getInterval().getMinutes();
                tsc.setType(DSSTimeSeriesUtil.getDSSType(adapter.getParameter(), adapter.getParameterType()));
                ZoneId zoneId = adapter.getDataZoneId();
                tsc.setTimeZoneID(zoneId.getId());
                double[] values = adapter.getValues();
                if (values.length > 0) {
                    HecTimeArray hecTimes = new HecTimeArray(values.length);
                    NavigableSet times = adapter.getInstants();
                    double[] tscValues = new double[values.length];
                    int i = 0;
                    for (Instant instant : times) {
                        tscValues[i] = values[i];
                        hecTimes.set(i, HecTime.fromInstant(instant, zoneId));
                        ++i;
                    }
                    tsc.set(tscValues, hecTimes);
                    adapter.getQuality().map(Quality::getIntQuality).ifPresent(tsc::setQuality);
                    tsc.setStartTime(HecTime.fromInstant((Instant)times.first(), zoneId));
                    tsc.setEndTime(HecTime.fromInstant((Instant)times.last(), zoneId));
                }
                tsc.numberValues = values.length;
                tsc.setUnits(adapter.getUnits().toString());
                adapter.getVersionDate().ifPresent(tsc::setVersionDate);
                Optional verticalDatum = adapter.getVerticalDatum();
                if (verticalDatum.isPresent()) {
                    tsc = new TimeSeriesContainerVertDatum(tsc, ((VerticalDatum)verticalDatum.get()).getVerticalDatumContainer());
                }
                return tsc;
            }
            catch (RuntimeException | VerticalDatumException e) {
                throw new DataSetTimeSeriesIllegalArgumentException(e);
            }
        }
    }
}

