/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.TimeSeriesContainer;
import java.util.Vector;

public class TimeSeriesContainerTimeZoneCheck {
    public static void checkTimezone(Vector containers) {
        int i;
        boolean sameTimeZone = true;
        int timezoneOffset = -1;
        String tz = null;
        for (i = 0; i < containers.size(); ++i) {
            Object obj = containers.get(i);
            if (!(obj instanceof TimeSeriesContainer)) {
                return;
            }
            TimeSeriesContainer tsc = (TimeSeriesContainer)containers.get(i);
            if (tsc.timeZoneID == null || tsc.timeZoneID.equals("")) continue;
            if (timezoneOffset == -1) {
                timezoneOffset = tsc.timeZoneRawOffset;
                tz = tsc.timeZoneID;
                continue;
            }
            if (timezoneOffset == tsc.timeZoneRawOffset) continue;
            sameTimeZone = false;
            break;
        }
        if (!sameTimeZone) {
            for (i = 0; i < containers.size(); ++i) {
                TimeSeriesContainer tsc = (TimeSeriesContainer)containers.get(i);
                if (tsc.timeZoneID == null || tsc.timeZoneID.equals("") || timezoneOffset == tsc.timeZoneRawOffset) continue;
                int diff = timezoneOffset - tsc.timeZoneRawOffset;
                tsc.startTime += (diff /= 60000);
                tsc.endTime += diff;
                int jd = 0;
                while (jd < tsc.times.length) {
                    int n = jd++;
                    tsc.times[n] = tsc.times[n] + diff;
                }
                tsc.timeZoneID = tz;
                tsc.timeZoneRawOffset = timezoneOffset;
            }
        }
    }
}

