/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.data.Units;
import hec.data.UnitsConversionException;
import hec.io.DataContainer;
import hec.io.TimeSeriesContainer;
import hec.util.TextUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.VerticalDatumException;

public class TimeSeriesContainerVertDatum
extends TimeSeriesContainer
implements VerticalDatum {
    private static final long serialVersionUID = 322335104291176837L;
    protected VerticalDatumContainer vdc = null;

    public TimeSeriesContainerVertDatum() {
    }

    public TimeSeriesContainerVertDatum(TimeSeriesContainer tsc) {
        if (tsc != null) {
            tsc.clone(this);
        }
    }

    public TimeSeriesContainerVertDatum(TimeSeriesContainer tsc, VerticalDatumContainer vdc) throws VerticalDatumException {
        if (tsc != null) {
            tsc.clone(this);
        }
        if (vdc != null) {
            this.vdc = vdc.clone();
        }
        this.initFromVdc();
    }

    public TimeSeriesContainerVertDatum(VerticalDatumContainer vdc) throws VerticalDatumException {
        if (vdc != null) {
            this.vdc = vdc.clone();
        }
    }

    @Override
    public Object clone() {
        TimeSeriesContainerVertDatum tscvd = new TimeSeriesContainerVertDatum();
        super.clone(tscvd);
        if (this.vdc != null) {
            if (tscvd.vdc == null) {
                tscvd.vdc = new VerticalDatumContainer();
            }
            this.vdc.clone(tscvd.vdc);
        }
        return tscvd;
    }

    @Override
    public void clone(TimeSeriesContainer tsc) {
        if (tsc instanceof TimeSeriesContainerVertDatum) {
            super.clone(tsc);
            if (this.vdc != null) {
                TimeSeriesContainerVertDatum tscvd = (TimeSeriesContainerVertDatum)tsc;
                if (tscvd.vdc == null) {
                    tscvd.vdc = new VerticalDatumContainer();
                }
                this.vdc.clone(tscvd.vdc);
            }
        } else {
            this.collapseVerticalDatum().clone(tsc);
        }
    }

    public String getNativeVerticalDatum() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this.vdc.getNativeVerticalDatum();
    }

    public String getCurrentVerticalDatum() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this.vdc.getCurrentVerticalDatum();
    }

    public boolean isCurrentVerticalDatumEstimated() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this.vdc.isCurrentVerticalDatumEstimated();
    }

    public boolean toNativeVerticalDatum() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        double offset = this.vdc.getCurrentOffset(this.units);
        boolean change = this.vdc.toNativeVerticalDatum();
        if (change) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == -3.4028234663852886E38) continue;
                int n = i;
                this.values[n] = this.values[n] - offset;
            }
            this.initFromVdc();
        }
        return change;
    }

    public boolean toNGVD29() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        double offset = this.vdc.getNGVD29Offset(this.units) - this.vdc.getCurrentOffset(this.units);
        boolean change = this.vdc.toNGVD29();
        if (change) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == -3.4028234663852886E38) continue;
                int n = i;
                this.values[n] = this.values[n] + offset;
            }
            this.initFromVdc();
        }
        return change;
    }

    public boolean toNAVD88() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        double offset = this.vdc.getNAVD88Offset(this.units) - this.vdc.getCurrentOffset(this.units);
        boolean change = this.vdc.toNAVD88();
        if (change) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == -3.4028234663852886E38) continue;
                int n = i;
                this.values[n] = this.values[n] + offset;
            }
            this.initFromVdc();
        }
        return change;
    }

    public boolean toVerticalDatum(String datum) throws VerticalDatumException {
        if (datum == null) {
            throw new VerticalDatumException("Null datum specified");
        }
        double offset1 = this.vdc.getCurrentOffset(this.units);
        boolean change = this.vdc.toVerticalDatum(datum);
        if (change) {
            double offset2 = this.vdc.getCurrentOffset(this.units);
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == -3.4028234663852886E38) continue;
                int n = i;
                this.values[n] = this.values[n] + (offset2 - offset1);
            }
        }
        return change;
    }

    public boolean forceVerticalDatum(String datum) throws VerticalDatumException {
        if (datum == null) {
            throw new VerticalDatumException("Null datum specified");
        }
        return this.vdc.forceVerticalDatum(datum);
    }

    public double getCurrentOffset() throws VerticalDatumException {
        return this.getCurrentOffset(this.units);
    }

    public double getCurrentOffset(String unit) throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this.vdc.getCurrentOffset(unit);
    }

    public double getNGVD29Offset() throws VerticalDatumException {
        return this.getNGVD29Offset(this.units);
    }

    public double getNGVD29Offset(String unit) throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this.vdc.getNGVD29Offset(unit);
    }

    public double getNAVD88Offset() throws VerticalDatumException {
        return this.getNAVD88Offset(this.units);
    }

    public double getNAVD88Offset(String unit) throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this.vdc.getNAVD88Offset(unit);
    }

    public boolean isNGVD29OffsetEstimated() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this.vdc.isNGVD29OffsetEstimated();
    }

    public boolean isNAVD88OffsetEstimated() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this.vdc.isNAVD88OffsetEstimated();
    }

    public String getVerticalDatumInfo() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this.vdc.getVerticalDatumInfo();
    }

    public void setVerticalDatumInfo(String xmlStr) throws VerticalDatumException {
        this.checkParameter();
        if (this.vdc == null) {
            this.vdc = new VerticalDatumContainer();
        }
        this.vdc.setVerticalDatumInfo(xmlStr);
        this.initFromVdc();
    }

    public void setVerticalDatumContainer(VerticalDatumContainer vdc) throws VerticalDatumException {
        this.vdc = vdc == null ? vdc : vdc.clone();
        this.initFromVdc();
    }

    public void convertVerticalDatumUnits(String strUnit) {
        if (this.vdc != null && this.vdc.unit != null && strUnit != null && Units.canConvertBetweenUnits(this.vdc.unit, strUnit)) {
            try {
                this.vdc.elevation = Units.convertUnits(this.vdc.elevation, this.vdc.unit, strUnit);
                this.vdc.navd88Offset = Units.convertUnits(this.vdc.navd88Offset, this.vdc.unit, strUnit);
                this.vdc.ngvd29Offset = Units.convertUnits(this.vdc.ngvd29Offset, this.vdc.unit, strUnit);
                this.vdc.unit = strUnit;
            }
            catch (UnitsConversionException e) {
                Logger.getLogger(TimeSeriesContainerVertDatum.class.getName()).log(Level.WARNING, "Unable to convert vertical units from from: " + this.vdc.unit + " to: " + strUnit, e);
            }
        }
    }

    public static boolean isCorrectParameter(String pm) {
        return pm != null && pm.toUpperCase().startsWith("ELEV");
    }

    private void checkParameter() throws VerticalDatumException {
        if (!TimeSeriesContainerVertDatum.isCorrectParameter(this.parameter)) {
            throw new VerticalDatumException("Parameter must be an elevation");
        }
    }

    private void checkVerticalDatumContainer() throws VerticalDatumException {
        if (this.vdc == null) {
            throw new VerticalDatumException("VerticalDatumContainer has not been initialized");
        }
    }

    private void initFromVdc() throws VerticalDatumException {
        if (this.vdc == null || !TimeSeriesContainerVertDatum.isCorrectParameter(this.parameter)) {
            this.setVerticalDatum(DataContainer.VERTICAL_DATUM.UNSET);
            this.setVerticalUnits(DataContainer.VERTICAL_UNITS.UNSET);
        } else {
            if (this.vdc.currentDatum == null) {
                this.setVerticalDatum(DataContainer.VERTICAL_DATUM.UNSET);
            } else {
                this.setVerticalDatum(this.vdc.currentDatum);
            }
            if (this.vdc.unit == null) {
                this.setVerticalUnits(DataContainer.VERTICAL_UNITS.UNSET);
            } else {
                this.setVerticalUnits(this.vdc.unit);
            }
        }
    }

    @Override
    public VerticalDatumContainer extractVerticalDatum() throws VerticalDatumException, IOException {
        String vdi;
        if (this.vdc != null) {
            return this.vdc.clone();
        }
        HashMap<String, String> si = this.getSupplementalInfo();
        if (si.containsKey("verticalDatumInfo") && (vdi = si.get("verticalDatumInfo")) != null) {
            return new VerticalDatumContainer(TextUtil.uncompress(vdi, "base64"));
        }
        return null;
    }

    @Override
    public void insertVerticalDatum(VerticalDatumContainer vdc) throws IOException {
        this.vdc = vdc.clone();
        HashMap<String, String> si = this.getSupplementalInfo();
        if (si.containsKey("verticalDatumInfo")) {
            si.remove("verticalDatumInfo");
            this.setSupplementalInfo(si);
        }
    }

    public VerticalDatumContainer getVerticalDatumContainer() {
        return this.vdc;
    }

    @Override
    public final Optional<VerticalDatum> getVerticalDatumMetadata() {
        return Optional.ofNullable(this.getVerticalDatumContainer());
    }
}

