/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.heclib.util.HecTime;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.TimeZone;

public class TimeSeriesRetrieveSpec {
    protected HecTime startTime = new HecTime();
    protected HecTime endTime = new HecTime();
    protected String units = null;
    protected String timeZone = null;
    protected boolean trim = true;
    protected boolean startTimeInclusive = true;
    protected boolean endTimeInclusive = true;
    protected boolean getPrevious = false;
    protected boolean getNext = false;
    protected HecTime versionTime = new HecTime();
    protected boolean maxVersion = true;
    protected transient TimeZone tz = TimeZone.getTimeZone("UTC");
    protected transient String exclusiveStartTime = "";
    protected transient String exclusiveEndTime = "";
    protected transient Timestamp startTimestamp = new Timestamp(0L);
    protected transient Timestamp endTimestamp = new Timestamp(0L);
    protected transient Timestamp versionTimestamp = null;
    protected transient HecTime tmpTime = new HecTime();

    public TimeSeriesRetrieveSpec() {
    }

    public TimeSeriesRetrieveSpec(TimeSeriesRetrieveSpec other) {
        this.startTime.set(other.startTime);
        this.endTime.set(other.endTime);
        this.versionTime.set(other.versionTime);
        this.units = other.units;
        this.trim = other.trim;
        this.startTimeInclusive = other.startTimeInclusive;
        this.endTimeInclusive = other.endTimeInclusive;
        this.getPrevious = other.getPrevious;
        this.getNext = other.getNext;
        this.maxVersion = other.maxVersion;
        this.timeZone(other.timeZone);
    }

    protected void setStartTimeInfo() {
        this.tmpTime.set(this.startTime);
        this.tmpTime.addMinutes(1);
        this.exclusiveStartTime = this.tmpTime.dateAndTime(104);
        this.startTimestamp.setTime(this.startTime.getTimeInMillis(this.tz.getOffset(this.startTime.getTimeInMillis()) / 60000));
    }

    protected void setEndTimeInfo() {
        this.tmpTime.set(this.endTime);
        this.tmpTime.subtractMinutes(1);
        this.exclusiveEndTime = this.tmpTime.dateAndTime(104);
        this.endTimestamp.setTime(this.endTime.getTimeInMillis(this.tz.getOffset(this.endTime.getTimeInMillis()) / 60000));
    }

    protected void setVersionTimeInfo() {
        if (this.versionTime.isDefined()) {
            long millis = this.versionTime.getTimeInMillis(this.tz.getOffset(this.versionTime.getTimeInMillis()) / 60000);
            if (this.versionTimestamp == null) {
                this.versionTimestamp = new Timestamp(millis);
            } else {
                this.versionTimestamp.setTime(millis);
            }
        } else {
            this.versionTimestamp = null;
        }
    }

    public String startTime() {
        if (!this.startTime.isDefined()) {
            throw new IllegalArgumentException("Start time is undefined");
        }
        return this.startTime.dateAndTime(104);
    }

    public TimeSeriesRetrieveSpec startTime(String startTime) {
        this.startTime.set(startTime);
        this.setStartTimeInfo();
        return this;
    }

    public Timestamp startTimestamp() {
        if (!this.startTime.isDefined()) {
            throw new IllegalArgumentException("Start time is undefined");
        }
        return this.startTimestamp;
    }

    public String exclusiveStartTime() {
        if (!this.startTime.isDefined()) {
            throw new IllegalArgumentException("Start time is undefined");
        }
        return this.exclusiveStartTime;
    }

    public String endTime() {
        if (!this.endTime.isDefined()) {
            throw new IllegalArgumentException("End time is undefined");
        }
        return this.endTime.dateAndTime(104);
    }

    public TimeSeriesRetrieveSpec endTime(String endTime) {
        this.endTime.set(endTime);
        this.setEndTimeInfo();
        return this;
    }

    public Timestamp endTimestamp() {
        if (!this.endTime.isDefined()) {
            throw new IllegalArgumentException("End time is undefined");
        }
        return this.endTimestamp;
    }

    public String exclusiveEndTime() {
        if (!this.endTime.isDefined()) {
            throw new IllegalArgumentException("End time is undefined");
        }
        return this.exclusiveEndTime;
    }

    public String units() {
        return this.units;
    }

    public TimeSeriesRetrieveSpec units(String units) {
        this.units = units;
        return this;
    }

    public String timeZone() {
        return this.timeZone;
    }

    public TimeSeriesRetrieveSpec timeZone(String timeZone) {
        if (!Arrays.asList(TimeZone.getAvailableIDs()).contains(timeZone)) {
            throw new IllegalArgumentException("Unknown time zone: " + timeZone);
        }
        this.tz = TimeZone.getTimeZone(timeZone);
        this.timeZone = timeZone;
        this.setStartTimeInfo();
        this.setEndTimeInfo();
        this.setVersionTimeInfo();
        return this;
    }

    public int timeZoneRawOffset() {
        return this.tz.getRawOffset();
    }

    public boolean trim() {
        return this.trim;
    }

    public TimeSeriesRetrieveSpec trim(boolean trim) {
        this.trim = trim;
        return this;
    }

    public boolean startTimeInclusive() {
        return this.startTimeInclusive;
    }

    public TimeSeriesRetrieveSpec startTimeInclusive(boolean startTimeInclusive) {
        this.startTimeInclusive = startTimeInclusive;
        return this;
    }

    public boolean endTimeInclusive() {
        return this.endTimeInclusive;
    }

    public TimeSeriesRetrieveSpec endTimeInclusive(boolean endTimeInclusive) {
        this.endTimeInclusive = endTimeInclusive;
        return this;
    }

    public boolean getPrevious() {
        return this.getPrevious;
    }

    public TimeSeriesRetrieveSpec getPrevious(boolean getPrevious) {
        this.getPrevious = getPrevious;
        return this;
    }

    public boolean getNext() {
        return this.getNext;
    }

    public TimeSeriesRetrieveSpec getNext(boolean getNext) {
        this.getNext = getNext;
        return this;
    }

    public String versionTime() {
        return this.versionTime.dateAndTime(104);
    }

    public TimeSeriesRetrieveSpec versionTime(String versionTime) {
        this.versionTime.set(versionTime);
        this.setVersionTimeInfo();
        return this;
    }

    public Timestamp versionTimestamp() {
        return this.versionTimestamp;
    }

    public boolean maxVersion() {
        return this.maxVersion;
    }

    public TimeSeriesRetrieveSpec maxVersion(boolean maxVersion) {
        this.maxVersion = maxVersion;
        return this;
    }
}

