/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.io.DataContainer;
import java.io.Serializable;
import java.util.Arrays;

public class TinContainer
extends DataContainer
implements Cloneable,
Serializable {
    public String SpatialReferenceSystem;
    public int SRSType;
    public static final int UNKNOWN_SRS_DEFINITION_TYPE = -1;
    public static final int WKT_ESRI_SRS_DEFINITION_TYPE = 0;
    public static final int WKT_OGC_SRS_DEFINITION_TYPE = 1;
    public String SRSName;
    public String SRSUnits;
    public String units;
    public String type;
    public String timeZoneName;
    public int numberPoints;
    public double slendernessRatio;
    public double[] xCoordinate;
    public double[] yCoordinate;
    public double[] value;
    public int[] pointType;
    public static final int DCP_VERTEX = 0;
    public static final int OBSERVER_GAGE_VERTEX = 1;
    public static final int GRID_CELL_VERTEX = 2;
    public int[][] connection;
    public String[] label;
    public double minXCoordinate;
    public double minYCoordinate;
    public double maxXCoordinate;
    public double maxYCoordinate;
    public double minValue;
    public double maxValue;
    public double meanValue;

    public TinContainer() {
        this.slendernessRatio = -3.4028234663852886E38;
        this.numberPoints = 0;
        this.SpatialReferenceSystem = "";
        this.SRSType = -1;
        this.SRSName = "";
        this.SRSUnits = "";
        this.type = "";
        this.units = "";
        this.timeZoneName = "";
        this.slendernessRatio = -3.4028234663852886E38;
        this.minXCoordinate = -3.4028234663852886E38;
        this.minYCoordinate = -3.4028234663852886E38;
        this.maxXCoordinate = -3.4028234663852886E38;
        this.maxYCoordinate = -3.4028234663852886E38;
        this.minValue = -3.4028234663852886E38;
        this.maxValue = -3.4028234663852886E38;
        this.meanValue = -3.4028234663852886E38;
    }

    public TinContainer(double[] xs, double[] ys, double[] vs) {
        this.SRSType = -1;
        if (xs.length == ys.length && xs.length == vs.length) {
            this.numberPoints = xs.length;
            this.xCoordinate = xs;
            this.yCoordinate = ys;
            this.value = vs;
        }
    }

    public void clone(TinContainer tc) {
        int i;
        super.clone(tc);
        tc.SpatialReferenceSystem = new String(this.SpatialReferenceSystem);
        tc.SRSType = this.SRSType;
        tc.SRSName = new String(this.SRSName);
        tc.SRSUnits = new String(this.SRSUnits);
        tc.units = new String(this.units);
        tc.type = new String(this.type);
        tc.timeZoneName = new String(this.timeZoneName);
        tc.numberPoints = this.numberPoints;
        tc.slendernessRatio = this.slendernessRatio;
        if (this.xCoordinate != null) {
            tc.xCoordinate = Arrays.copyOf(this.xCoordinate, this.numberPoints);
        }
        if (this.yCoordinate != null) {
            tc.yCoordinate = Arrays.copyOf(this.yCoordinate, this.numberPoints);
        }
        if (this.value != null) {
            tc.value = Arrays.copyOf(this.value, this.numberPoints);
        }
        if (this.pointType != null) {
            tc.pointType = Arrays.copyOf(this.pointType, this.numberPoints);
        }
        if (this.connection != null) {
            tc.connection = new int[this.numberPoints][];
            for (i = 0; i < this.numberPoints; ++i) {
                tc.connection[i] = Arrays.copyOf(this.connection[i], this.connection[i].length);
            }
        }
        if (this.label != null) {
            tc.label = new String[this.numberPoints];
            for (i = 0; i < this.numberPoints; ++i) {
                if (this.label[i].isEmpty()) continue;
                tc.label[i] = new String(this.label[i]);
            }
        }
        tc.minXCoordinate = this.minXCoordinate;
        tc.minYCoordinate = this.minYCoordinate;
        tc.maxXCoordinate = this.maxXCoordinate;
        tc.maxYCoordinate = this.maxYCoordinate;
        tc.minValue = this.minValue;
        tc.maxValue = this.maxValue;
        tc.meanValue = this.meanValue;
    }

    public double[] getBounds() {
        if (this.numberPoints > 0 && (Double.compare(this.minXCoordinate, -3.4028234663852886E38) == 0 || Double.compare(this.minYCoordinate, -3.4028234663852886E38) == 0 || Double.compare(this.maxXCoordinate, -3.4028234663852886E38) == 0 || Double.compare(this.maxYCoordinate, -3.4028234663852886E38) == 0)) {
            this.updateStatistics();
        }
        double[] result = new double[]{this.minXCoordinate, this.minYCoordinate, this.maxXCoordinate, this.maxYCoordinate};
        return result;
    }

    public boolean getTimeWindow(HecTime startTime, HecTime endTime) {
        startTime.setUndefined();
        endTime.setUndefined();
        if (this.fullName == null) {
            return false;
        }
        if (this.fullName.length() < 5) {
            return false;
        }
        DSSPathname path = new DSSPathname(this.fullName);
        if (path.dPart().length() < 3) {
            return false;
        }
        startTime.set(path.dPart());
        if (!startTime.isDateDefined()) {
            return false;
        }
        if (path.ePart().length() < 3) {
            return true;
        }
        endTime.set(path.ePart());
        return false;
    }

    public double getMaxValue() {
        if (this.maxValue == -3.4028234663852886E38 && this.numberPoints > 0) {
            this.updateStatistics();
        }
        return this.maxValue;
    }

    public double getMinValue() {
        if (this.minValue == -3.4028234663852886E38 && this.numberPoints > 0) {
            this.updateStatistics();
        }
        return this.minValue;
    }

    public double getMeanValue() {
        if (this.meanValue == -3.4028234663852886E38 && this.numberPoints > 0) {
            this.updateStatistics();
        }
        return this.meanValue;
    }

    public void updateStatistics() {
        if (this.numberPoints == 0) {
            this.minXCoordinate = -3.4028234663852886E38;
            this.minYCoordinate = -3.4028234663852886E38;
            this.maxXCoordinate = -3.4028234663852886E38;
            this.maxYCoordinate = -3.4028234663852886E38;
            this.minValue = -3.4028234663852886E38;
            this.maxValue = -3.4028234663852886E38;
            this.meanValue = -3.4028234663852886E38;
            return;
        }
        double sum = -3.4028234663852886E38;
        int numberNull = 0;
        int numValidLoc = 0;
        for (int i = 0; i < this.numberPoints; ++i) {
            if (Double.compare(this.value[i], -3.4028234663852886E38) != 0 && this.connection[i].length > 1) {
                if (Double.compare(sum, -3.4028234663852886E38) == 0) {
                    sum = this.value[i];
                    this.minValue = this.value[i];
                    this.maxValue = this.value[i];
                }
                sum += this.value[i];
                if (this.value[i] < this.minValue) {
                    this.minValue = this.value[i];
                }
                if (this.value[i] > this.maxValue) {
                    this.maxValue = this.value[i];
                }
            } else {
                ++numberNull;
            }
            if (Double.compare(this.xCoordinate[i], -3.4028234663852886E38) == 0 || Double.compare(this.xCoordinate[i], -3.4028234663852886E38) == 0 || Double.isNaN(this.xCoordinate[i]) || Double.isNaN(this.yCoordinate[i])) continue;
            if (numValidLoc == 0) {
                this.minXCoordinate = this.xCoordinate[i];
                this.minYCoordinate = this.yCoordinate[i];
                this.maxXCoordinate = this.xCoordinate[i];
                this.maxYCoordinate = this.yCoordinate[i];
            } else {
                if (this.xCoordinate[i] < this.minXCoordinate) {
                    this.minXCoordinate = this.xCoordinate[i];
                }
                if (this.yCoordinate[i] < this.minYCoordinate) {
                    this.minYCoordinate = this.yCoordinate[i];
                }
                if (this.xCoordinate[i] > this.maxXCoordinate) {
                    this.maxXCoordinate = this.xCoordinate[i];
                }
                if (this.yCoordinate[i] > this.maxYCoordinate) {
                    this.maxYCoordinate = this.yCoordinate[i];
                }
            }
            ++numValidLoc;
        }
        this.meanValue = sum / (double)(this.numberPoints - numberNull);
    }

    private static String PointTypeName(int pointType) {
        if (pointType == 0) {
            return "DCP_VERTEX";
        }
        if (pointType == 1) {
            return "OBSERVER_GAGE_VERTEX";
        }
        if (pointType == 2) {
            return "GRID_CELL_VERTEX";
        }
        return "UNKNOWN";
    }

    protected static String pointToString(TinContainer c2, int i) {
        double[] x = c2.xCoordinate;
        double[] y = c2.yCoordinate;
        double[] z = c2.value;
        int[] pt = c2.pointType;
        StringBuilder sb = new StringBuilder();
        String s = i + String.format(" [%.2f, %.2f]=%.2f", x[i], y[i], z[i]);
        sb.append(s);
        if (pt != null) {
            sb.append(" " + TinContainer.PointTypeName(pt[i]));
        }
        sb.append(" '" + c2.label[i] + "'");
        sb.append(" connection {");
        for (int j = 0; j < c2.connection[i].length; ++j) {
            sb.append(c2.connection[i][j] + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String toString() {
        TinContainer c2 = this;
        StringBuffer sb = new StringBuffer();
        sb.append("numberPoints :" + c2.numberPoints + "\n");
        sb.append("numberPointLabels :" + c2.label.length + "\n");
        sb.append("SRSType :" + c2.SRSType + "   (0 = WKT)\n");
        sb.append("slendernessRatio :" + c2.slendernessRatio + "\n");
        sb.append("minXCoordinate :" + String.format("%.3f", c2.minXCoordinate) + "\n");
        sb.append("minYCoordinate :" + String.format("%.3f", c2.minYCoordinate) + "\n");
        sb.append("maxXCoordinate :" + String.format("%.3f", c2.maxXCoordinate) + "\n");
        sb.append("maxYCoordinate :" + String.format("%.3f", c2.maxYCoordinate) + "\n");
        sb.append("minValue :" + String.format("%.3f", c2.getMinValue()) + "\n");
        sb.append("maxValue :" + String.format("%.3f", c2.getMaxValue()) + "\n");
        sb.append("meanValue :" + String.format("%.3f", c2.getMeanValue()) + "\n");
        sb.append("SpatialReferenceSystem :" + c2.SpatialReferenceSystem + "\n");
        sb.append("SRSName :" + c2.SRSName + "\n");
        sb.append("maxValue :" + c2.maxValue + "\n");
        sb.append("SRSUnits :" + c2.SRSUnits + "\n");
        sb.append("units :" + c2.units + "\n");
        sb.append("type :" + c2.type + "\n");
        sb.append("timeZoneName :" + c2.timeZoneName + "\n");
        sb.append("number of connections :" + c2.connection.length + "\n");
        sb.append("First 10 points: \n");
        double[] x = c2.xCoordinate;
        double[] y = c2.yCoordinate;
        double[] z = c2.value;
        int[] pt = c2.pointType;
        for (int i = 0; i < c2.yCoordinate.length && i <= 9; ++i) {
            sb.append(TinContainer.pointToString(c2, i) + "\n");
        }
        return sb.toString();
    }
}

