/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

import hec.io.HecFile;
import hec.io.TopologyFileEntry;
import hec.lang.ApplicationProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import rma.util.GetOpt;
import rma.util.RMAIO;

public class TopologyFile {
    public static final String HOST_IP = "hostip";
    public static final String HOST_NAME = "host.name";
    public static final String HOST_USERID = "host.userid";
    public static final String HOST_COOP_TYPE = "host.coop.type";
    public static final String HOST_STARTUP_STATE = "host.startup.state";
    public static final String CWMS_SYSTEM_TYPE = "cwms.system.type";
    public static final String HOST_COOP_SERVER_PORT = "host.coop.server.port";
    public static final String REMOTESERVER_COOP_HOSTIP = "remoteserver.coop.hostip";
    public static final String END_HOST = "endhost";
    public static final String END_FILE = "endfile";
    public static final String PRIMARY_HOST_TYPE = "primary";
    public static final String COOP_HOST_TYPE = "coop";
    public static final String DB_SYS_TYPE = "DB";
    public static final String DA_SYS_TYPE = "DA";
    public static final String MODELING_SYS_TYPE = "MO";
    public static final String ACTIVE = "active";
    public static final String STANDBY = "standby";
    protected static final String[] FILE_ENTRIES = new String[]{"hostip", "host.name", "host.userid", "host.coop.type", "host.startup.state", "cwms.system.type", "host.coop.server.port", "remoteserver.coop.hostip"};
    private Map _hostMap = new LinkedHashMap();
    private long _lastModifiedTime;
    private HecFile _file;

    public TopologyFile() {
        this.load();
    }

    public TopologyFile(HecFile file) {
        this._file = file;
        this.load(file.getBufferedReader());
    }

    public File getTopologyFile() {
        String appHome = ApplicationProperties.getAppHome();
        String topFileStr = appHome + TopologyFile.getLastPathPart();
        File topoFile = new File(topFileStr);
        if (!topoFile.exists()) {
            System.out.println("getTopologyFile: No topology file found at " + topoFile);
            return null;
        }
        return topoFile;
    }

    public void reload(boolean force) {
        File topoFile;
        if (this._file == null) {
            topoFile = this.getTopologyFile();
            if (topoFile == null) {
                return;
            }
        } else {
            topoFile = (File)((Object)this._file);
        }
        if (!force) {
            long lastMod = topoFile.lastModified();
            if (lastMod > this._lastModifiedTime) {
                if (this._file == null) {
                    this.load();
                } else {
                    this.load(this._file.getBufferedReader());
                }
            } else {
                System.out.println("reload: no changes found in topology file");
            }
        } else if (this._file == null) {
            this.load();
        } else {
            this.load(this._file.getBufferedReader());
        }
    }

    protected void load() {
        File topoFile = this.getTopologyFile();
        if (topoFile == null) {
            return;
        }
        this._lastModifiedTime = topoFile.lastModified();
        System.out.println("load: reading " + topoFile.getAbsolutePath());
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(topoFile));
            this.load(reader);
        }
        catch (IOException ioe) {
            System.out.println("load: ERROR opening topology file " + topoFile.getAbsolutePath() + " Error:" + ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load(BufferedReader reader) {
        try {
            String line;
            TopologyFileEntry entry = null;
            this._hostMap.clear();
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                String type = RMAIO.getType(line, "=");
                String param = RMAIO.getParam(line, "=");
                if (HOST_IP.equalsIgnoreCase(type)) {
                    entry = new TopologyFileEntry(param);
                    if (this._hostMap.get(param) != null) {
                        System.out.println("load:WARNING duplicate entry for host " + param);
                    }
                    this._hostMap.put(param, entry);
                    continue;
                }
                if (HOST_NAME.equalsIgnoreCase(type)) {
                    entry.name = param;
                    continue;
                }
                if (HOST_USERID.equalsIgnoreCase(type)) {
                    entry.userId = param;
                    continue;
                }
                if (HOST_COOP_TYPE.equalsIgnoreCase(type)) {
                    entry.coopType = param;
                    continue;
                }
                if (HOST_STARTUP_STATE.equalsIgnoreCase(type)) {
                    entry.startupState = param;
                    continue;
                }
                if (CWMS_SYSTEM_TYPE.equalsIgnoreCase(type)) {
                    entry.systemType = param;
                    continue;
                }
                if (HOST_COOP_SERVER_PORT.equalsIgnoreCase(type)) {
                    entry.coopServerPort = RMAIO.parseInt(param, -1);
                    continue;
                }
                if (REMOTESERVER_COOP_HOSTIP.equalsIgnoreCase(type)) {
                    entry.remoteIp = param;
                    continue;
                }
                if (END_HOST.equalsIgnoreCase(type)) {
                    entry = null;
                    continue;
                }
                if (!END_FILE.equalsIgnoreCase(type)) continue;
                break;
            }
        }
        catch (Exception ex) {
            System.out.println("load: ERROR reading topology file. Error:" + ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    System.out.println("load: IOError closing topology file " + ioe);
                }
            }
        }
        this.validateEntries();
    }

    private void validateEntries() {
        Collection entries = this._hostMap.values();
        ArrayList<String> hostNames = new ArrayList<String>(entries.size());
        for (TopologyFileEntry entry : entries) {
            if (hostNames.contains(entry.name)) {
                System.out.println("validateEntries: duplicate host names " + entry);
            } else {
                hostNames.add(entry.name);
            }
            if (TopologyFile.isPrimaryHost(entry) && this._hostMap.get(entry.remoteIp) == null) {
                System.out.println("validateEntries: No Entry found for remoteserver.coop.hostip=" + entry.remoteIp + " for Entry " + entry);
            }
            if (TopologyFile.isCoopHost(entry) && entry.systemType != null) {
                System.out.println("validateEntries: COOP host " + entry + " has system type set. Ignoring System type");
                entry.systemType = null;
            }
            if (TopologyFile.isCoopHost(entry)) {
                TopologyFileEntry entry2 = this.getPrimaryHostForCoop(entry);
                if (entry2 == null) {
                    System.out.println("validateEntries: Failed to find Primary host for COOP host " + entry);
                } else {
                    entry.systemType = entry2.systemType;
                    entry.remoteIp = entry2.ipAddress;
                    if (entry2.startupState.equalsIgnoreCase(entry.startupState)) {
                        System.out.println("validateEntries: both coop host (" + entry + ") and primary host (" + entry2 + ") have same startup state " + entry2.startupState);
                    }
                }
            }
            if (!TopologyFile.isValidSystemType(entry)) {
                System.out.println("validateEntries: invalid system type " + entry.systemType + " for Host " + entry);
            }
            if (entry.isValid()) continue;
            System.out.println("validateEntries: invalid Entry:");
            System.out.println(entry.paramString());
        }
    }

    public List getLocalHosts(TopologyFileEntry entry) {
        return this.getLocalHosts(entry, true);
    }

    public List getLocalHosts(TopologyFileEntry entry, boolean returnEntry) {
        List<TopologyFileEntry> sisterHosts = null;
        if (entry == null) {
            return new ArrayList(0);
        }
        sisterHosts = TopologyFile.isCoopHost(entry) ? this.getCoopHosts() : this.getPrimaryHosts();
        if (sisterHosts != null && !returnEntry) {
            sisterHosts.remove(entry);
        } else if (sisterHosts == null && returnEntry) {
            sisterHosts = new ArrayList<TopologyFileEntry>(1);
            sisterHosts.add(entry);
        }
        return sisterHosts;
    }

    public List getRemoteHosts(TopologyFileEntry entry) {
        List remoteHosts = null;
        remoteHosts = TopologyFile.isCoopHost(entry) ? this.getPrimaryHosts() : this.getCoopHosts();
        return remoteHosts;
    }

    public List getPrimaryHosts() {
        ArrayList<TopologyFileEntry> primaryHosts = new ArrayList<TopologyFileEntry>();
        Collection entries = this._hostMap.values();
        for (TopologyFileEntry entry : entries) {
            if (!TopologyFile.isPrimaryHost(entry)) continue;
            primaryHosts.add(entry);
        }
        return primaryHosts;
    }

    public List getCoopHosts() {
        ArrayList<TopologyFileEntry> coopHosts = new ArrayList<TopologyFileEntry>();
        Collection entries = this._hostMap.values();
        for (TopologyFileEntry entry : entries) {
            if (!TopologyFile.isCoopHost(entry)) continue;
            coopHosts.add(entry);
        }
        return coopHosts;
    }

    public static boolean isValidSystemType(TopologyFileEntry entry) {
        if (entry == null) {
            return true;
        }
        String sysType = entry.systemType;
        StringTokenizer tokenizer = new StringTokenizer(sysType, ",");
        while (tokenizer.hasMoreTokens()) {
            String type = tokenizer.nextToken().trim();
            if (DB_SYS_TYPE.equalsIgnoreCase(type) || DA_SYS_TYPE.equalsIgnoreCase(type) || MODELING_SYS_TYPE.equalsIgnoreCase(type)) continue;
            return false;
        }
        return true;
    }

    public TopologyFileEntry getPrimaryHostForCoop(TopologyFileEntry coopEntry) {
        if (coopEntry == null) {
            return null;
        }
        String coopEntryIp = coopEntry.ipAddress;
        if (coopEntryIp == null) {
            return null;
        }
        Collection entries = this._hostMap.values();
        for (TopologyFileEntry entry : entries) {
            if (!coopEntryIp.equals(entry.remoteIp)) continue;
            coopEntry.remoteIp = entry.ipAddress;
            return entry;
        }
        System.out.println("getPrimaryHostForCoop: no Primary Host found for Coop host " + coopEntry);
        return null;
    }

    public static boolean isPrimaryHost(TopologyFileEntry entry) {
        if (entry == null) {
            return false;
        }
        return PRIMARY_HOST_TYPE.equalsIgnoreCase(entry.coopType);
    }

    public static boolean isCoopHost(TopologyFileEntry entry) {
        if (entry == null) {
            return false;
        }
        return COOP_HOST_TYPE.equalsIgnoreCase(entry.coopType);
    }

    public TopologyFileEntry getMasterEntry() {
        Collection entries = this._hostMap.values();
        if (entries.size() > 0) {
            return (TopologyFileEntry)entries.iterator().next();
        }
        return null;
    }

    public TopologyFileEntry getEntryForIP(String ipAddress) {
        if (ipAddress == null) {
            return null;
        }
        TopologyFileEntry entry = (TopologyFileEntry)this._hostMap.get(ipAddress);
        if (entry == null) {
            System.out.println("getEntryForIP: No entry found for IP " + ipAddress);
        }
        return entry;
    }

    public TopologyFileEntry getEntryForName(String name) {
        if (name == null) {
            return null;
        }
        Collection entries = this._hostMap.values();
        for (TopologyFileEntry entry : entries) {
            if (!name.equalsIgnoreCase(entry.name)) continue;
            return entry;
        }
        System.out.println("getEntryForName: no entry found for " + name);
        return null;
    }

    static void printUsage() {
        System.err.println("USAGE: TopologyFile [-f]");
        System.err.println("\t-f full dump\n");
        System.err.println("Will read and validate the Topology File in " + ApplicationProperties.getAppHome() + TopologyFile.getLastPathPart());
    }

    public static void main(String[] args) {
        int opt;
        GetOpt go = new GetOpt(args, "-fl");
        boolean fullDump = false;
        boolean localInfo = false;
        while ((opt = go.getopt()) != -1) {
            char ch = (char)opt;
            if (ch == 'f') {
                fullDump = true;
                continue;
            }
            if (ch == 'l') {
                localInfo = true;
                continue;
            }
            TopologyFile.printUsage();
            System.exit(10);
        }
        TopologyFile file = new TopologyFile();
        if (localInfo) {
            InetAddress ia = null;
            try {
                ia = InetAddress.getLocalHost();
                String ipAddress = ia.getHostAddress();
                TopologyFileEntry entry = file.getEntryForIP(ipAddress);
                if (entry == null) {
                    System.out.println("TopologyFile: ERROR No Entry found for " + ipAddress + " in TopologyFile " + file.getTopologyFile().getPath());
                    System.exit(1);
                } else {
                    System.out.println("\nLocal Host Info:");
                    System.out.println(entry.paramString());
                }
            }
            catch (UnknownHostException e) {
                System.out.println("TopologyFile: ERROR getting local IP Address from System " + e);
                System.exit(2);
            }
        }
        if (fullDump || !localInfo) {
            int i;
            TopologyFileEntry master = file.getMasterEntry();
            if (master != null) {
                System.out.println("\nMaster host is:\n" + master.paramString());
            }
            List hosts = file.getLocalHosts(master);
            for (i = 0; i < hosts.size(); ++i) {
                System.out.println("Localhost(" + (i + 1) + "):" + (fullDump ? ((TopologyFileEntry)hosts.get(i)).paramString() : hosts.get(i)));
            }
            hosts = file.getRemoteHosts(master);
            for (i = 0; i < hosts.size(); ++i) {
                System.out.println("RemoteHost(" + (i + 1) + "):" + (fullDump ? ((TopologyFileEntry)hosts.get(i)).paramString() : hosts.get(i)));
            }
        }
        System.exit(0);
    }

    public static String getLastPathPart() {
        return "/config/properties/topology.conf";
    }
}

