/*
 * Decompiled with CFR 0.152.
 */
package hec.io;

public class TopologyFileEntry
implements Cloneable {
    String ipAddress;
    String name;
    String userId;
    String coopType;
    String startupState;
    String systemType;
    int coopServerPort = -1;
    String remoteIp;

    TopologyFileEntry(String ip) {
        this.ipAddress = ip;
    }

    public int getCoopServerPort() {
        return this.coopServerPort;
    }

    public String getCoopType() {
        return this.coopType;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getName() {
        return this.name;
    }

    public String getRemoteIp() {
        return this.remoteIp;
    }

    public String getStartupState() {
        return this.startupState;
    }

    public String getSystemType() {
        return this.systemType;
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean isPrimarySite() {
        return this.coopType.equalsIgnoreCase("primary");
    }

    public boolean isDASystem() {
        return this.systemType.toUpperCase().indexOf("DA") > -1;
    }

    public boolean isDBSystem() {
        return this.systemType.toUpperCase().indexOf("DB") > -1;
    }

    public boolean isModelingSystem() {
        return this.systemType.toUpperCase().indexOf("MO") > -1;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            System.out.println("clone exception " + ex);
            return null;
        }
    }

    public boolean isValid() {
        return this.ipAddress != null && this.name != null && this.userId != null && this.coopType != null && this.startupState != null && this.coopServerPort != -1 && this.remoteIp != null;
    }

    public String toString() {
        return this.ipAddress;
    }

    public String paramString() {
        StringBuffer buf = new StringBuffer();
        buf.append("hostip");
        buf.append("=");
        buf.append(this.ipAddress);
        buf.append("\n");
        buf.append("host.name");
        buf.append("=");
        buf.append(this.name);
        buf.append("\n");
        buf.append("host.userid");
        buf.append("=");
        buf.append(this.userId);
        buf.append("\n");
        buf.append("host.coop.type");
        buf.append("=");
        buf.append(this.coopType);
        buf.append("\n");
        buf.append("host.startup.state");
        buf.append("=");
        buf.append(this.startupState);
        buf.append("\n");
        buf.append("cwms.system.type");
        buf.append("=");
        buf.append(this.systemType);
        buf.append("\n");
        buf.append("host.coop.server.port");
        buf.append("=");
        buf.append(this.coopServerPort);
        buf.append("\n");
        buf.append("remoteserver.coop.hostip");
        buf.append("=");
        buf.append(this.remoteIp);
        buf.append("\n");
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TopologyFileEntry) {
            return this.equals((TopologyFileEntry)obj);
        }
        return false;
    }

    public boolean equals(TopologyFileEntry that) {
        if (this == that) {
            return true;
        }
        return that.ipAddress.equals(this.ipAddress);
    }

    public int hashCode() {
        return this.ipAddress.hashCode();
    }
}

