/*
 * Decompiled with CFR 0.152.
 */
package hec.io.dbf;

import hec.io.EndianInputStream;
import hec.io.dbf.DBFFieldDescriptor;
import hec.io.dbf.DBFHeader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public abstract class AbstractDBFHeader
implements DBFHeader {
    static final long serialVersionUID = 3215625181395825024L;
    public static final int FIELD_DESCRIPTOR_SIZE = 32;
    public static final int FIELD_DESCRIPTOR_OFFSET = 32;
    private static final int PREHEADER_SIZE = 32;
    protected byte[] _header = null;
    protected int _headerSize = 33;
    protected int _recordSize = 1;
    protected int _numRecords = 0;
    protected List _fieldDescriptors = new ArrayList();

    @Override
    public int getHeaderSize() {
        return this._headerSize;
    }

    @Override
    public int getNumRecords() {
        return this._numRecords;
    }

    @Override
    public int getRecordSize() {
        return this._recordSize;
    }

    @Override
    public void deleteFieldDescriptor(int pos) {
        if (pos < 0 || pos >= this._fieldDescriptors.size()) {
            return;
        }
        DBFFieldDescriptor fd = (DBFFieldDescriptor)this._fieldDescriptors.remove(pos);
        this._headerSize -= 32;
        this._recordSize -= fd.fieldSize;
    }

    @Override
    public void deleteFieldDescriptor(String name) {
        for (int i = 0; i < this._fieldDescriptors.size(); ++i) {
            DBFFieldDescriptor fd = (DBFFieldDescriptor)this._fieldDescriptors.get(i);
            if (!name.equals(fd.fieldName)) continue;
            this.deleteFieldDescriptor(i);
            return;
        }
    }

    @Override
    public void resizeFieldDescriptor(int newSize, int pos) {
        if (pos < 0 || pos >= this._fieldDescriptors.size() + 1) {
            return;
        }
        DBFFieldDescriptor fd = (DBFFieldDescriptor)this._fieldDescriptors.get(pos);
        int oldSize = fd.fieldSize;
        fd.fieldSize = newSize;
        this._recordSize += fd.fieldSize - oldSize;
    }

    @Override
    public void insertFieldDescriptor(DBFFieldDescriptor fd, int pos) {
        if (pos < 0 || pos >= this._fieldDescriptors.size() + 1) {
            this._fieldDescriptors.add(fd);
        } else {
            this._fieldDescriptors.add(pos, fd);
        }
        this._headerSize += 32;
        this._recordSize += fd.fieldSize;
    }

    @Override
    public List getFieldDescriptors() {
        return Collections.unmodifiableList(this._fieldDescriptors);
    }

    @Override
    public String[] getFieldNames() {
        String[] names = new String[this._fieldDescriptors.size()];
        for (int ii = 0; ii < this._fieldDescriptors.size(); ++ii) {
            DBFFieldDescriptor fd = (DBFFieldDescriptor)this._fieldDescriptors.get(ii);
            names[ii] = fd.getFieldName();
        }
        return names;
    }

    @Override
    public DBFFieldDescriptor getFieldDescriptor(int pos) {
        if (pos < 0 || pos >= this._fieldDescriptors.size() + 1) {
            return null;
        }
        return (DBFFieldDescriptor)this._fieldDescriptors.get(pos);
    }

    @Override
    public DBFFieldDescriptor getFieldDescriptor(String fieldName) {
        for (int ii = 0; ii < this._fieldDescriptors.size(); ++ii) {
            DBFFieldDescriptor fieldDescriptor = (DBFFieldDescriptor)this._fieldDescriptors.get(ii);
            if (!fieldDescriptor.getFieldName().equalsIgnoreCase(fieldName)) continue;
            return fieldDescriptor;
        }
        return null;
    }

    @Override
    public int getNumDescriptors() {
        return this._fieldDescriptors.size();
    }

    @Override
    public boolean readHeader(EndianInputStream reader) {
        if (!this.readPreHeader(reader)) {
            return false;
        }
        return this.readFieldDescriptors(reader);
    }

    protected boolean readPreHeader(EndianInputStream reader) {
        if (reader == null) {
            return false;
        }
        byte[] preHeader = new byte[32];
        try {
            int bytesRead = reader.read(preHeader, 0, 32);
            if (bytesRead != 32) {
                return false;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: Exception occurred in reading header");
            System.out.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
        this._numRecords = (preHeader[7] & 0xFF) << 24 | (preHeader[6] & 0xFF) << 16 | (preHeader[5] & 0xFF) << 8 | preHeader[4] & 0xFF;
        this._headerSize = (preHeader[9] & 0xFF) << 8 | preHeader[8] & 0xFF;
        this._recordSize = (preHeader[11] & 0xFF) << 8 | preHeader[10] & 0xFF;
        int POSTHEADER_SIZE = this._headerSize - 32;
        byte[] postHeader = new byte[POSTHEADER_SIZE];
        try {
            int bytesRead = reader.read(postHeader, 0, POSTHEADER_SIZE);
            if (bytesRead != POSTHEADER_SIZE) {
                return false;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: Exception occurred in reading header");
            System.out.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
        this._header = new byte[POSTHEADER_SIZE + 32];
        System.arraycopy(preHeader, 0, this._header, 0, 32);
        System.arraycopy(postHeader, 0, this._header, 32, POSTHEADER_SIZE);
        return true;
    }

    protected boolean readFieldDescriptors(EndianInputStream reader) {
        int nFieldDescr = (this._headerSize - 32 - 1) / 32;
        int position = 32;
        for (int i = 0; i < nFieldDescr; ++i) {
            int n;
            for (n = position; n < position + 32 && this._header[n] != 0; ++n) {
            }
            DBFFieldDescriptor dbfDc = new DBFFieldDescriptor();
            dbfDc.fieldName = new String(this._header, position, n - position);
            dbfDc.fieldType = (char)this._header[position + 11];
            dbfDc.fieldDataAddress = this._header[position + 12] << 24 | this._header[position + 13] << 16 | this._header[position + 14] << 8 | this._header[position + 15];
            dbfDc.fieldSize = this._header[position + 16] & 0xFF;
            dbfDc.numDecimal = this._header[position + 17] & 0xFF;
            dbfDc.multiUserRes = (short)((this._header[position + 18] & 0xFF) << 8 | this._header[position + 19] & 0xFF);
            dbfDc.workID = this._header[position + 20];
            dbfDc.multiUserRes2 = (short)((this._header[position + 21] & 0xFF) << 8 | this._header[position + 22] & 0xFF);
            dbfDc.setFieldsFlag = this._header[position + 23];
            for (int k = 24; k < 31; ++k) {
                dbfDc.reserved[k - 24] = this._header[position + k];
            }
            dbfDc.indexFld = this._header[position + 31];
            this._fieldDescriptors.add(dbfDc);
            position += 32;
        }
        if (this._header[position] != 13) {
            System.out.println("ERROR: Did not find field descriptor terminator");
            return false;
        }
        return true;
    }

    protected void fillPreHeaderByteArray(byte[] headerBytes) {
        if (this._header != null) {
            System.arraycopy(this._header, 0, headerBytes, 0, 32);
        } else {
            headerBytes[0] = this.getDbaseVersionCode();
            Date currentDate = new Date();
            GregorianCalendar c2 = new GregorianCalendar();
            int year = c2.get(1) - 1900;
            int day = c2.get(5);
            int month = c2.get(2) + 1;
            headerBytes[1] = (byte)year;
            headerBytes[2] = (byte)month;
            headerBytes[3] = (byte)day;
        }
        headerBytes[4] = (byte)(this._numRecords & 0xFF);
        headerBytes[5] = (byte)((this._numRecords & 0xFF00) >> 8);
        headerBytes[6] = (byte)((this._numRecords & 0xFF0000) >> 16);
        headerBytes[7] = (byte)((this._numRecords & 0xFF000000) >> 24);
        headerBytes[8] = (byte)(this._headerSize & 0xFF);
        headerBytes[9] = (byte)((this._headerSize & 0xFF00) >> 8);
        headerBytes[10] = (byte)(this._recordSize & 0xFF);
        headerBytes[11] = (byte)((this._recordSize & 0xFF00) >> 8);
    }

    public abstract byte getDbaseVersionCode();

    @Override
    public byte[] getByteArray() {
        int numFieldDescriptors = this._fieldDescriptors.size();
        byte[] headerBytes = new byte[32 + numFieldDescriptors * 32 + 1];
        this.fillPreHeaderByteArray(headerBytes);
        int bytepos = 32;
        for (int i = 0; i < this._fieldDescriptors.size(); ++i) {
            int offset;
            DBFFieldDescriptor fd = (DBFFieldDescriptor)this._fieldDescriptors.get(i);
            System.arraycopy(fd.fieldName.getBytes(), 0, headerBytes, bytepos, fd.fieldName.length());
            headerBytes[bytepos + 11] = (byte)(fd.fieldType & 0xFF);
            headerBytes[bytepos + 12] = (byte)((fd.fieldDataAddress & 0xFF000000) >> 24);
            headerBytes[bytepos + 13] = (byte)((fd.fieldDataAddress & 0xFF0000) >> 16);
            headerBytes[bytepos + 14] = (byte)((fd.fieldDataAddress & 0xFF00) >> 8);
            headerBytes[bytepos + 15] = (byte)(fd.fieldDataAddress & 0xFF);
            headerBytes[bytepos + 16] = (byte)(fd.fieldSize & 0xFF);
            headerBytes[bytepos + 17] = (byte)(fd.numDecimal & 0xFF);
            headerBytes[bytepos + 18] = (byte)((fd.multiUserRes & 0xFF00) >> 8);
            headerBytes[bytepos + 19] = (byte)(fd.multiUserRes & 0xFF);
            headerBytes[bytepos + 20] = fd.workID;
            headerBytes[bytepos + 21] = (byte)((fd.multiUserRes2 & 0xFF00) >> 8);
            headerBytes[bytepos + 22] = (byte)(fd.multiUserRes2 & 0xFF);
            headerBytes[bytepos + 23] = fd.setFieldsFlag;
            for (int k = offset = 24; k < 31; ++k) {
                headerBytes[bytepos + k] = fd.reserved[k - offset];
            }
            headerBytes[bytepos + 31] = fd.indexFld;
            bytepos += 32;
        }
        headerBytes[headerBytes.length - 1] = 13;
        return headerBytes;
    }
}

