/*
 * Decompiled with CFR 0.152.
 */
package hec.io.dbf;

import hec.io.EndianInputStream;
import hec.io.dbf.DBFFieldDescriptor;
import hec.io.dbf.DBFHeader;
import hec.io.dbf.DBaseUpdate;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public abstract class AbstractDBaseUpdate
implements DBaseUpdate {
    DataOutputStream _newDBaseFileStream = null;
    EndianInputStream _oldDBaseFileStream = null;
    File _oldDBFile = null;
    File _newDBFile = null;
    boolean[] _columnsToRemove = null;
    boolean[] _columnsToAdd = null;
    boolean[] _columnsToResize = null;
    protected DBFFieldDescriptor[] _fdList;
    protected DBFHeader _header = null;

    public AbstractDBaseUpdate(File newFile, File oldFile, boolean[] columsToRemove, boolean[] columnsToAdd, boolean[] columnsToResize, DBFFieldDescriptor[] fdList) {
        this._newDBFile = newFile;
        this._oldDBFile = oldFile;
        this._columnsToAdd = columnsToAdd;
        this._columnsToRemove = columsToRemove;
        this._columnsToResize = columnsToResize;
        this._fdList = fdList;
        try {
            FileInputStream fis = new FileInputStream(this._oldDBFile);
            this._oldDBaseFileStream = new EndianInputStream(fis);
        }
        catch (Exception e) {
            System.out.println("ERROR:");
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        try {
            FileOutputStream fos = new FileOutputStream(this._newDBFile);
            this._newDBaseFileStream = new DataOutputStream(fos);
        }
        catch (Exception e) {
            System.out.println("ERROR: Error Creating output stream for new DB file");
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public boolean runUpdate() {
        return true;
    }

    protected boolean readHeader() {
        if (this._oldDBaseFileStream == null) {
            System.out.println("ERROR: No file handle to old DBF FIE");
            return false;
        }
        return this._header.readHeader(this._oldDBaseFileStream);
    }
}

