/*
 * Decompiled with CFR 0.152.
 */
package hec.io.dbf;

import java.io.Serializable;

public class DBFFieldDescriptor
implements Serializable {
    static final long serialVersionUID = 6700521680276037364L;
    public String fieldName;
    public String fieldDescription;
    public char fieldType;
    public int fieldDataAddress;
    public int fieldSize;
    public int numDecimal;
    public short multiUserRes;
    public byte workID;
    public short multiUserRes2;
    public byte setFieldsFlag;
    public byte[] reserved = new byte[7];
    public byte indexFld;
    private int recordOffset;

    public DBFFieldDescriptor() {
    }

    public DBFFieldDescriptor(String fName, char fType, int fSize, int nDecimal) {
        this(fName, null, fType, fSize, nDecimal);
    }

    public DBFFieldDescriptor(String fName, String fDesc, char fType, int fSize, int nDecimal) {
        this.fieldName = fName.toUpperCase();
        this.fieldDescription = fDesc;
        if (this.fieldName.length() > 10) {
            this.fieldName = this.fieldName.substring(0, 10);
            System.err.println("WARNING <DBFFieldDescriptor.INIT> : Field name," + fName + " , is greater than 10 characters.  Truncating to 10 characters. This may pose a problem if this");
            System.err.println("substring matches another field name!");
        }
        this.fieldType = fType;
        this.numDecimal = nDecimal;
        if (fType == 'M') {
            this.fieldSize = 10;
            this.numDecimal = 0;
        } else if (fType == 'L') {
            this.fieldSize = 1;
            this.numDecimal = 0;
        } else if (fType == 'D') {
            this.fieldSize = 8;
            this.numDecimal = 0;
        } else {
            if (fSize < 0) {
                throw new IllegalArgumentException("ERROR <DBFFieldDescriptor.<init>> : Invalid field size.  Size cannot be less than 0");
            }
            this.fieldSize = fSize;
        }
    }

    public String toString() {
        return this.fieldName;
    }

    public boolean equals(DBFFieldDescriptor fd) {
        if (fd == null) {
            return false;
        }
        return fd.fieldName.equals(this.fieldName) && fd.fieldType == this.fieldType && (fd.fieldSize == this.fieldSize && fd.numDecimal == this.numDecimal || this.fieldType == 'M' || this.fieldType == 'L');
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldDescription() {
        return this.fieldDescription;
    }

    public char getFieldType() {
        return this.fieldType;
    }

    public int getFieldSize() {
        return this.fieldSize;
    }

    public int getNumDecimal() {
        return this.numDecimal;
    }

    public void setFieldName(String name) {
        this.fieldName = name.toUpperCase();
    }

    public void setRecordOffset(int recordOffset) {
        this.recordOffset = recordOffset;
    }

    public int getRecordOffset() {
        return this.recordOffset;
    }
}

