/*
 * Decompiled with CFR 0.152.
 */
package hec.io.dbf;

import hec.io.dbf.AbstractDBaseUpdate;
import hec.io.dbf.DBFFieldDescriptor;
import hec.io.dbf.DBaseIVMemoHeader;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;

public class DBaseIVMemoUpdate
extends AbstractDBaseUpdate {
    Vector _oldDescriptors = null;
    int _oldRecordSize = 0;

    public DBaseIVMemoUpdate(File newFile, File oldFile, boolean[] columnsToRemove, boolean[] columnsToAdd, boolean[] columnsToResize, DBFFieldDescriptor[] newFdList) {
        super(newFile, oldFile, columnsToRemove, columnsToAdd, columnsToResize, newFdList);
        this._header = new DBaseIVMemoHeader();
    }

    @Override
    public boolean runUpdate() {
        if (!this.readHeader()) {
            System.out.println("ERROR: Could not read DBF Pre-Header");
            return false;
        }
        this.updateHeader();
        this.updateRecords();
        this._oldDescriptors.removeAllElements();
        try {
            this._oldDBaseFileStream.close();
            this._newDBaseFileStream.flush();
            this._newDBaseFileStream.close();
        }
        catch (Exception e) {
            System.err.println("ERROR: Error closing file streams to new and old DBF files");
            System.err.println(e.getMessage());
            return false;
        }
        return true;
    }

    private void updateHeader() {
        DBFFieldDescriptor fd;
        int i;
        this._oldDescriptors = new Vector(this._header.getNumDescriptors());
        this._oldRecordSize = this._header.getRecordSize();
        if (this._newDBaseFileStream == null) {
            System.out.println("ERROR: Cannot update the header information with a NULL output stream");
            return;
        }
        for (i = 0; i < this._header.getNumDescriptors(); ++i) {
            fd = ((DBaseIVMemoHeader)this._header).getFieldDescriptor(i);
            this._oldDescriptors.addElement(new DBFFieldDescriptor(fd.fieldName, fd.fieldType, fd.fieldSize, fd.numDecimal));
        }
        for (i = this._columnsToResize.length - 1; i >= 0; --i) {
            if (!this._columnsToResize[i]) continue;
            this._header.resizeFieldDescriptor(this._fdList[i].fieldSize, i);
        }
        for (i = this._columnsToRemove.length - 1; i >= 0; --i) {
            if (!this._columnsToRemove[i]) continue;
            fd = ((DBaseIVMemoHeader)this._header).getFieldDescriptor(i);
            this._header.deleteFieldDescriptor(fd.getFieldName());
        }
        for (i = 0; i < this._fdList.length; ++i) {
            if (i >= this._columnsToAdd.length) {
                return;
            }
            if (!this._columnsToAdd[i]) continue;
            this._header.insertFieldDescriptor(this._fdList[i], i);
        }
        byte[] header = this._header.getByteArray();
        try {
            this._newDBaseFileStream.write(header, 0, header.length);
        }
        catch (IOException e) {
            System.out.println("ERROR: An Exception occurred when writing new header information");
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void updateRecords() {
        byte[] record = new byte[this._oldRecordSize];
        byte[] newRecord = new byte[this._header.getRecordSize()];
        if (this._newDBaseFileStream.size() < this._header.getHeaderSize()) {
            this.updateHeader();
        }
        int nBytesRead = 0;
        int numRecBytes = this._oldRecordSize;
        try {
            while (record[0] != 26) {
                int length;
                DBFFieldDescriptor oldFd;
                int i;
                nBytesRead = this._oldDBaseFileStream.read(record, 0, record.length);
                if (nBytesRead != record.length || record[0] == 26) {
                    this._newDBaseFileStream.write(record, 0, nBytesRead);
                    continue;
                }
                numRecBytes = nBytesRead;
                int recPos = 0;
                ++recPos;
                for (i = 0; i < this._oldDescriptors.size(); ++i) {
                    oldFd = (DBFFieldDescriptor)this._oldDescriptors.elementAt(i);
                    if (this._columnsToRemove[i]) {
                        length = record.length - (recPos + oldFd.fieldSize);
                        System.arraycopy(record, recPos + oldFd.fieldSize, record, recPos, length);
                        numRecBytes -= oldFd.fieldSize;
                    }
                    if (this._columnsToRemove[i]) continue;
                    recPos += oldFd.fieldSize;
                }
                System.arraycopy(record, 0, newRecord, 0, numRecBytes);
                recPos = 0;
                ++recPos;
                block4: for (i = 0; i < this._oldDescriptors.size(); ++i) {
                    oldFd = (DBFFieldDescriptor)this._oldDescriptors.get(i);
                    if (this._columnsToResize[i]) {
                        length = newRecord.length - (recPos + oldFd.fieldSize);
                        byte[] temp = new byte[oldFd.fieldSize];
                        System.arraycopy(newRecord, recPos, temp, 0, oldFd.fieldSize);
                        int tempRecordSize = newRecord.length;
                        System.arraycopy(newRecord, recPos + oldFd.fieldSize, newRecord, recPos, length);
                        for (int zz = 0; zz < this._fdList.length; ++zz) {
                            DBFFieldDescriptor newFd = this._fdList[zz];
                            if (!oldFd.fieldName.equalsIgnoreCase(newFd.fieldName)) continue;
                            numRecBytes -= oldFd.fieldSize;
                            System.arraycopy(newRecord, recPos, newRecord, recPos + newFd.fieldSize, (tempRecordSize -= newFd.fieldSize) - recPos);
                            int tempDataPos = temp.length - 1;
                            for (int yy = recPos + newFd.fieldSize - 1; yy >= recPos; --yy) {
                                newRecord[yy] = tempDataPos >= 0 ? temp[tempDataPos] : 32;
                                --tempDataPos;
                            }
                            recPos += this._fdList[zz].fieldSize;
                            numRecBytes += this._fdList[zz].fieldSize;
                            continue block4;
                        }
                        continue;
                    }
                    if (oldFd.fieldType == 'M') {
                        recPos += 10;
                        continue;
                    }
                    recPos += oldFd.fieldSize;
                }
                recPos = 0;
                ++recPos;
                for (i = 0; i < this._fdList.length; ++i) {
                    if (this._columnsToAdd[i]) {
                        int length2 = 0;
                        length2 = this._fdList[i].fieldType == 'M' ? (length2 += 10) : this._fdList[i].fieldSize;
                        if (i != this._fdList.length - 1) {
                            System.arraycopy(newRecord, recPos, newRecord, recPos + length2, numRecBytes - recPos);
                        }
                        if (this._fdList[i].fieldType == 'M' || this._fdList[i].fieldType == 'C') {
                            Arrays.fill(newRecord, recPos, recPos + length2, (byte)32);
                        } else if (this._fdList[i].fieldType == 'L') {
                            Arrays.fill(newRecord, recPos, recPos + 1, (byte)70);
                        } else {
                            byte[] undef_bytes = "-922".getBytes();
                            Arrays.fill(newRecord, recPos, recPos + length2, (byte)0);
                            for (int bPtr = 0; bPtr < length2 && bPtr < undef_bytes.length; ++bPtr) {
                                newRecord[recPos + bPtr] = undef_bytes[bPtr];
                            }
                        }
                        numRecBytes = this._fdList[i].fieldType == 'M' ? (numRecBytes += 10) : (numRecBytes += this._fdList[i].fieldSize);
                    }
                    if (this._fdList[i].fieldType == 'M') {
                        recPos += 10;
                        continue;
                    }
                    recPos += this._fdList[i].fieldSize;
                }
                this._newDBaseFileStream.write(newRecord, 0, numRecBytes);
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: Error occurred updating the DBFile in the method updateRecords");
            System.out.println(e.getMessage());
            e.printStackTrace();
            return;
        }
    }
}

