/*
 * Decompiled with CFR 0.152.
 */
package hec.io.dbf;

import codebase.Data4;
import codebase.Error4field;
import codebase.Error4message;
import codebase.Error4unexpected;
import codebase.Error4usage;
import codebase.Field4boolean;
import codebase.Field4date;
import codebase.Field4double;
import codebase.Field4stringBuffer;
import codebase.Field4stringBufferUnicode;
import hec.io.EndianInputStream;
import hec.io.dbf.AbstractDBFHeader;
import hec.io.dbf.DBFFieldDescriptor;
import hec.io.dbf.DBFHeader;
import hec.io.dbf.DBaseIIIHeader;
import hec.io.dbf.DBaseIVMemoHeader;
import hec.io.dbf.DbfConst;
import hec.io.dbf.Field4infoContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.List;
import java.util.Vector;

public class DbfUtil
implements DbfConst {
    public static Field4infoContainer buildField4infoContainer(DBFHeader header) throws Error4usage {
        Field4infoContainer f4infoC = new Field4infoContainer();
        List fieldDescriptors = header.getFieldDescriptors();
        for (int ii = 0; ii < fieldDescriptors.size(); ++ii) {
            DBFFieldDescriptor fd = (DBFFieldDescriptor)fieldDescriptors.get(ii);
            f4infoC.add(fd);
        }
        return f4infoC;
    }

    public static Vector buildField4Objects(Data4 data4, DBFHeader dbfHeader, String[] fieldNames) throws IOException, Error4usage, Error4unexpected, Error4field, Error4message {
        Vector<Field4stringBuffer> fieldObjects = new Vector<Field4stringBuffer>(fieldNames.length);
        for (int ii = 0; ii < fieldNames.length; ++ii) {
            DBFFieldDescriptor fieldDescriptor = dbfHeader.getFieldDescriptor(fieldNames[ii]);
            char fieldType = fieldDescriptor.getFieldType();
            Field4stringBuffer field4 = null;
            if (fieldType == 'B') {
                field4 = new Field4stringBuffer(data4, fieldNames[ii]);
            } else if (fieldType == 'C') {
                field4 = new Field4stringBuffer(data4, fieldNames[ii]);
            } else if (fieldType == 'D') {
                field4 = new Field4date(data4, fieldNames[ii]);
            } else if (fieldType == 'F') {
                field4 = new Field4double(data4, fieldNames[ii]);
            } else if (fieldType != 'G') {
                if (fieldType == 'L') {
                    field4 = new Field4boolean(data4, fieldNames[ii]);
                } else if (fieldType == 'M') {
                    field4 = new Field4stringBuffer(data4, fieldNames[ii]);
                } else if (fieldType == 'N') {
                    field4 = new Field4double(data4, fieldNames[ii]);
                } else if (fieldType == 'W') {
                    field4 = new Field4stringBufferUnicode(data4, fieldNames[ii]);
                }
            }
            if (field4 == null) continue;
            fieldObjects.add(field4);
        }
        return fieldObjects;
    }

    public static DBFHeader readHeader(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        FileInputStream fis = null;
        AbstractDBFHeader header = null;
        try {
            fis = new FileInputStream(file);
            PushbackInputStream pis = new PushbackInputStream(fis, 1);
            EndianInputStream reader = new EndianInputStream(pis);
            byte[] bytes = new byte[1];
            pis.read(bytes);
            pis.unread(bytes);
            if (bytes[0] == 3 ? (header = new DBaseIIIHeader()).readHeader(reader) : bytes[0] != -117 || (header = new DBaseIVMemoHeader()).readHeader(reader)) {
                // empty if block
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return header;
    }
}

