/*
 * Decompiled with CFR 0.152.
 */
package hec.io.dbf;

import hec.io.dbf.DbfRecordIndexSet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public class DefaultDbfRecordIndexSet
implements DbfRecordIndexSet {
    static final long serialVersionUID = 4858764209074023719L;
    String _indexFileName;
    String _indexTagName;
    HashSet _indexTagKeys = new HashSet();

    public DefaultDbfRecordIndexSet(String indexFileName, String indexTagName) {
        this(indexFileName, indexTagName, null);
    }

    public DefaultDbfRecordIndexSet(String indexTagName, Serializable[] indexTagKeys) {
        this(null, indexTagName, indexTagKeys);
    }

    public DefaultDbfRecordIndexSet(String indexFileName, String indexTagName, Serializable[] indexTagKeys) {
        this._indexFileName = indexFileName;
        this._indexTagName = indexTagName;
        if (indexTagKeys != null) {
            this._indexTagKeys.addAll(Arrays.asList(indexTagKeys));
        }
    }

    public DefaultDbfRecordIndexSet(DbfRecordIndexSet copyMe) {
        this._indexFileName = copyMe.getIndexFileName();
        this._indexTagName = copyMe.getIndexTagName();
        this._indexTagKeys.clear();
        Serializable[] tagKeys = copyMe.getIndexTagKeys();
        if (tagKeys != null && tagKeys.length > 0) {
            this._indexTagKeys.addAll(Arrays.asList(tagKeys));
        }
    }

    @Override
    public String getIndexFileName() {
        return this._indexFileName;
    }

    @Override
    public String getIndexTagName() {
        return this._indexTagName;
    }

    @Override
    public Serializable[] getIndexTagKeys() {
        Serializable[] indexTagKeys = new Serializable[this._indexTagKeys.size()];
        this._indexTagKeys.toArray(indexTagKeys);
        return indexTagKeys;
    }

    @Override
    public boolean hasIndex() {
        return this._indexTagName != null;
    }

    @Override
    public void printData() {
        System.out.println("Index tag and file name               : " + this._indexTagName + ", " + this._indexFileName);
        if (this._indexTagKeys.size() > 0) {
            int ii = 0;
            Iterator i = this._indexTagKeys.iterator();
            while (i.hasNext()) {
                System.out.println(ii + ": Index Tag Key = " + i.next());
                ++ii;
            }
        } else {
            System.out.println("No defined index tag keys.");
        }
    }
}

