/*
 * Decompiled with CFR 0.152.
 */
package hec.io.dbf;

import hec.io.dbf.DbfRecord;
import hec.io.dbf.DbfRecordQuery;
import hec.io.dbf.DbfRecordSet;
import hec.lang.Const;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class DefaultDbfRecordSet
extends DbfRecordQuery
implements DbfRecordSet {
    static final long serialVersionUID = -8706997931249245947L;
    List _recordList = new ArrayList();
    private Map _indexTagKeyMap = new HashMap();
    int _indexTagKeyColumn = Integer.MIN_VALUE;

    public DefaultDbfRecordSet(DbfRecordQuery query) {
        super(query);
    }

    public DefaultDbfRecordSet(String[] fieldNames) {
        super(null, fieldNames);
    }

    public DefaultDbfRecordSet(String tagName, String[] fieldNames) {
        super(tagName, fieldNames);
    }

    public DefaultDbfRecordSet(String tagName, String[] fieldNames, int indexTagKeyColumn) {
        super(tagName, fieldNames);
        this._indexTagKeyColumn = indexTagKeyColumn;
    }

    @Override
    public int size() {
        return this._recordList.size();
    }

    @Override
    public DbfRecord get(int i) {
        if (i < 0 || i >= this._recordList.size()) {
            return null;
        }
        return (DbfRecord)this._recordList.get(i);
    }

    @Override
    public void add(Serializable indexTagKey, Vector data) {
        this.add(new DbfRecord(indexTagKey, data));
    }

    private void addRecordWithIndexTagKey(DbfRecord rec) {
        Serializable indexTagKey = rec.getIndexTagKey();
        DbfRecord hashedRec = (DbfRecord)this._indexTagKeyMap.get(indexTagKey);
        int idx = -1;
        if (hashedRec != null) {
            hashedRec.copyDataInto(rec);
        } else {
            this.appendRecord(rec);
        }
    }

    @Override
    public void add(DbfRecord rec) {
        if (rec.hasIndexTagKey()) {
            this.addRecordWithIndexTagKey(rec);
        } else if (Const.isDefined(this._indexTagKeyColumn)) {
            rec.setIndexTagKeyColumn(this._indexTagKeyColumn);
            this.addRecordWithIndexTagKey(rec);
        } else {
            this.appendRecord(rec);
        }
    }

    private void appendRecord(DbfRecord rec) {
        this._recordList.add(rec);
        if (rec.hasIndexTagKey()) {
            this._indexTagKeyMap.put(rec.getIndexTagKey(), rec);
            this._indexTagKeys.add(rec.getIndexTagKey());
        }
    }

    @Override
    public Iterator iterator() {
        return this._recordList.iterator();
    }

    @Override
    public void printData() {
        super.printData();
        for (int ii = 0; ii < this._recordList.size(); ++ii) {
            DbfRecord rec = (DbfRecord)this._recordList.get(ii);
            rec.printData();
        }
    }
}

