/*
 * Decompiled with CFR 0.152.
 */
package hec.io.dbf;

import codebase.Data4jni;
import codebase.Error4locked;
import codebase.Error4message;
import codebase.Error4unexpected;
import codebase.Error4unique;
import codebase.Error4usage;
import hec.io.dbf.DbfRecordIndexSet;
import hec.io.dbf.DbfResultSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

public abstract class RecordHandler {
    Data4jni _data4Jni;
    DbfRecordIndexSet _recordIndexSet;
    DbfResultSet _resultSet;
    Vector _fieldObjects;

    public RecordHandler(Data4jni data4Jni, DbfRecordIndexSet recordIndexSet, DbfResultSet resultSet, Vector fieldObjects) {
        this._data4Jni = data4Jni;
        this._recordIndexSet = recordIndexSet;
        this._resultSet = resultSet;
        this._fieldObjects = fieldObjects;
    }

    public void process(int setRecordIndex, int dbfRecordNumber, Serializable indexTagKey) throws IOException, Error4message, Error4unexpected, Error4usage, Error4locked, Error4unique {
        try {
            Vector row = this.getRow(setRecordIndex);
            for (int ii = 0; ii < this._fieldObjects.size(); ++ii) {
                Object o = this._fieldObjects.get(ii);
                this.processRow(ii, row, o);
            }
            this.handleResults(setRecordIndex, dbfRecordNumber, indexTagKey, row);
        }
        catch (Exception e) {
            this.handleException(dbfRecordNumber, indexTagKey, e);
        }
    }

    public DbfResultSet getResultSet() {
        return this._resultSet;
    }

    protected abstract void handleException(int var1, Serializable var2, Exception var3);

    protected abstract Vector getRow(int var1);

    protected abstract void handleResults(int var1, int var2, Serializable var3, Vector var4) throws IOException, Error4message, Error4unexpected, Error4usage, Error4locked, Error4unique;

    protected abstract void processRow(int var1, Vector var2, Object var3) throws IOException, Error4message, Error4unexpected;
}

