/*
 * Decompiled with CFR 0.152.
 */
package hec.io.dbf;

import codebase.Data4jni;
import codebase.Error4locked;
import codebase.Error4message;
import codebase.Error4unexpected;
import codebase.Error4unique;
import codebase.Error4usage;
import codebase.Field4boolean;
import codebase.Field4byteArray;
import codebase.Field4date;
import codebase.Field4double;
import codebase.Field4stringBuffer;
import codebase.Field4stringBufferUnicode;
import hec.io.dbf.DbfRecord;
import hec.io.dbf.DbfRecordSet;
import hec.io.dbf.DbfWriteException;
import hec.io.dbf.DbfWriteResultSet;
import hec.io.dbf.RecordHandler;
import hec.lang.Const;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

public class WriteRecordHandler
extends RecordHandler {
    public WriteRecordHandler(Data4jni data4Jni, DbfRecordSet recordSet, DbfWriteResultSet resultSet, Vector fieldObjects) {
        super(data4Jni, recordSet, resultSet, fieldObjects);
    }

    @Override
    protected Vector getRow(int setRecordIndex) {
        DbfRecord record = ((DbfRecordSet)this._recordIndexSet).get(setRecordIndex);
        if (record == null) {
            return null;
        }
        return record.getData();
    }

    @Override
    protected void handleException(int dbfRecordNumber, Serializable indexTagKey, Exception e) {
        DbfWriteException dwe = new DbfWriteException(indexTagKey, e);
        this._resultSet.add(dwe);
    }

    @Override
    protected void handleResults(int setRecordIndex, int dbfRecordNumber, Serializable indexTagKey, Vector row) throws IOException, Error4message, Error4unexpected, Error4usage, Error4locked, Error4unique {
        if (Const.isValid(dbfRecordNumber)) {
            this._data4Jni.update();
        } else {
            this._data4Jni.append();
        }
    }

    @Override
    protected void processRow(int columnIndex, Vector row, Object o) throws IOException, Error4message, Error4unexpected {
        Serializable value = (Serializable)row.get(columnIndex);
        if (o instanceof Field4boolean && value instanceof Boolean) {
            Field4boolean field4 = (Field4boolean)o;
            field4.set((Boolean)value);
        } else if (o instanceof Field4byteArray && value instanceof byte[]) {
            Field4byteArray field4 = (Field4byteArray)o;
            field4.set((byte[])value);
        } else if (o instanceof Field4date && value instanceof Date) {
            Field4date field4 = (Field4date)o;
            field4.set((Date)value);
        } else if (o instanceof Field4double && value instanceof Float) {
            Field4double field4 = (Field4double)o;
            field4.set(new Double(((Float)value).doubleValue()));
        } else if (o instanceof Field4double && value instanceof Double) {
            Field4double field4 = (Field4double)o;
            field4.set((Double)value);
        } else if (o instanceof Field4double && value instanceof Integer) {
            Field4double field4 = (Field4double)o;
            field4.set(new Double(((Integer)value).doubleValue()));
        } else if (o instanceof Field4double && value instanceof Long) {
            Field4double field4 = (Field4double)o;
            field4.set(new Double(((Long)value).doubleValue()));
        } else if (o instanceof Field4stringBuffer && value instanceof StringBuffer) {
            Field4stringBuffer field4 = (Field4stringBuffer)o;
            field4.set((StringBuffer)value);
        } else if (o instanceof Field4stringBuffer && value instanceof String) {
            Field4stringBuffer field4 = (Field4stringBuffer)o;
            field4.set(new StringBuffer(value.toString()));
        } else if (o instanceof Field4stringBufferUnicode && value instanceof StringBuffer) {
            Field4stringBufferUnicode field4 = (Field4stringBufferUnicode)o;
            field4.set((StringBuffer)value);
        } else if (o instanceof Field4stringBufferUnicode && value instanceof String) {
            Field4stringBufferUnicode field4 = (Field4stringBufferUnicode)o;
            field4.set(new StringBuffer(value.toString()));
        }
    }
}

