/*
 * Decompiled with CFR 0.152.
 */
package hec.io.dbf.annotations;

import hec.io.dbf.annotations.Column;
import hec.io.dbf.annotations.Id;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import rma.services.annotations.ServiceProvider;

@SupportedAnnotationTypes(value={"hec.io.dbf.annotations.Column", "hec.io.dbf.annotations.Index"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@ServiceProvider(service=Processor.class)
public class AnnotationProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        int columnCount = 0;
        int idColumnCount = 0;
        for (Element element : roundEnv.getElementsAnnotatedWith(Column.class)) {
            if (element.getKind() != ElementKind.FIELD) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Can only annotate fields with @Column", element);
                continue;
            }
            VariableElement vElement = (VariableElement)element;
            Column annotation = vElement.getAnnotation(Column.class);
            if (annotation == null) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Annotation is null: " + vElement.getSimpleName() + ". ", element);
                continue;
            }
            if (annotation.name().length() > 10) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error with Column=" + vElement.getSimpleName() + ". Column names cannot be longer than 10 characters.", element);
                continue;
            }
            if (annotation.fieldType() == 'N' && annotation.fieldSize() > 32) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error with Column=" + vElement.getSimpleName() + ". Numeric coloumns cannot be larger than 32.", element);
                continue;
            }
            if (vElement.getAnnotation(Id.class) != null && ++idColumnCount > 1) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error with Column=" + vElement.getSimpleName() + ". Can only have one Id attribute.", element);
            }
            ++columnCount;
        }
        if (columnCount > 255) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "DBF supports a maximum of 255 columns.");
        }
        return true;
    }
}

