/*
 * Decompiled with CFR 0.152.
 */
package hec.io.dbf.types;

import hec.io.dbf.types.UserType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PrimitiveArrayToBinary
implements UserType {
    private Class enumClass;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;

    @Override
    public Class returnedClass() {
        return this.enumClass;
    }

    @Override
    public boolean equals(Object o, Object o1) {
        if (o == o1) {
            return true;
        }
        if (o == null || o1 == null) {
            return false;
        }
        return o.equals(o1);
    }

    @Override
    public int hashCode(Object o) {
        return o.hashCode();
    }

    @Override
    public Object nullSafeGet(InputStream is) throws IOException {
        Object arrayObj;
        ByteBuffer buffer = ByteBuffer.allocate(0);
        byte[] bytes = new byte[4096];
        int numBytesRead = -1;
        while ((numBytesRead = is.read(bytes)) != -1) {
            if (numBytesRead == 0) continue;
            if (buffer == null) {
                buffer = ByteBuffer.allocate(numBytesRead);
                buffer.put(bytes, 0, numBytesRead);
                continue;
            }
            ByteBuffer tempBuff = ByteBuffer.allocate(buffer.capacity());
            tempBuff.put(buffer.array());
            buffer = ByteBuffer.allocate(numBytesRead + tempBuff.capacity());
            buffer.put(tempBuff.array());
            buffer.put(bytes, 0, numBytesRead);
        }
        buffer.rewind();
        buffer.order(this.byteOrder);
        int numBytes = buffer.capacity();
        int numDimensions = 0;
        String primType = "";
        String arrayClassName = this.enumClass.getName();
        while (arrayClassName.startsWith("[")) {
            Class<?> arrayClass;
            ++numDimensions;
            try {
                arrayClass = Class.forName(arrayClassName);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(PrimitiveArrayToBinary.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
            if (arrayClass.isArray() && !arrayClass.getComponentType().isArray()) {
                primType = arrayClass.getComponentType().getName();
                break;
            }
            arrayClassName = arrayClassName.substring(1, arrayClassName.length());
        }
        int primitiveTypeNumBytes = 0;
        if (primType.equals("byte")) {
            primitiveTypeNumBytes = 1;
        } else if (primType.equals("char")) {
            primitiveTypeNumBytes = 2;
        } else if (primType.equals("double")) {
            primitiveTypeNumBytes = 8;
        } else if (primType.equals("float")) {
            primitiveTypeNumBytes = 4;
        } else if (primType.equals("int")) {
            primitiveTypeNumBytes = 4;
        } else if (primType.equals("long")) {
            primitiveTypeNumBytes = 8;
        } else if (primType.equals("short")) {
            primitiveTypeNumBytes = 2;
        } else if (primType.equals("boolean")) {
            primitiveTypeNumBytes = 1;
        }
        int numberOfDataValues = numBytes / primitiveTypeNumBytes;
        int numRows = numDimensions;
        int numValuesInRow = numberOfDataValues / numRows;
        Class<?> componentType = null;
        if (numDimensions == 1) {
            componentType = this.enumClass.getComponentType();
            arrayObj = Array.newInstance(componentType, numValuesInRow);
        } else {
            componentType = this.enumClass.getComponentType().getComponentType();
            arrayObj = Array.newInstance(componentType, numRows, numValuesInRow);
        }
        String componentTypeName = componentType.getName();
        for (int i = 0; i < numRows; ++i) {
            Object arrayValueObj = numRows > 1 ? Array.get(arrayObj, i) : arrayObj;
            for (int j = 0; j < numValuesInRow; ++j) {
                this.setArrayElement(componentTypeName, buffer, j, arrayValueObj);
            }
        }
        return arrayObj;
    }

    private void setArrayElement(String primType, ByteBuffer buffer, int idx, Object arrayObj) {
        try {
            if (primType.equals("double")) {
                Array.setDouble(arrayObj, idx, buffer.getDouble());
            } else if (primType.equals("float")) {
                Array.setFloat(arrayObj, idx, buffer.getFloat());
            } else if (primType.equals("int")) {
                Array.setInt(arrayObj, idx, buffer.getInt());
            } else if (primType.equals("long")) {
                Array.setLong(arrayObj, idx, buffer.getLong());
            } else if (primType.equals("short")) {
                Array.setShort(arrayObj, idx, buffer.getShort());
            } else if (primType.equals("boolean")) {
                Array.setBoolean(arrayObj, idx, buffer.get() == 1);
            } else if (primType.equals("byte")) {
                Array.setByte(arrayObj, idx, buffer.get());
            } else if (primType.equals("char")) {
                Array.setChar(arrayObj, idx, buffer.getChar());
            }
        }
        catch (NumberFormatException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage(), e);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public void nullSafeSet(OutputStream stream, Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (!value.getClass().isArray()) {
            System.err.println("ERROR: writeArray called with non Array - " + this.enumClass.toString());
            System.err.println("ERROR: This data is will not be saved");
            return;
        }
        this.writeArray(stream, value);
    }

    private void writeArray(OutputStream stream, Object value) throws IOException {
        if (value == null) {
            return;
        }
        String className = value.getClass().getName();
        Class<?> componentType = value.getClass().getComponentType();
        if (className.startsWith("[") && componentType.isArray()) {
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                Object componentValue = array[i];
                this.writeArray(stream, componentValue);
            }
        } else {
            this.writeElements(stream, componentType.getName(), value);
        }
    }

    private void writeElements(OutputStream stream, String primType, Object outputArray) throws IOException {
        ByteBuffer buffer = null;
        StringBuilder outline = new StringBuilder();
        outline.setLength(0);
        if (primType.equals("byte")) {
            byte[] array = (byte[])outputArray;
            buffer = ByteBuffer.allocate(array.length);
            buffer.order(this.byteOrder);
            buffer.put(array);
        } else if (primType.equals("char")) {
            char[] array = (char[])outputArray;
            int length = array.length;
            buffer = ByteBuffer.allocate(length * 2);
            buffer.order(this.byteOrder);
            for (int i = 0; i < length; ++i) {
                buffer.putChar(array[i]);
            }
        } else if (primType.equals("double")) {
            double[] array = (double[])outputArray;
            int length = array.length;
            buffer = ByteBuffer.allocate(length * 8);
            buffer.order(this.byteOrder);
            for (int i = 0; i < length; ++i) {
                buffer.putDouble(array[i]);
            }
        } else if (primType.equals("float")) {
            float[] array = (float[])outputArray;
            int length = array.length;
            buffer = ByteBuffer.allocate(length * 4);
            buffer.order(this.byteOrder);
            for (int i = 0; i < length; ++i) {
                float f = array[i];
                buffer.putFloat(f);
            }
        } else if (primType.equals("int")) {
            int[] array = (int[])outputArray;
            int length = array.length;
            buffer = ByteBuffer.allocate(length * 4);
            buffer.order(this.byteOrder);
            for (int i = 0; i < length; ++i) {
                int d = array[i];
                buffer.putInt(d);
            }
        } else if (primType.equals("long")) {
            long[] array = (long[])outputArray;
            int length = array.length;
            buffer = ByteBuffer.allocate(length * 8);
            buffer.order(this.byteOrder);
            for (int i = 0; i < length; ++i) {
                long l = array[i];
                buffer.putLong(l);
            }
        } else if (primType.equals("short")) {
            short[] array = (short[])outputArray;
            int length = array.length;
            buffer = ByteBuffer.allocate(length * 2);
            buffer.order(this.byteOrder);
            for (int i = 0; i < length; ++i) {
                buffer.putShort(array[i]);
            }
        } else if (primType.equals("boolean")) {
            boolean[] array = (boolean[])outputArray;
            int length = array.length;
            buffer = ByteBuffer.allocate(length);
            buffer.order(this.byteOrder);
            for (int i = 0; i < length; ++i) {
                byte b = (byte)(array[i] ? 1 : 0);
                buffer.put(b);
            }
        }
        if (buffer != null) {
            stream.write(buffer.array());
        }
    }

    @Override
    public void setParameterValues(Properties prprts) throws IOException {
        String enumClassName = prprts.getProperty("PrimitiveType");
        String strByteOrder = prprts.getProperty("ByteOrder");
        if (enumClassName == null) {
            throw new IOException("PrimitiveArrayToBinary.setParameterValues(): Primitive type property not defined");
        }
        try {
            this.enumClass = Class.forName(enumClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("PrimitiveArrayToBinary.setParameterValues(): Primitive type class not found - " + enumClassName, cnfe);
        }
        if (strByteOrder != null) {
            if (ByteOrder.LITTLE_ENDIAN.toString().equals(strByteOrder)) {
                this.byteOrder = ByteOrder.LITTLE_ENDIAN;
            } else if (ByteOrder.BIG_ENDIAN.toString().equals(strByteOrder)) {
                this.byteOrder = ByteOrder.BIG_ENDIAN;
            } else {
                throw new IOException("PrimitiveArrayToBinary.setParameterValues(): \"" + strByteOrder + "\" is unknown. Use ByteOrder.BIG_ENDIAN or ByteOrder.LITTLE_ENDIAN");
            }
        }
    }
}

