/*
 * Decompiled with CFR 0.152.
 */
package hec.jms;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MapMessage;

public abstract class GenericMessage {
    private static Map<Class, MessageDefinition> messageTypeMap = new HashMap<Class, MessageDefinition>();
    private MapMessage mapMessage;

    protected static void addClass(Class<? extends GenericMessage> clazz, MessageDefinition definition) {
        messageTypeMap.put(clazz, definition);
    }

    public static Set<String> getRequiredMapKeys(Class clazz) {
        MessageDefinition definition = messageTypeMap.get(clazz);
        if (definition == null) {
            return null;
        }
        return definition.getRequiredMapKeys();
    }

    public static String getClassType(Class clazz) {
        MessageDefinition definition = messageTypeMap.get(clazz);
        if (definition == null) {
            return null;
        }
        return definition.getType();
    }

    public static String getClassSubType(Class clazz) {
        MessageDefinition definition = messageTypeMap.get(clazz);
        if (definition == null) {
            return null;
        }
        return definition.getSubType();
    }

    public GenericMessage(MapMessage mapMessage) {
        this.mapMessage = mapMessage;
    }

    public Map<String, Object> getMap() throws JMSException {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        Enumeration mapNames = this.mapMessage.getMapNames();
        if (mapNames != null) {
            while (mapNames.hasMoreElements()) {
                String key = (String)mapNames.nextElement();
                if (key == null) continue;
                Object value = this.mapMessage.getObject(key);
                retval.put(key, value);
            }
        }
        return retval;
    }

    public String getString(String key) throws JMSException {
        String value = this.mapMessage.getString(key);
        return value;
    }

    public long getLong(String key) throws JMSException {
        long value = this.mapMessage.getLong(key);
        return value;
    }

    public int getInt(String key) throws JMSException {
        int value = this.mapMessage.getInt(key);
        return value;
    }

    protected String getBody() throws JMSException {
        String body = this.getString("body");
        return body;
    }

    public String getType() throws JMSException {
        String type = this.getString("type");
        return type;
    }

    public String getSubType() throws JMSException {
        String subType = this.getString("subtype");
        return subType;
    }

    public long getCreationTime() throws JMSException {
        long millis = this.getLong("millis");
        return millis;
    }

    protected static class MessageDefinition {
        private String type;
        private String subType;
        private Set<String> requiredMapKeys;

        public MessageDefinition(String type, String subType) {
            this(type, subType, null);
        }

        public MessageDefinition(String type, String subType, Set<String> requiredMapKeys) {
            this.type = type;
            this.subType = subType;
            this.requiredMapKeys = requiredMapKeys;
        }

        public Set<String> getRequiredMapKeys() {
            return this.requiredMapKeys;
        }

        public String getType() {
            return this.type;
        }

        public String getSubType() {
            return this.subType;
        }
    }
}

