/*
 * Decompiled with CFR 0.152.
 */
package hec.lang;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Const
implements Serializable {
    public static final float UNDEFINED_FLOAT = -3.4028235E38f;
    public static final double UNDEFINED_DOUBLE = -3.4028234663852886E38;
    public static final int UNDEFINED_INT = Integer.MIN_VALUE;
    public static final long UNDEFINED_LONG = Long.MIN_VALUE;
    public static final long UNDEFINED_TIME = Long.MIN_VALUE;
    private static final float PRACTICAL_UNDEFINED_MIN_VALUE = -1.7014117E38f;
    public static final int DELETE_INSERT = 100;
    public static final int REPLACE_ALL = 101;
    public static final int DO_NOT_REPLACE = 102;
    public static final int REPLACE_MISSING_VALUES_ONLY = 103;
    public static final int REPLACE_WITH_NON_MISSING = 104;
    public static final String Delete_Insert = "Delete Insert";
    public static final String Replace_All = "Replace All";
    public static final String Do_Not_Replace = "Do Not Replace";
    public static final String Replace_Missing_Values_Only = "Replace Missing Values Only";
    public static final String Replace_With_Non_Missing = "Replace With Non Missing";
    public static final String Override_Protection = "Override Protection";
    private static final String IRREGULAR_INTERVAL_SYSTEM_PROPERTY = "irregular-interval";
    private static final String REGULAR_INTERVAL_SYSTEM_PROPERTY = "regular-interval";
    private static final String OVERRIDE_PROTECTION_SYSTEM_PROPERTY = "override-protection";
    private static final String STORE_RULE_SYSTEM_PROPERTY = "store-rule";
    public static final String[] RULES = new String[]{"Delete Insert", "Replace All", "Do Not Replace", "Replace Missing Values Only", "Replace With Non Missing"};
    public static final int[] RULE_NUMBERS = new int[]{100, 101, 102, 103, 104};

    public static int getRuleNumber(String rule) {
        String upperRule = rule.toUpperCase();
        for (int ii = 0; ii < RULES.length; ++ii) {
            if (upperRule.indexOf(RULES[ii].toUpperCase()) == -1) continue;
            return RULE_NUMBERS[ii];
        }
        return Integer.MIN_VALUE;
    }

    public static boolean getOverrideProtection(String rule) {
        String upperRule = rule.toUpperCase();
        return upperRule.indexOf(Override_Protection.toUpperCase()) != -1;
    }

    public static String getRule(int num) {
        for (int ii = 0; ii < RULE_NUMBERS.length; ++ii) {
            if (RULE_NUMBERS[ii] != num) continue;
            return RULES[ii];
        }
        return null;
    }

    public static boolean isDefined(float x) {
        return x != -3.4028235E38f;
    }

    public static boolean isUndefined(float x) {
        return x == -3.4028235E38f;
    }

    public static boolean isValid(float x) {
        return x != -3.4028235E38f;
    }

    public static boolean isNotValid(float x) {
        return x == -3.4028235E38f;
    }

    public static boolean isDefined(double x) {
        return x != -3.4028234663852886E38 && x != Double.NEGATIVE_INFINITY;
    }

    public static boolean isUndefined(double x) {
        return x == -3.4028234663852886E38 || x == Double.NEGATIVE_INFINITY;
    }

    public static boolean isValid(double x) {
        return x != -3.4028234663852886E38 && x != Double.NEGATIVE_INFINITY;
    }

    public static boolean isNotValid(double x) {
        return x == -3.4028234663852886E38 || x == Double.NEGATIVE_INFINITY;
    }

    public static boolean isDefined(int x) {
        return x != Integer.MIN_VALUE;
    }

    public static boolean isUndefined(int x) {
        return x == Integer.MIN_VALUE;
    }

    public static boolean isValid(int x) {
        return x != Integer.MIN_VALUE;
    }

    public static boolean isNotValid(int x) {
        return x == Integer.MIN_VALUE;
    }

    public static boolean isDefined(long x) {
        return x != Long.MIN_VALUE;
    }

    public static boolean isUndefined(long x) {
        return x == Long.MIN_VALUE;
    }

    public static boolean isValid(long x) {
        return x != Long.MIN_VALUE;
    }

    public static boolean isNotValid(long x) {
        return x == Long.MIN_VALUE;
    }

    public static boolean isPracticallyUndefined(float x) {
        return x < -1.7014117E38f;
    }

    public static boolean isPracticallyUndefined(double x) {
        return x < -1.7014117331926443E38;
    }

    public static float getUndefinedFromPracticallyUndefined(float x) {
        if (x < -1.7014117E38f) {
            return -3.4028235E38f;
        }
        return x;
    }

    public static double getUndefinedFromPracticallyUndefined(double x) {
        if (x < -1.7014117331926443E38) {
            return -3.4028234663852886E38;
        }
        return x;
    }

    public static boolean getSystemRegularOverrideProtection(String namedPropertyKey) {
        return Const.getSystemRegularOverrideProtection(namedPropertyKey, false);
    }

    public static boolean getSystemIrregularOverrideProtection(String namedPropertyKey) {
        return Const.getSystemIrregularOverrideProtection(namedPropertyKey, false);
    }

    public static boolean getSystemRegularOverrideProtection(String namedPropertyKey, boolean defaultOverrideProtection) {
        return Const.getSystemOverrideProtection(namedPropertyKey, REGULAR_INTERVAL_SYSTEM_PROPERTY, defaultOverrideProtection);
    }

    public static boolean getSystemIrregularOverrideProtection(String namedPropertyKey, boolean defaultOverrideProtection) {
        return Const.getSystemOverrideProtection(namedPropertyKey, IRREGULAR_INTERVAL_SYSTEM_PROPERTY, defaultOverrideProtection);
    }

    public static String getSystemIrregularStoreRule(String namedPropertyKey) {
        return Const.getSystemIrregularStoreRule(namedPropertyKey, Replace_All);
    }

    public static String getSystemRegularStoreRule(String namedPropertyKey) {
        return Const.getSystemRegularStoreRule(namedPropertyKey, Replace_All);
    }

    public static String getSystemIrregularStoreRule(String namedPropertyKey, String defaultStoreRule) {
        String storeRuleIrregular = Const.getSystemStoreRule(namedPropertyKey, IRREGULAR_INTERVAL_SYSTEM_PROPERTY, defaultStoreRule);
        return storeRuleIrregular.replace("_", " ");
    }

    public static String getSystemRegularStoreRule(String namedPropertyKey, String defaultStoreRule) {
        String storeRuleRegular = Const.getSystemStoreRule(namedPropertyKey, REGULAR_INTERVAL_SYSTEM_PROPERTY, defaultStoreRule);
        return storeRuleRegular.replace("_", " ");
    }

    private static boolean getSystemOverrideProtection(String namedPropertyKey, String regularIntervalProperty, boolean defaultOverrideProtection) {
        String propertyKey = Const.buildProperty(namedPropertyKey, OVERRIDE_PROTECTION_SYSTEM_PROPERTY, regularIntervalProperty);
        String propertyValue = System.getProperty(propertyKey);
        if (propertyValue == null) {
            propertyValue = Boolean.toString(defaultOverrideProtection);
            Logger logger = Logger.getLogger(Const.class.getName());
            if (logger.isLoggable(Level.CONFIG)) {
                logger.config(String.format("Property %s is undefined.", propertyKey));
                logger.config("Override Protection defaulted to: " + propertyValue + ".");
            }
        }
        return Boolean.valueOf(propertyValue);
    }

    private static String getSystemStoreRule(String namedPropertyKey, String propertyType, String defaultValue) {
        String propertyKey = Const.buildProperty(namedPropertyKey, STORE_RULE_SYSTEM_PROPERTY, propertyType);
        String propertyValue = System.getProperty(propertyKey);
        if (propertyValue == null) {
            propertyValue = defaultValue;
            Logger logger = Logger.getLogger(Const.class.getName());
            if (logger.isLoggable(Level.CONFIG)) {
                logger.config(String.format("Property %s is undefined.", propertyKey));
                logger.config(String.format("Store Rule defaulted to: %s.", propertyValue));
            }
        }
        return propertyValue;
    }

    private static String buildProperty(String namedPropertyKey, String propertyType, String intervalType) {
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append(namedPropertyKey).append("." + propertyType + ".").append(intervalType).toString();
    }
}

