/*
 * Decompiled with CFR 0.152.
 */
package hec.lang;

import java.io.Serializable;
import java.util.StringTokenizer;

public class DSSPathString
implements Serializable {
    public static final int APART = 0;
    public static final int BPART = 1;
    public static final int CPART = 2;
    public static final int DPART = 3;
    public static final int EPART = 4;
    public static final int FPART = 5;
    public static final int MAX_PART_LEN = 64;
    public static final int MAX_PATH_LEN = 384;
    public static final String DELIM = "/";
    String[] _parts = new String[6];

    public DSSPathString() {
    }

    public DSSPathString(String p) {
        this.setPathname(p);
    }

    public DSSPathString(String a, String b, String c2, String d, String e, String f) {
        this.setPathname(a, b, c2, d, e, f);
    }

    public DSSPathString(String[] sa) {
        this.setPathname(sa);
    }

    public String toString() {
        if (!this.isValid()) {
            return "Invalid DSSPathString";
        }
        String str = DELIM + this._parts[0] + DELIM + this._parts[1] + DELIM + this._parts[2] + DELIM + this._parts[3] + DELIM + this._parts[4] + DELIM + this._parts[5] + DELIM;
        return str;
    }

    public void setPathname(String[] sa) {
        if (sa == null || sa.length != 6) {
            return;
        }
        this._parts = sa;
    }

    public String getPathname() {
        if (!this.isValid()) {
            return null;
        }
        String str = DELIM + this._parts[0] + DELIM + this._parts[1] + DELIM + this._parts[2] + DELIM + this._parts[3] + DELIM + this._parts[4] + DELIM + this._parts[5] + DELIM;
        return str;
    }

    public static String getPathname(String[] parts) {
        if (parts == null || parts.length != 6) {
            return "";
        }
        DSSPathString.cleanPathParts(parts);
        String str = DELIM + parts[0] + DELIM + parts[1] + DELIM + parts[2] + DELIM + parts[3] + DELIM + parts[4] + DELIM + parts[5] + DELIM;
        return str;
    }

    public void setPathname(String a, String b, String c2, String d, String e, String f) {
        this._parts[0] = a;
        this._parts[1] = b;
        this._parts[2] = c2;
        this._parts[3] = d;
        this._parts[4] = e;
        this._parts[5] = f;
        this.cleanPathParts();
    }

    public void setPathname(String pathname) {
        String[] sa = DSSPathString.parsePathname(pathname);
        if (sa == null) {
            return;
        }
        this._parts = sa;
        this.cleanPathParts();
    }

    public static String[] parsePathname(String pathname) {
        if (pathname == null) {
            return null;
        }
        pathname = pathname.trim();
        String delim = DELIM;
        StringTokenizer tok = new StringTokenizer(pathname, delim, true);
        int tokcnt = tok.countTokens();
        String[] sa = new String[6];
        int icnt = 0;
        String str = tok.nextToken();
        while (tok.hasMoreTokens() && icnt < 6) {
            str = tok.nextToken();
            if (str.equals(delim)) {
                sa[icnt] = "";
                ++icnt;
                continue;
            }
            sa[icnt] = str;
            str = tok.nextToken();
            if (!str.equals(delim)) break;
            ++icnt;
        }
        if (icnt != 6) {
            return null;
        }
        return sa;
    }

    public static int parsePathname(String pathname, int[] slashPositions) {
        int istart = 1;
        slashPositions[0] = 1;
        for (int i = 1; i < 7; ++i) {
            int ipos = pathname.indexOf(DELIM, istart);
            if (ipos < 0) {
                return i;
            }
            slashPositions[i] = istart = ipos + 1;
        }
        return 0;
    }

    public String getPart(int p) {
        if (this._parts == null || p < 0 || p > 5) {
            return null;
        }
        return this._parts[p];
    }

    public void setPart(String s, int p) {
        if (this._parts == null) {
            this._parts = new String[6];
        }
        this._parts[p] = s;
        this.cleanPathParts();
    }

    public String getAPart() {
        if (this._parts == null) {
            return null;
        }
        return this._parts[0];
    }

    public String getBPart() {
        if (this._parts == null) {
            return null;
        }
        return this._parts[1];
    }

    public String getCPart() {
        if (this._parts == null) {
            return null;
        }
        return this._parts[2];
    }

    public String getDPart() {
        if (this._parts == null) {
            return null;
        }
        return this._parts[3];
    }

    public String getEPart() {
        if (this._parts == null) {
            return null;
        }
        return this._parts[4];
    }

    public String getFPart() {
        if (this._parts == null) {
            return null;
        }
        return this._parts[5];
    }

    public void setAPart(String s) {
        if (this._parts == null) {
            this._parts = new String[6];
        }
        this._parts[0] = s;
        this.cleanPathParts();
    }

    public void setBPart(String s) {
        if (this._parts == null) {
            this._parts = new String[6];
        }
        this._parts[1] = s;
        this.cleanPathParts();
    }

    public void setCPart(String s) {
        if (this._parts == null) {
            this._parts = new String[6];
        }
        this._parts[2] = s;
        this.cleanPathParts();
    }

    public void setDPart(String s) {
        if (this._parts == null) {
            this._parts = new String[6];
        }
        this._parts[3] = s;
        this.cleanPathParts();
    }

    public void setEPart(String s) {
        if (this._parts == null) {
            this._parts = new String[6];
        }
        this._parts[4] = s;
        this.cleanPathParts();
    }

    public void setFPart(String s) {
        if (this._parts == null) {
            this._parts = new String[6];
        }
        this._parts[5] = s;
        this.cleanPathParts();
    }

    public boolean isValid() {
        if (this._parts == null) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (this._parts[i] != null) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(String pathname) {
        String[] sa = DSSPathString.parsePathname(pathname);
        if (sa == null) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (sa[i] != null) continue;
            return false;
        }
        return true;
    }

    public void cleanPathParts() {
        DSSPathString.cleanPathParts(this._parts);
    }

    public static void cleanPathParts(String[] parts) {
        if (parts == null || parts.length != 6) {
            return;
        }
        int icnt = 0;
        for (int i = 0; i < 6; ++i) {
            if (parts[i].length() > 64) {
                parts[i] = parts[i].substring(0, 64);
            }
            icnt += parts[i].length();
        }
        int[] iorder = new int[]{2, 0, 5, 1};
        if (icnt > 384) {
            for (int j = 0; j < iorder.length; ++j) {
                int del = icnt - 384;
                int l = parts[iorder[j]].length();
                if (l <= del) {
                    parts[iorder[j]] = "";
                    icnt -= l;
                } else if (l > del) {
                    parts[iorder[j]] = parts[iorder[j]].substring(0, l - del);
                    icnt -= del;
                }
                if (icnt <= 384) break;
            }
        }
    }
}

